/*
 * Decompiled with CFR 0.152.
 */
package net.esper.eql.join.exec;

import java.util.List;
import java.util.Set;
import net.esper.eql.join.exec.ExecNode;
import net.esper.eql.join.exec.TableLookupStrategy;
import net.esper.event.EventBean;
import net.esper.util.IndentWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableOuterLookupExecNode
extends ExecNode {
    private int indexedStream;
    private TableLookupStrategy lookupStrategy;

    public TableOuterLookupExecNode(int indexedStream, TableLookupStrategy lookupStrategy) {
        this.indexedStream = indexedStream;
        this.lookupStrategy = lookupStrategy;
    }

    public TableLookupStrategy getLookupStrategy() {
        return this.lookupStrategy;
    }

    @Override
    public void process(EventBean lookupEvent, EventBean[] prefillPath, List<EventBean[]> result) {
        Set<EventBean> joinedEvents = this.lookupStrategy.lookup(lookupEvent);
        if (joinedEvents == null || joinedEvents.isEmpty()) {
            EventBean[] events = new EventBean[prefillPath.length];
            System.arraycopy(prefillPath, 0, events, 0, events.length);
            result.add(events);
            return;
        }
        for (EventBean joinedEvent : joinedEvents) {
            EventBean[] events = new EventBean[prefillPath.length];
            System.arraycopy(prefillPath, 0, events, 0, events.length);
            events[this.indexedStream] = joinedEvent;
            result.add(events);
        }
    }

    public int getIndexedStream() {
        return this.indexedStream;
    }

    @Override
    public void print(IndentWriter writer) {
        writer.println("TableOuterLookupExecNode indexedStream=" + this.indexedStream + " lookup=" + this.lookupStrategy);
    }
}

