/*
 * Decompiled with CFR 0.152.
 */
package net.esper.eql.join.plan;

import java.util.Arrays;
import net.esper.eql.join.exec.LookupInstructionExec;
import net.esper.eql.join.exec.TableLookupStrategy;
import net.esper.eql.join.plan.TableLookupPlan;
import net.esper.eql.join.table.EventTable;
import net.esper.event.EventType;
import net.esper.util.IndentWriter;

public class LookupInstructionPlan {
    private final int fromStream;
    private final String fromStreamName;
    private final int[] toStreams;
    private final TableLookupPlan[] lookupPlans;
    private final boolean[] requiredPerStream;

    public LookupInstructionPlan(int fromStream, String fromStreamName, int[] toStreams, TableLookupPlan[] lookupPlans, boolean[] requiredPerStream) {
        if (toStreams.length != lookupPlans.length) {
            throw new IllegalArgumentException("Invalid number of lookup plans for each stream");
        }
        if (requiredPerStream.length < lookupPlans.length) {
            throw new IllegalArgumentException("Invalid required per stream array");
        }
        if (fromStream < 0 || fromStream >= requiredPerStream.length) {
            throw new IllegalArgumentException("Invalid from stream");
        }
        this.fromStream = fromStream;
        this.fromStreamName = fromStreamName;
        this.toStreams = toStreams;
        this.lookupPlans = lookupPlans;
        this.requiredPerStream = requiredPerStream;
    }

    public LookupInstructionExec makeExec(EventTable[][] indexesPerStream, EventType[] streamTypes) {
        TableLookupStrategy[] strategies = new TableLookupStrategy[this.lookupPlans.length];
        for (int i = 0; i < this.lookupPlans.length; ++i) {
            strategies[i] = this.lookupPlans[i].makeStrategy(indexesPerStream, streamTypes);
        }
        return new LookupInstructionExec(this.fromStream, this.fromStreamName, this.toStreams, strategies, this.requiredPerStream);
    }

    public void print(IndentWriter writer) {
        writer.println("LookupInstructionPlan fromStream=" + this.fromStream + " fromStreamName=" + this.fromStreamName + " toStreams=" + Arrays.toString(this.toStreams));
        writer.incrIndent();
        for (int i = 0; i < this.lookupPlans.length; ++i) {
            writer.println("plan " + i + " :" + this.lookupPlans[i].toString());
        }
        writer.decrIndent();
    }
}

