/*
 * Decompiled with CFR 0.152.
 */
package net.esper.eql.join.plan;

import java.util.Arrays;
import java.util.List;
import net.esper.eql.join.assemble.BaseAssemblyNode;
import net.esper.eql.join.exec.ExecNode;
import net.esper.eql.join.exec.LookupInstructionExec;
import net.esper.eql.join.exec.LookupInstructionExecNode;
import net.esper.eql.join.plan.LookupInstructionPlan;
import net.esper.eql.join.plan.QueryPlanNode;
import net.esper.eql.join.table.EventTable;
import net.esper.event.EventType;
import net.esper.util.IndentWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LookupInstructionQueryPlanNode
extends QueryPlanNode {
    private final int rootStream;
    private final String rootStreamName;
    private final int numStreams;
    private final List<LookupInstructionPlan> lookupInstructions;
    private final boolean[] requiredPerStream;
    private final List<BaseAssemblyNode> assemblyInstructions;

    public LookupInstructionQueryPlanNode(int rootStream, String rootStreamName, int numStreams, boolean[] requiredPerStream, List<LookupInstructionPlan> lookupInstructions, List<BaseAssemblyNode> assemblyInstructions) {
        this.rootStream = rootStream;
        this.rootStreamName = rootStreamName;
        this.lookupInstructions = lookupInstructions;
        this.numStreams = numStreams;
        this.requiredPerStream = requiredPerStream;
        this.assemblyInstructions = assemblyInstructions;
    }

    @Override
    public ExecNode makeExec(EventTable[][] indexesPerStream, EventType[] streamTypes) {
        LookupInstructionExec[] execs = new LookupInstructionExec[this.lookupInstructions.size()];
        int count = 0;
        for (LookupInstructionPlan instruction : this.lookupInstructions) {
            LookupInstructionExec exec;
            execs[count] = exec = instruction.makeExec(indexesPerStream, streamTypes);
            ++count;
        }
        return new LookupInstructionExecNode(this.rootStream, this.rootStreamName, this.numStreams, execs, this.requiredPerStream, this.assemblyInstructions.toArray(new BaseAssemblyNode[0]));
    }

    @Override
    protected void print(IndentWriter writer) {
        int i;
        writer.println("LookupInstructionQueryPlanNode rootStream=" + this.rootStream + " requiredPerStream=" + Arrays.toString(this.requiredPerStream));
        writer.incrIndent();
        for (i = 0; i < this.lookupInstructions.size(); ++i) {
            writer.println("lookup step " + i);
            writer.incrIndent();
            this.lookupInstructions.get(i).print(writer);
            writer.decrIndent();
        }
        writer.decrIndent();
        writer.incrIndent();
        for (i = 0; i < this.assemblyInstructions.size(); ++i) {
            writer.println("assembly step " + i);
            writer.incrIndent();
            this.assemblyInstructions.get(i).print(writer);
            writer.decrIndent();
        }
        writer.decrIndent();
    }
}

