/*
 * Decompiled with CFR 0.152.
 */
package net.esper.eql.join.plan;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.esper.eql.join.assemble.AssemblyStrategyTreeBuilder;
import net.esper.eql.join.assemble.BaseAssemblyNode;
import net.esper.eql.join.plan.LookupInstructionPlan;
import net.esper.eql.join.plan.LookupInstructionQueryPlanNode;
import net.esper.eql.join.plan.NStreamQueryPlanBuilder;
import net.esper.eql.join.plan.OuterInnerDirectionalGraph;
import net.esper.eql.join.plan.QueryGraph;
import net.esper.eql.join.plan.QueryPlan;
import net.esper.eql.join.plan.QueryPlanIndex;
import net.esper.eql.join.plan.QueryPlanIndexBuilder;
import net.esper.eql.join.plan.QueryPlanNode;
import net.esper.eql.join.plan.TableLookupPlan;
import net.esper.eql.spec.OuterJoinDesc;
import net.esper.event.EventType;
import net.esper.type.OuterJoinType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NStreamOuterQueryPlanBuilder {
    private static Log log = LogFactory.getLog(NStreamOuterQueryPlanBuilder.class);

    protected static QueryPlan build(QueryGraph queryGraph, List<OuterJoinDesc> outerJoinDescList, String[] streamNames, EventType[] typesPerStream) {
        if (log.isDebugEnabled()) {
            log.debug(".build queryGraph=" + queryGraph);
        }
        int numStreams = queryGraph.getNumStreams();
        QueryPlanNode[] planNodeSpecs = new QueryPlanNode[numStreams];
        QueryPlanIndex[] indexSpecs = QueryPlanIndexBuilder.buildIndexSpec(queryGraph);
        if (log.isDebugEnabled()) {
            log.debug(".build Index build completed, indexes=" + QueryPlanIndex.print(indexSpecs));
        }
        OuterInnerDirectionalGraph outerInnerGraph = NStreamOuterQueryPlanBuilder.graphOuterJoins(numStreams, outerJoinDescList);
        if (log.isDebugEnabled()) {
            log.debug(".build directional graph=" + outerInnerGraph.print());
        }
        for (int streamNo = 0; streamNo < numStreams; ++streamNo) {
            QueryPlanNode queryPlanNode = NStreamOuterQueryPlanBuilder.build(numStreams, streamNo, streamNames, queryGraph, outerInnerGraph, indexSpecs, typesPerStream);
            if (log.isDebugEnabled()) {
                log.debug(".build spec for stream '" + streamNames[streamNo] + "' number " + streamNo + " is " + queryPlanNode);
            }
            planNodeSpecs[streamNo] = queryPlanNode;
        }
        QueryPlan queryPlan = new QueryPlan(indexSpecs, planNodeSpecs);
        if (log.isDebugEnabled()) {
            log.debug(".build query plan=" + queryPlan.toString());
        }
        return queryPlan;
    }

    private static QueryPlanNode build(int numStreams, int streamNo, String[] streamNames, QueryGraph queryGraph, OuterInnerDirectionalGraph outerInnerGraph, QueryPlanIndex[] indexSpecs, EventType[] typesPerStream) {
        LinkedHashMap<Integer, int[]> substreamsPerStream = new LinkedHashMap<Integer, int[]>();
        boolean[] requiredPerStream = new boolean[numStreams];
        HashSet<Integer> completedStreams = new HashSet<Integer>();
        NStreamOuterQueryPlanBuilder.recursiveBuild(streamNo, queryGraph, outerInnerGraph, completedStreams, substreamsPerStream, requiredPerStream);
        NStreamOuterQueryPlanBuilder.verifyJoinedPerStream(streamNo, substreamsPerStream);
        List<LookupInstructionPlan> lookupInstructions = NStreamOuterQueryPlanBuilder.buildLookupInstructions(substreamsPerStream, requiredPerStream, streamNames, queryGraph, indexSpecs, typesPerStream);
        BaseAssemblyNode assemblyTopNode = AssemblyStrategyTreeBuilder.build(streamNo, substreamsPerStream, requiredPerStream);
        List<BaseAssemblyNode> assemblyInstructions = BaseAssemblyNode.getDescendentNodesBottomUp(assemblyTopNode);
        return new LookupInstructionQueryPlanNode(streamNo, streamNames[streamNo], numStreams, requiredPerStream, lookupInstructions, assemblyInstructions);
    }

    private static List<LookupInstructionPlan> buildLookupInstructions(LinkedHashMap<Integer, int[]> substreamsPerStream, boolean[] requiredPerStream, String[] streamNames, QueryGraph queryGraph, QueryPlanIndex[] indexSpecs, EventType[] typesPerStream) {
        LinkedList<LookupInstructionPlan> result = new LinkedList<LookupInstructionPlan>();
        for (int fromStream : substreamsPerStream.keySet()) {
            int[] substreams = substreamsPerStream.get(fromStream);
            if (substreams.length == 0) continue;
            TableLookupPlan[] plans = new TableLookupPlan[substreams.length];
            for (int i = 0; i < substreams.length; ++i) {
                TableLookupPlan tableLookupPlan;
                int toStream = substreams[i];
                plans[i] = tableLookupPlan = NStreamQueryPlanBuilder.createLookupPlan(queryGraph, fromStream, toStream, indexSpecs[toStream], typesPerStream);
            }
            String fromStreamName = streamNames[fromStream];
            LookupInstructionPlan instruction = new LookupInstructionPlan(fromStream, fromStreamName, substreams, plans, requiredPerStream);
            result.add(instruction);
        }
        return result;
    }

    protected static void recursiveBuild(int streamNum, QueryGraph queryGraph, OuterInnerDirectionalGraph outerInnerGraph, Set<Integer> completedStreams, LinkedHashMap<Integer, int[]> substreamsPerStream, boolean[] requiredPerStream) {
        completedStreams.add(streamNum);
        Set<Integer> navigableStreams = queryGraph.getNavigableStreams(streamNum);
        navigableStreams.removeAll(completedStreams);
        Set<Integer> requiredStreams = NStreamOuterQueryPlanBuilder.getOuterStreams(streamNum, navigableStreams, outerInnerGraph);
        Set<Integer> optionalStreams = NStreamOuterQueryPlanBuilder.getInnerStreams(streamNum, navigableStreams, outerInnerGraph);
        requiredStreams.removeAll(optionalStreams);
        if (navigableStreams.size() != requiredStreams.size() + optionalStreams.size()) {
            throw new IllegalArgumentException("Navigable streams size not constisting of inner and outer streams");
        }
        if (navigableStreams.isEmpty()) {
            substreamsPerStream.put(streamNum, new int[0]);
            return;
        }
        int[] substreams = new int[requiredStreams.size() + optionalStreams.size()];
        substreamsPerStream.put(streamNum, substreams);
        int count = 0;
        for (int stream : requiredStreams) {
            substreams[count++] = stream;
            requiredPerStream[stream] = true;
        }
        for (int stream : optionalStreams) {
            substreams[count++] = stream;
        }
        for (int stream : requiredStreams) {
            NStreamOuterQueryPlanBuilder.recursiveBuild(stream, queryGraph, outerInnerGraph, completedStreams, substreamsPerStream, requiredPerStream);
        }
        for (int stream : optionalStreams) {
            NStreamOuterQueryPlanBuilder.recursiveBuild(stream, queryGraph, outerInnerGraph, completedStreams, substreamsPerStream, requiredPerStream);
        }
    }

    private static Set<Integer> getInnerStreams(int fromStream, Set<Integer> toStreams, OuterInnerDirectionalGraph outerInnerGraph) {
        HashSet<Integer> innerStreams = new HashSet<Integer>();
        for (int toStream : toStreams) {
            if (!outerInnerGraph.isInner(fromStream, toStream)) continue;
            innerStreams.add(toStream);
        }
        return innerStreams;
    }

    private static Set<Integer> getOuterStreams(int fromStream, Set<Integer> toStreams, OuterInnerDirectionalGraph outerInnerGraph) {
        HashSet<Integer> outerStreams = new HashSet<Integer>();
        for (int toStream : toStreams) {
            if (!outerInnerGraph.isOuter(toStream, fromStream)) continue;
            outerStreams.add(toStream);
        }
        return outerStreams;
    }

    protected static OuterInnerDirectionalGraph graphOuterJoins(int numStreams, List<OuterJoinDesc> outerJoinDescList) {
        if (outerJoinDescList.size() + 1 != numStreams) {
            throw new IllegalArgumentException("Number of outer join descriptors and number of streams not matching up");
        }
        OuterInnerDirectionalGraph graph = new OuterInnerDirectionalGraph(numStreams);
        for (int i = 0; i < outerJoinDescList.size(); ++i) {
            OuterJoinDesc desc = outerJoinDescList.get(i);
            int streamMax = i + 1;
            int streamOne = desc.getLeftNode().getStreamId();
            int streamTwo = desc.getRightNode().getStreamId();
            if (streamOne > streamMax || streamTwo > streamMax || streamOne == streamTwo) {
                throw new IllegalArgumentException("Outer join descriptors reference future streams, or same streams");
            }
            int lowerStream = streamOne;
            int higherStream = streamTwo;
            if (streamOne > streamTwo) {
                lowerStream = streamTwo;
                higherStream = streamOne;
            }
            if (desc.getOuterJoinType() == OuterJoinType.FULL) {
                graph.add(streamOne, streamTwo);
                graph.add(streamTwo, streamOne);
                continue;
            }
            if (desc.getOuterJoinType() == OuterJoinType.LEFT) {
                graph.add(lowerStream, higherStream);
                continue;
            }
            if (desc.getOuterJoinType() == OuterJoinType.RIGHT) {
                graph.add(higherStream, lowerStream);
                continue;
            }
            throw new IllegalArgumentException("Outer join descriptors join type not handled, type=" + (Object)((Object)desc.getOuterJoinType()));
        }
        return graph;
    }

    public static void verifyJoinedPerStream(int rootStream, Map<Integer, int[]> streamsJoinedPerStream) {
        HashSet<Integer> streams = new HashSet<Integer>();
        streams.add(rootStream);
        NStreamOuterQueryPlanBuilder.recursiveAdd(rootStream, streamsJoinedPerStream, streams);
        if (streams.size() != streamsJoinedPerStream.size()) {
            throw new IllegalArgumentException("Not all streams found, streamsJoinedPerStream=" + NStreamOuterQueryPlanBuilder.print(streamsJoinedPerStream));
        }
    }

    private static void recursiveAdd(int currentStream, Map<Integer, int[]> streamsJoinedPerStream, Set<Integer> streams) {
        if (currentStream >= streamsJoinedPerStream.size()) {
            throw new IllegalArgumentException("Error in stream " + currentStream + " streamsJoinedPerStream=" + NStreamOuterQueryPlanBuilder.print(streamsJoinedPerStream));
        }
        int[] joinedStreams = streamsJoinedPerStream.get(currentStream);
        for (int i = 0; i < joinedStreams.length; ++i) {
            int addStream = joinedStreams[i];
            if (streams.contains(addStream)) {
                throw new IllegalArgumentException("Stream " + addStream + " found twice");
            }
            streams.add(addStream);
            NStreamOuterQueryPlanBuilder.recursiveAdd(addStream, streamsJoinedPerStream, streams);
        }
    }

    public static String print(Map<Integer, int[]> streamsJoinedPerStream) {
        StringWriter buf = new StringWriter();
        PrintWriter printer = new PrintWriter(buf);
        for (int stream : streamsJoinedPerStream.keySet()) {
            int[] substreams = streamsJoinedPerStream.get(stream);
            printer.println("stream " + stream + " : " + Arrays.toString(substreams));
        }
        return buf.toString();
    }
}

