/*
 * Decompiled with CFR 0.152.
 */
package net.esper.eql.join.plan;

import java.util.Arrays;
import net.esper.collection.NumberSetPermutationEnumeration;
import net.esper.eql.join.plan.FullTableScanLookupPlan;
import net.esper.eql.join.plan.IndexedTableLookupPlan;
import net.esper.eql.join.plan.NestedIterationNode;
import net.esper.eql.join.plan.QueryGraph;
import net.esper.eql.join.plan.QueryPlan;
import net.esper.eql.join.plan.QueryPlanIndex;
import net.esper.eql.join.plan.QueryPlanIndexBuilder;
import net.esper.eql.join.plan.QueryPlanNode;
import net.esper.eql.join.plan.TableLookupNode;
import net.esper.eql.join.plan.TableLookupPlan;
import net.esper.eql.join.plan.TwoStreamQueryPlanBuilder;
import net.esper.event.EventType;
import net.esper.util.JavaClassHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NStreamQueryPlanBuilder {
    private static Log log = LogFactory.getLog(NStreamQueryPlanBuilder.class);

    protected static QueryPlan build(QueryGraph queryGraph, EventType[] typesPerStream) {
        if (log.isDebugEnabled()) {
            log.debug(".build queryGraph=" + queryGraph);
        }
        int numStreams = queryGraph.getNumStreams();
        QueryPlanIndex[] indexSpecs = QueryPlanIndexBuilder.buildIndexSpec(queryGraph);
        if (log.isDebugEnabled()) {
            log.debug(".build Index build completed, indexes=" + QueryPlanIndex.print(indexSpecs));
        }
        QueryPlanNode[] planNodeSpecs = new QueryPlanNode[numStreams];
        for (int streamNo = 0; streamNo < numStreams; ++streamNo) {
            BestChainResult bestChainResult = NStreamQueryPlanBuilder.computeBestPath(streamNo, queryGraph);
            int[] bestChain = bestChainResult.getChain();
            if (log.isDebugEnabled()) {
                log.debug(".build For stream " + streamNo + " bestChain=" + Arrays.toString(bestChain));
            }
            planNodeSpecs[streamNo] = NStreamQueryPlanBuilder.createStreamPlan(streamNo, bestChain, queryGraph, indexSpecs, typesPerStream);
            if (!log.isDebugEnabled()) continue;
            log.debug(".build spec=" + planNodeSpecs[streamNo]);
        }
        return new QueryPlan(indexSpecs, planNodeSpecs);
    }

    protected static QueryPlanNode createStreamPlan(int lookupStream, int[] bestChain, QueryGraph queryGraph, QueryPlanIndex[] indexSpecsPerStream, EventType[] typesPerStream) {
        NestedIterationNode nestedIterNode = new NestedIterationNode(bestChain);
        int currentLookupStream = lookupStream;
        for (int i = 0; i < bestChain.length; ++i) {
            int indexedStream = bestChain[i];
            TableLookupPlan tableLookupPlan = NStreamQueryPlanBuilder.createLookupPlan(queryGraph, currentLookupStream, indexedStream, indexSpecsPerStream[indexedStream], typesPerStream);
            TableLookupNode tableLookupNode = new TableLookupNode(tableLookupPlan);
            nestedIterNode.addChildNode(tableLookupNode);
            currentLookupStream = bestChain[i];
        }
        return nestedIterNode;
    }

    protected static TableLookupPlan createLookupPlan(QueryGraph queryGraph, int currentLookupStream, int indexedStream, QueryPlanIndex indexSpecs, EventType[] typesPerStream) {
        TableLookupPlan tableLookupPlan;
        Object[] indexedStreamIndexProps = queryGraph.getIndexProperties(currentLookupStream, indexedStream);
        int indexNum = -1;
        if (indexedStreamIndexProps != null) {
            indexNum = indexSpecs.getIndexNum((String[])indexedStreamIndexProps);
            if (indexNum == -1) {
                throw new IllegalStateException("Failed to query plan as index for " + Arrays.toString(indexedStreamIndexProps) + " could looked up in the index specification");
            }
            String[] keyGenFields = queryGraph.getKeyProperties(currentLookupStream, indexedStream);
            tableLookupPlan = new IndexedTableLookupPlan(currentLookupStream, indexedStream, indexNum, keyGenFields);
            Class[] coercionTypes = TwoStreamQueryPlanBuilder.getCoercionTypes(typesPerStream, currentLookupStream, indexedStream, keyGenFields, (String[])indexedStreamIndexProps);
            if (coercionTypes != null) {
                Class[] existCoercionTypes = indexSpecs.getCoercionTypes((String[])indexedStreamIndexProps);
                if (existCoercionTypes != null) {
                    for (int i = 0; i < existCoercionTypes.length; ++i) {
                        coercionTypes[i] = JavaClassHelper.getCompareToCoercionType(existCoercionTypes[i], coercionTypes[i]);
                    }
                }
                indexSpecs.setCoercionTypes((String[])indexedStreamIndexProps, coercionTypes);
            }
        } else {
            indexNum = indexSpecs.getIndexNum(new String[0]);
            if (indexNum == -1) {
                indexNum = indexSpecs.addIndex(new String[0], null);
            }
            tableLookupPlan = new FullTableScanLookupPlan(currentLookupStream, indexedStream, indexNum);
        }
        return tableLookupPlan;
    }

    protected static BestChainResult computeBestPath(int lookupStream, QueryGraph queryGraph) {
        int[] defNestingorder = NStreamQueryPlanBuilder.buildDefaultNestingOrder(queryGraph.getNumStreams(), lookupStream);
        NumberSetPermutationEnumeration permutations = new NumberSetPermutationEnumeration(defNestingorder);
        int[] bestPermutation = null;
        int bestDepth = -1;
        while (permutations.hasMoreElements()) {
            int[] permutation = permutations.nextElement();
            int permutationDepth = NStreamQueryPlanBuilder.computeNavigableDepth(lookupStream, permutation, queryGraph);
            if (permutationDepth > bestDepth) {
                bestPermutation = permutation;
                bestDepth = permutationDepth;
            }
            if (permutationDepth != queryGraph.getNumStreams() - 1) continue;
            break;
        }
        return new BestChainResult(bestDepth, bestPermutation);
    }

    protected static int computeNavigableDepth(int lookupStream, int[] nextStreams, QueryGraph queryGraph) {
        int nextStream;
        int currentStream = lookupStream;
        int currentDepth = 0;
        for (int i = 0; i < nextStreams.length && queryGraph.isNavigable(currentStream, nextStream = nextStreams[i]); ++i) {
            currentStream = nextStream;
            ++currentDepth;
        }
        return currentDepth;
    }

    protected static QueryPlan buildNStreamDefaultQuerySpec(EventType[] eventTypes) {
        QueryPlanIndex[] indexSpecs = new QueryPlanIndex[eventTypes.length];
        QueryPlanNode[] execNodeSpecs = new QueryPlanNode[eventTypes.length];
        for (int i = 0; i < indexSpecs.length; ++i) {
            indexSpecs[i] = new QueryPlanIndex(null, null);
        }
        for (int streamNo = 0; streamNo < eventTypes.length; ++streamNo) {
            int[] nestingOrder = NStreamQueryPlanBuilder.buildDefaultNestingOrder(eventTypes.length, streamNo);
            NestedIterationNode nestedNode = new NestedIterationNode(nestingOrder);
            execNodeSpecs[streamNo] = nestedNode;
            int lookupStream = streamNo;
            for (int j = 0; j < nestingOrder.length; ++j) {
                int indexedStream = nestingOrder[j];
                FullTableScanLookupPlan scanLookupStrategy = new FullTableScanLookupPlan(lookupStream, indexedStream, 0);
                nestedNode.addChildNode(new TableLookupNode(scanLookupStrategy));
                lookupStream = indexedStream;
            }
        }
        return new QueryPlan(indexSpecs, execNodeSpecs);
    }

    protected static int[] buildDefaultNestingOrder(int numStreams, int forStream) {
        int[] nestingOrder = new int[numStreams - 1];
        int count = 0;
        for (int i = 0; i < numStreams; ++i) {
            if (i == forStream) continue;
            nestingOrder[count++] = i;
        }
        return nestingOrder;
    }

    private static Class[] getCoercionTypes(EventType[] typesPerStream, int lookupStream, int indexedStream, String[] keyProps, String[] indexProps) {
        if (indexProps.length != keyProps.length) {
            throw new IllegalStateException("Mismatch in the number of key and index properties");
        }
        Class[] coercionTypes = new Class[indexProps.length];
        boolean mustCoerce = false;
        for (int i = 0; i < keyProps.length; ++i) {
            Class indexedPropType;
            Class keyPropType = JavaClassHelper.getBoxedType(typesPerStream[lookupStream].getPropertyType(keyProps[i]));
            Class coercionType = indexedPropType = JavaClassHelper.getBoxedType(typesPerStream[indexedStream].getPropertyType(indexProps[i]));
            if (keyPropType != indexedPropType) {
                coercionType = JavaClassHelper.getCompareToCoercionType(keyPropType, keyPropType);
                mustCoerce = true;
            }
            coercionTypes[i] = coercionType;
        }
        if (!mustCoerce) {
            return null;
        }
        return coercionTypes;
    }

    public static class BestChainResult {
        private int depth;
        private int[] chain;

        public BestChainResult(int depth, int[] chain) {
            this.depth = depth;
            this.chain = chain;
        }

        public int getDepth() {
            return this.depth;
        }

        public int[] getChain() {
            return this.chain;
        }

        public String toString() {
            return "depth=" + this.depth + " chain=" + Arrays.toString(this.chain);
        }
    }
}

