/*
 * Decompiled with CFR 0.152.
 */
package net.esper.eql.join.plan;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OuterInnerDirectionalGraph {
    private final Map<Integer, Set<Integer>> streamToInnerMap;
    private final int numStreams;

    public OuterInnerDirectionalGraph(int numStreams) {
        this.numStreams = numStreams;
        this.streamToInnerMap = new HashMap<Integer, Set<Integer>>();
    }

    public OuterInnerDirectionalGraph add(int outerStream, int innerStream) {
        this.checkArgs(outerStream, innerStream);
        Set<Integer> innerSet = this.streamToInnerMap.get(outerStream);
        if (innerSet == null) {
            innerSet = new HashSet<Integer>();
            this.streamToInnerMap.put(outerStream, innerSet);
        }
        if (innerSet.contains(innerStream)) {
            throw new IllegalArgumentException("Inner stream already in collection");
        }
        innerSet.add(innerStream);
        return this;
    }

    public Set<Integer> getInner(int outerStream) {
        this.checkArgs(outerStream);
        return this.streamToInnerMap.get(outerStream);
    }

    public Set<Integer> getOuter(int innerStream) {
        this.checkArgs(innerStream);
        HashSet<Integer> result = new HashSet<Integer>();
        for (Integer key : this.streamToInnerMap.keySet()) {
            Set<Integer> set = this.streamToInnerMap.get(key);
            if (!set.contains(innerStream)) continue;
            result.add(key);
        }
        if (result.isEmpty()) {
            return null;
        }
        return result;
    }

    public boolean isInner(int outerStream, int innerStream) {
        this.checkArgs(outerStream, innerStream);
        Set<Integer> innerSet = this.streamToInnerMap.get(outerStream);
        if (innerSet == null) {
            return false;
        }
        return innerSet.contains(innerStream);
    }

    public boolean isOuter(int outerStream, int innerStream) {
        this.checkArgs(outerStream, innerStream);
        Set<Integer> outerStreams = this.getOuter(innerStream);
        if (outerStreams == null) {
            return false;
        }
        return outerStreams.contains(outerStream);
    }

    public String print() {
        StringBuilder buffer = new StringBuilder();
        String delimiter = "";
        for (Integer key : this.streamToInnerMap.keySet()) {
            Set<Integer> set = this.streamToInnerMap.get(key);
            buffer.append(delimiter);
            buffer.append(key);
            buffer.append('=');
            buffer.append(Arrays.toString(set.toArray()));
            delimiter = ", ";
        }
        return buffer.toString();
    }

    private void checkArgs(int stream) {
        if (stream >= this.numStreams || stream < 0) {
            throw new IllegalArgumentException("Out of bounds parameter for stream num");
        }
    }

    private void checkArgs(int outerStream, int innerStream) {
        if (outerStream >= this.numStreams || innerStream >= this.numStreams || outerStream < 0 || innerStream < 0) {
            throw new IllegalArgumentException("Out of bounds parameter for inner or outer stream num");
        }
        if (outerStream == innerStream) {
            throw new IllegalArgumentException("Unexpected equal stream num for inner and outer stream");
        }
    }
}

