/*
 * Decompiled with CFR 0.152.
 */
package net.esper.eql.join.plan;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.esper.eql.join.plan.QueryGraphKey;
import net.esper.eql.join.plan.QueryGraphValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryGraph {
    private final int numStreams;
    private final Map<QueryGraphKey, QueryGraphValue> streamJoinMap;

    public QueryGraph(int numStreams) {
        this.numStreams = numStreams;
        this.streamJoinMap = new HashMap<QueryGraphKey, QueryGraphValue>();
    }

    public int getNumStreams() {
        return this.numStreams;
    }

    public boolean add(int streamLeft, String propertyLeft, int streamRight, String propertyRight) {
        if (propertyLeft == null || propertyRight == null) {
            throw new IllegalArgumentException("Null property names supplied");
        }
        if (streamLeft == streamRight) {
            throw new IllegalArgumentException("Streams supplied are the same");
        }
        QueryGraphKey key = new QueryGraphKey(streamLeft, streamRight);
        QueryGraphValue value = this.streamJoinMap.get(key);
        if (value == null) {
            value = new QueryGraphValue();
            this.streamJoinMap.put(key, value);
        }
        if (streamLeft > streamRight) {
            return value.add(propertyRight, propertyLeft);
        }
        return value.add(propertyLeft, propertyRight);
    }

    public boolean isNavigable(int streamFrom, int streamTo) {
        QueryGraphKey key = new QueryGraphKey(streamFrom, streamTo);
        return this.streamJoinMap.containsKey(key);
    }

    public Set<Integer> getNavigableStreams(int streamFrom) {
        HashSet<Integer> result = new HashSet<Integer>();
        for (int i = 0; i < this.numStreams; ++i) {
            if (!this.isNavigable(streamFrom, i)) continue;
            result.add(i);
        }
        return result;
    }

    public String[] getIndexProperties(int streamLookup, int streamIndexed) {
        QueryGraphKey key = new QueryGraphKey(streamLookup, streamIndexed);
        QueryGraphValue value = this.streamJoinMap.get(key);
        if (value == null) {
            return null;
        }
        if (streamLookup > streamIndexed) {
            return value.getPropertiesLeft().toArray(new String[0]);
        }
        return value.getPropertiesRight().toArray(new String[0]);
    }

    public String[] getKeyProperties(int streamLookup, int streamIndexed) {
        QueryGraphKey key = new QueryGraphKey(streamLookup, streamIndexed);
        QueryGraphValue value = this.streamJoinMap.get(key);
        if (value == null) {
            return null;
        }
        if (streamLookup > streamIndexed) {
            return value.getPropertiesRight().toArray(new String[0]);
        }
        return value.getPropertiesLeft().toArray(new String[0]);
    }

    protected static void fillEquivalentNav(QueryGraph queryGraph) {
        boolean addedEquivalency = false;
        do {
            addedEquivalency = false;
            for (int lookupStream = 0; lookupStream < queryGraph.numStreams; ++lookupStream) {
                for (int indexedStream = 0; indexedStream < queryGraph.numStreams; ++indexedStream) {
                    boolean added;
                    if (lookupStream == indexedStream || !(added = QueryGraph.fillEquivalentNav(queryGraph, lookupStream, indexedStream))) continue;
                    addedEquivalency = true;
                }
            }
        } while (addedEquivalency);
    }

    private static boolean fillEquivalentNav(QueryGraph queryGraph, int lookupStream, int indexedStream) {
        boolean addedEquivalency = false;
        String[] keyProps = queryGraph.getKeyProperties(lookupStream, indexedStream);
        String[] indexProps = queryGraph.getIndexProperties(lookupStream, indexedStream);
        if (keyProps == null) {
            return false;
        }
        if (keyProps.length != indexProps.length) {
            throw new IllegalStateException("Unexpected key and index property number mismatch");
        }
        for (int i = 0; i < keyProps.length; ++i) {
            boolean added = QueryGraph.fillEquivalentNav(queryGraph, lookupStream, keyProps[i], indexedStream, indexProps[i]);
            if (!added) continue;
            addedEquivalency = true;
        }
        return addedEquivalency;
    }

    private static boolean fillEquivalentNav(QueryGraph queryGraph, int lookupStream, String keyProp, int indexedStream, String indexProp) {
        boolean addedEquivalency = false;
        for (int otherStream = 0; otherStream < queryGraph.numStreams; ++otherStream) {
            boolean added;
            if (otherStream == lookupStream || otherStream == indexedStream) continue;
            String[] otherKeyProps = queryGraph.getKeyProperties(otherStream, indexedStream);
            String[] otherIndexProps = queryGraph.getIndexProperties(otherStream, indexedStream);
            int otherPropertyNum = -1;
            if (otherIndexProps == null) continue;
            for (int i = 0; i < otherIndexProps.length; ++i) {
                if (!otherIndexProps[i].equals(indexProp)) continue;
                otherPropertyNum = i;
                break;
            }
            if (otherPropertyNum == -1 || !(added = queryGraph.add(lookupStream, keyProp, otherStream, otherKeyProps[otherPropertyNum]))) continue;
            addedEquivalency = true;
        }
        return addedEquivalency;
    }

    public String toString() {
        StringWriter buf = new StringWriter();
        PrintWriter writer = new PrintWriter(buf);
        int count = 0;
        for (Map.Entry<QueryGraphKey, QueryGraphValue> entry : this.streamJoinMap.entrySet()) {
            writer.println("Entry " + ++count + ": key=" + entry.getKey());
            writer.println("  value=" + entry.getValue());
        }
        return buf.toString();
    }
}

