/*
 * Decompiled with CFR 0.152.
 */
package net.esper.eql.join.plan;

import java.util.List;
import net.esper.eql.expression.ExprNode;
import net.esper.eql.join.plan.FilterExprAnalyzer;
import net.esper.eql.join.plan.NStreamOuterQueryPlanBuilder;
import net.esper.eql.join.plan.NStreamQueryPlanBuilder;
import net.esper.eql.join.plan.OuterJoinAnalyzer;
import net.esper.eql.join.plan.QueryGraph;
import net.esper.eql.join.plan.QueryPlan;
import net.esper.eql.join.plan.TwoStreamQueryPlanBuilder;
import net.esper.eql.spec.OuterJoinDesc;
import net.esper.event.EventType;
import net.esper.type.OuterJoinType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryPlanBuilder {
    private static final Log log = LogFactory.getLog(QueryPlanBuilder.class);

    public static QueryPlan getPlan(EventType[] typesPerStream, List<OuterJoinDesc> outerJoinDescList, ExprNode optionalFilterNode, String[] streamNames) {
        String methodName = ".getPlan ";
        int numStreams = typesPerStream.length;
        if (numStreams < 2) {
            throw new IllegalArgumentException("Number of join stream types is less then 2");
        }
        if (outerJoinDescList.size() >= numStreams) {
            throw new IllegalArgumentException("Too many outer join descriptors found");
        }
        QueryGraph queryGraph = new QueryGraph(numStreams);
        if (!outerJoinDescList.isEmpty()) {
            OuterJoinAnalyzer.analyze(outerJoinDescList, queryGraph);
            if (log.isDebugEnabled()) {
                log.debug(methodName + " After outer join queryGraph=\n" + queryGraph);
            }
        } else if (optionalFilterNode != null) {
            FilterExprAnalyzer.analyze(optionalFilterNode, queryGraph);
            if (log.isDebugEnabled()) {
                log.debug(methodName + "After filter expression queryGraph=\n" + queryGraph);
            }
            QueryGraph.fillEquivalentNav(queryGraph);
            if (log.isDebugEnabled()) {
                log.debug(methodName + "After fill equiv. nav. queryGraph=\n" + queryGraph);
            }
        }
        if (numStreams == 2) {
            OuterJoinType outerJoinType = null;
            if (!outerJoinDescList.isEmpty()) {
                outerJoinType = outerJoinDescList.get(0).getOuterJoinType();
            }
            QueryPlan queryPlan = TwoStreamQueryPlanBuilder.build(typesPerStream, queryGraph, outerJoinType);
            if (log.isDebugEnabled()) {
                log.debug(methodName + "2-Stream queryPlan=" + queryPlan);
            }
            return queryPlan;
        }
        if (outerJoinDescList.isEmpty()) {
            QueryPlan queryPlan = NStreamQueryPlanBuilder.build(queryGraph, typesPerStream);
            if (log.isDebugEnabled()) {
                log.debug(methodName + "N-Stream no-outer-join queryPlan=" + queryPlan);
            }
            return queryPlan;
        }
        return NStreamOuterQueryPlanBuilder.build(queryGraph, outerJoinDescList, streamNames, typesPerStream);
    }
}

