/*
 * Decompiled with CFR 0.152.
 */
package net.esper.eql.join.plan;

import java.util.Arrays;

public class QueryPlanIndex {
    private String[][] indexProps;
    private Class[][] optCoercionTypes;

    public QueryPlanIndex(String[][] indexProps, Class[][] optCoercionTypes) {
        if (indexProps == null || indexProps.length == 0 || optCoercionTypes == null) {
            throw new IllegalArgumentException("Null or empty index properites or coercion types-per-index parameter is supplied, expecting at least one entry");
        }
        this.indexProps = indexProps;
        this.optCoercionTypes = optCoercionTypes;
    }

    public String[][] getIndexProps() {
        return this.indexProps;
    }

    public Class[][] getCoercionTypesPerIndex() {
        return this.optCoercionTypes;
    }

    protected int getIndexNum(String[] indexFields) {
        for (int i = 0; i < this.indexProps.length; ++i) {
            if (!Arrays.equals(indexFields, this.indexProps[i])) continue;
            return i;
        }
        Object[] copyIndexFields = new String[indexFields.length];
        System.arraycopy(indexFields, 0, copyIndexFields, 0, indexFields.length);
        Arrays.sort(copyIndexFields);
        for (int i = 0; i < this.indexProps.length; ++i) {
            Object[] copyIndexProps = new String[this.indexProps[i].length];
            System.arraycopy(this.indexProps[i], 0, copyIndexProps, 0, copyIndexProps.length);
            Arrays.sort(copyIndexProps);
            if (!Arrays.equals(copyIndexFields, copyIndexProps)) continue;
            return i;
        }
        return -1;
    }

    public int addIndex(String[] indexProperties, Class[] coercionTypes) {
        int numElements = this.indexProps.length;
        String[][] newProps = new String[numElements + 1][];
        System.arraycopy(this.indexProps, 0, newProps, 0, numElements);
        newProps[numElements] = indexProperties;
        this.indexProps = newProps;
        Class[][] newCoercionTypes = new Class[numElements + 1][];
        System.arraycopy(this.optCoercionTypes, 0, newCoercionTypes, 0, numElements);
        newCoercionTypes[numElements] = coercionTypes;
        this.optCoercionTypes = newCoercionTypes;
        return numElements;
    }

    public Class[] getCoercionTypes(String[] indexProperties) {
        for (int i = 0; i < this.indexProps.length; ++i) {
            if (!Arrays.deepEquals(this.indexProps[i], indexProperties)) continue;
            return this.optCoercionTypes[i];
        }
        throw new IllegalArgumentException("Index properties not found");
    }

    public void setCoercionTypes(String[] indexProperties, Class[] coercionTypes) {
        boolean found = false;
        for (int i = 0; i < this.indexProps.length; ++i) {
            if (!Arrays.deepEquals(this.indexProps[i], indexProperties)) continue;
            this.optCoercionTypes[i] = coercionTypes;
            found = true;
        }
        if (!found) {
            throw new IllegalArgumentException("Index properties not found");
        }
    }

    public String toString() {
        if (this.indexProps == null) {
            return "indexProperties=null";
        }
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < this.indexProps.length; ++i) {
            buf.append("indexProperties(").append(i).append(")=").append(Arrays.toString(this.indexProps[i])).append(' ');
        }
        return buf.toString();
    }

    public static String print(QueryPlanIndex[] indexSpecs) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("QueryPlanIndex[]\n");
        for (int i = 0; i < indexSpecs.length; ++i) {
            buffer.append("  index spec " + i + " : " + indexSpecs[i].toString() + '\n');
        }
        return buffer.toString();
    }
}

