/*
 * Decompiled with CFR 0.152.
 */
package net.esper.eql.join.plan;

import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import net.esper.collection.MultiKey;
import net.esper.eql.join.plan.QueryGraph;
import net.esper.eql.join.plan.QueryPlanIndex;

public class QueryPlanIndexBuilder {
    public static QueryPlanIndex[] buildIndexSpec(QueryGraph queryGraph) {
        int numStreams = queryGraph.getNumStreams();
        QueryPlanIndex[] indexSpecs = new QueryPlanIndex[numStreams];
        for (int streamIndexed = 0; streamIndexed < numStreams; ++streamIndexed) {
            HashSet<MultiKey<Object>> indexesSetSortedProps = new HashSet<MultiKey<Object>>();
            LinkedList<String[]> indexesList = new LinkedList<String[]>();
            for (int streamLookup = 0; streamLookup < numStreams; ++streamLookup) {
                String[] indexProps;
                if (streamIndexed == streamLookup || (indexProps = queryGraph.getIndexProperties(streamLookup, streamIndexed)) == null) continue;
                Object[] indexPropsSorted = new String[indexProps.length];
                System.arraycopy(indexProps, 0, indexPropsSorted, 0, indexProps.length);
                Arrays.sort(indexPropsSorted);
                MultiKey<Object> indexPropsUniqueKey = new MultiKey<Object>(indexPropsSorted);
                if (indexesSetSortedProps.contains(indexPropsUniqueKey)) continue;
                indexesSetSortedProps.add(indexPropsUniqueKey);
                indexesList.add(indexProps);
            }
            String[][] indexProps = null;
            if (!indexesList.isEmpty()) {
                indexProps = new String[indexesList.size()][];
                int count = 0;
                for (String[] entry : indexesList) {
                    indexProps[count] = entry;
                    ++count;
                }
            } else {
                indexProps = new String[1][0];
                indexProps[0] = new String[0];
            }
            indexSpecs[streamIndexed] = new QueryPlanIndex(indexProps, new Class[indexProps.length][]);
        }
        return indexSpecs;
    }
}

