/*
 * Decompiled with CFR 0.152.
 */
package net.esper.eql.join.plan;

import net.esper.eql.join.plan.FullTableScanLookupPlan;
import net.esper.eql.join.plan.IndexedTableLookupPlan;
import net.esper.eql.join.plan.QueryGraph;
import net.esper.eql.join.plan.QueryPlan;
import net.esper.eql.join.plan.QueryPlanIndex;
import net.esper.eql.join.plan.QueryPlanNode;
import net.esper.eql.join.plan.TableLookupNode;
import net.esper.eql.join.plan.TableLookupPlan;
import net.esper.eql.join.plan.TableOuterLookupNode;
import net.esper.event.EventType;
import net.esper.type.OuterJoinType;
import net.esper.util.JavaClassHelper;

public class TwoStreamQueryPlanBuilder {
    public static QueryPlan build(EventType[] typesPerStream, QueryGraph queryGraph, OuterJoinType optionalOuterJoinType) {
        QueryPlanIndex[] indexSpecs = new QueryPlanIndex[2];
        QueryPlanNode[] execNodeSpecs = new QueryPlanNode[2];
        TableLookupPlan[] lookupPlans = new TableLookupPlan[2];
        if (!queryGraph.isNavigable(0, 1)) {
            String[][] unkeyedIndexProps = new String[][]{new String[0]};
            indexSpecs[0] = new QueryPlanIndex(unkeyedIndexProps, new Class[][]{null});
            indexSpecs[1] = new QueryPlanIndex(unkeyedIndexProps, new Class[][]{null});
            lookupPlans[0] = new FullTableScanLookupPlan(0, 1, 0);
            lookupPlans[1] = new FullTableScanLookupPlan(1, 0, 0);
        } else {
            String[] keyProps = queryGraph.getKeyProperties(0, 1);
            String[] indexProps = queryGraph.getIndexProperties(0, 1);
            Class[] coercionTypes = TwoStreamQueryPlanBuilder.getCoercionTypes(typesPerStream, 0, 1, keyProps, indexProps);
            indexSpecs[0] = new QueryPlanIndex(new String[][]{queryGraph.getIndexProperties(1, 0)}, new Class[][]{coercionTypes});
            indexSpecs[1] = new QueryPlanIndex(new String[][]{queryGraph.getIndexProperties(0, 1)}, new Class[][]{coercionTypes});
            lookupPlans[0] = new IndexedTableLookupPlan(0, 1, 0, queryGraph.getKeyProperties(0, 1));
            lookupPlans[1] = new IndexedTableLookupPlan(1, 0, 0, queryGraph.getKeyProperties(1, 0));
        }
        execNodeSpecs[0] = new TableLookupNode(lookupPlans[0]);
        execNodeSpecs[1] = new TableLookupNode(lookupPlans[1]);
        if (optionalOuterJoinType != null) {
            if (optionalOuterJoinType.equals((Object)OuterJoinType.LEFT) || optionalOuterJoinType.equals((Object)OuterJoinType.FULL)) {
                execNodeSpecs[0] = new TableOuterLookupNode(lookupPlans[0]);
            }
            if (optionalOuterJoinType.equals((Object)OuterJoinType.RIGHT) || optionalOuterJoinType.equals((Object)OuterJoinType.FULL)) {
                execNodeSpecs[1] = new TableOuterLookupNode(lookupPlans[1]);
            }
        }
        return new QueryPlan(indexSpecs, execNodeSpecs);
    }

    protected static Class[] getCoercionTypes(EventType[] typesPerStream, int lookupStream, int indexedStream, String[] keyProps, String[] indexProps) {
        if (indexProps.length != keyProps.length) {
            throw new IllegalStateException("Mismatch in the number of key and index properties");
        }
        Class[] coercionTypes = new Class[indexProps.length];
        boolean mustCoerce = false;
        for (int i = 0; i < keyProps.length; ++i) {
            Class indexedPropType;
            Class keyPropType = JavaClassHelper.getBoxedType(typesPerStream[lookupStream].getPropertyType(keyProps[i]));
            Class coercionType = indexedPropType = JavaClassHelper.getBoxedType(typesPerStream[indexedStream].getPropertyType(indexProps[i]));
            if (keyPropType != indexedPropType) {
                coercionType = JavaClassHelper.getCompareToCoercionType(keyPropType, indexedPropType);
                mustCoerce = true;
            }
            coercionTypes[i] = coercionType;
        }
        if (!mustCoerce) {
            return null;
        }
        return coercionTypes;
    }
}

