/*
 * Decompiled with CFR 0.152.
 */
package net.esper.eql.join.table;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.esper.collection.MultiKeyUntyped;
import net.esper.eql.join.table.EventTable;
import net.esper.eql.join.table.PropertyIndexedEventTableIterator;
import net.esper.event.EventBean;
import net.esper.event.EventBeanUtility;
import net.esper.event.EventPropertyGetter;
import net.esper.event.EventType;
import net.esper.util.ExecutionPathDebugLog;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyIndexedEventTable
implements EventTable {
    private final int streamNum;
    private final String[] propertyNames;
    protected final EventPropertyGetter[] propertyGetters;
    protected final Map<MultiKeyUntyped, Set<EventBean>> propertyIndex;
    private static Log log = LogFactory.getLog(PropertyIndexedEventTable.class);

    public PropertyIndexedEventTable(int streamNum, EventType eventType, String[] propertyNames) {
        this.streamNum = streamNum;
        this.propertyNames = propertyNames;
        this.propertyGetters = new EventPropertyGetter[propertyNames.length];
        for (int i = 0; i < propertyNames.length; ++i) {
            this.propertyGetters[i] = eventType.getGetter(propertyNames[i]);
        }
        this.propertyIndex = new HashMap<MultiKeyUntyped, Set<EventBean>>();
    }

    protected MultiKeyUntyped getMultiKey(EventBean event) {
        return EventBeanUtility.getMultiKey(event, this.propertyGetters);
    }

    @Override
    public void add(EventBean[] events) {
        if (events == null) {
            return;
        }
        for (EventBean event : events) {
            this.add(event);
        }
    }

    @Override
    public void remove(EventBean[] events) {
        if (events == null) {
            return;
        }
        for (EventBean event : events) {
            this.remove(event);
        }
    }

    public Set<EventBean> lookup(Object[] keys) {
        MultiKeyUntyped key = new MultiKeyUntyped(keys);
        return this.propertyIndex.get(key);
    }

    private void add(EventBean event) {
        MultiKeyUntyped key = this.getMultiKey(event);
        Set<EventBean> events = this.propertyIndex.get(key);
        if (events == null) {
            events = new HashSet<EventBean>();
            this.propertyIndex.put(key, events);
        }
        if (events.contains(event)) {
            throw new IllegalArgumentException("Event already in index, event=" + event);
        }
        events.add(event);
    }

    private void remove(EventBean event) {
        MultiKeyUntyped key = this.getMultiKey(event);
        Set<EventBean> events = this.propertyIndex.get(key);
        if (events == null) {
            if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
                log.debug(".remove Event could not be located in index, event " + event);
            }
            return;
        }
        if (!events.remove(event)) {
            if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
                log.debug(".remove Event could not be located in index, event " + event);
            }
            return;
        }
        if (events.isEmpty()) {
            this.propertyIndex.remove(key);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.propertyIndex.isEmpty();
    }

    @Override
    public Iterator<EventBean> iterator() {
        return new PropertyIndexedEventTableIterator(this.propertyIndex);
    }

    @Override
    public void clear() {
        this.propertyIndex.clear();
    }

    public String toString() {
        return "PropertyIndexedEventTable streamNum=" + this.streamNum + " propertyNames=" + Arrays.toString(this.propertyNames);
    }
}

