/*
 * Decompiled with CFR 0.152.
 */
package net.esper.eql.named;

import java.util.Iterator;
import java.util.List;
import net.esper.collection.OneEventLinkedList;
import net.esper.collection.SingleEventIterator;
import net.esper.eql.expression.ExprNode;
import net.esper.eql.named.NamedWindowTailView;
import net.esper.event.EventBean;
import net.esper.event.EventType;
import net.esper.util.ExecutionPathDebugLog;
import net.esper.view.StatementStopCallback;
import net.esper.view.StatementStopService;
import net.esper.view.ViewSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamedWindowConsumerView
extends ViewSupport
implements StatementStopCallback {
    private static final Log log = LogFactory.getLog(NamedWindowConsumerView.class);
    private final List<ExprNode> filterList;
    private final EventType eventType;
    private final NamedWindowTailView tailView;
    private EventBean lastEvent;
    private EventBean[] eventPerStream = new EventBean[1];

    public NamedWindowConsumerView(List<ExprNode> filterList, EventType eventType, StatementStopService statementStopService, NamedWindowTailView tailView) {
        this.filterList = filterList;
        this.eventType = eventType;
        this.tailView = tailView;
        statementStopService.addSubscriber(this);
    }

    @Override
    public void update(EventBean[] newData, EventBean[] oldData) {
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".update Received update,   newData.length==" + (newData == null ? 0 : newData.length) + "  oldData.length==" + (oldData == null ? 0 : oldData.length));
        }
        if (!this.filterList.isEmpty()) {
            newData = this.passFilter(newData, true);
            oldData = this.passFilter(oldData, false);
        }
        if (newData != null && newData.length > 0) {
            this.lastEvent = newData[newData.length - 1];
        }
        if (newData != null || oldData != null) {
            this.updateChildren(newData, oldData);
        }
    }

    private EventBean[] passFilter(EventBean[] eventData, boolean isNewData) {
        if (eventData == null || eventData.length == 0) {
            return null;
        }
        OneEventLinkedList filtered = null;
        EventBean[] arr$ = eventData;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            EventBean event;
            this.eventPerStream[0] = event = arr$[i$];
            boolean pass = true;
            for (ExprNode filter : this.filterList) {
                Boolean result = (Boolean)filter.evaluate(this.eventPerStream, isNewData);
                if (result == null || result.booleanValue()) continue;
                pass = false;
                break;
            }
            if (!pass) continue;
            if (filtered == null) {
                filtered = new OneEventLinkedList();
            }
            filtered.add(event);
        }
        if (filtered == null) {
            return null;
        }
        return filtered.toArray();
    }

    @Override
    public EventType getEventType() {
        return this.eventType;
    }

    @Override
    public Iterator<EventBean> iterator() {
        return new SingleEventIterator(this.lastEvent);
    }

    @Override
    public void statementStopped() {
        this.tailView.removeConsumer(this);
    }
}

