/*
 * Decompiled with CFR 0.152.
 */
package net.esper.eql.named;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.esper.collection.MultiKey;
import net.esper.collection.Pair;
import net.esper.eql.join.table.EventTable;
import net.esper.eql.join.table.PropertyIndTableCoerceAdd;
import net.esper.eql.join.table.PropertyIndexedEventTable;
import net.esper.eql.lookup.JoinedPropDesc;
import net.esper.event.EventBean;
import net.esper.event.EventType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamedWindowIndexRepository {
    private List<EventTable> tables = new ArrayList<EventTable>();
    private Map<MultiKey<JoinedPropDesc>, Pair<PropertyIndexedEventTable, Integer>> tableIndexes = new HashMap<MultiKey<JoinedPropDesc>, Pair<PropertyIndexedEventTable, Integer>>();

    public PropertyIndexedEventTable addTable(JoinedPropDesc[] joinedPropDesc, Iterable<EventBean> prefilledEvents, EventType indexedType, boolean mustCoerce) {
        MultiKey<JoinedPropDesc> indexPropKey = new MultiKey<JoinedPropDesc>(joinedPropDesc);
        Pair<PropertyIndexedEventTable, Integer> refTablePair = this.tableIndexes.get(indexPropKey);
        if (refTablePair != null) {
            refTablePair.setSecond(refTablePair.getSecond() + 1);
            return refTablePair.getFirst();
        }
        String[] indexProps = JoinedPropDesc.getIndexProperties(joinedPropDesc);
        Class[] coercionTypes = JoinedPropDesc.getCoercionTypes(joinedPropDesc);
        PropertyIndexedEventTable table = !mustCoerce ? new PropertyIndexedEventTable(0, indexedType, indexProps) : new PropertyIndTableCoerceAdd(0, indexedType, indexProps, coercionTypes);
        EventBean[] events = new EventBean[1];
        Iterator<EventBean> i$ = prefilledEvents.iterator();
        while (i$.hasNext()) {
            EventBean prefilledEvent;
            events[0] = prefilledEvent = i$.next();
            table.add(events);
        }
        this.tables.add(table);
        this.tableIndexes.put(indexPropKey, new Pair<PropertyIndexedEventTable, Integer>(table, 1));
        return table;
    }

    public void removeTableReference(EventTable table) {
        for (Map.Entry<MultiKey<JoinedPropDesc>, Pair<PropertyIndexedEventTable, Integer>> entry : this.tableIndexes.entrySet()) {
            if (entry.getValue().getFirst() != table) continue;
            int current = entry.getValue().getSecond();
            if (current > 1) {
                entry.getValue().setSecond(--current);
                break;
            }
            this.tables.remove(table);
            this.tableIndexes.remove(entry.getKey());
            break;
        }
    }

    public List<EventTable> getTables() {
        return this.tables;
    }

    public void destroy() {
        this.tables.clear();
        this.tableIndexes.clear();
    }
}

