/*
 * Decompiled with CFR 0.152.
 */
package net.esper.eql.named;

import net.esper.eql.named.LookupStrategy;
import net.esper.eql.named.NamedWindowRootView;
import net.esper.event.EventBean;
import net.esper.event.EventType;
import net.esper.util.ExecutionPathDebugLog;
import net.esper.view.StatementStopCallback;
import net.esper.view.StatementStopService;
import net.esper.view.ViewSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class NamedWindowOnExprBaseView
extends ViewSupport
implements StatementStopCallback {
    private static final Log log = LogFactory.getLog(NamedWindowOnExprBaseView.class);
    protected final EventType namedWindowEventType;
    private final LookupStrategy lookupStrategy;
    protected final NamedWindowRootView rootView;

    public NamedWindowOnExprBaseView(StatementStopService statementStopService, LookupStrategy lookupStrategy, NamedWindowRootView rootView) {
        this.lookupStrategy = lookupStrategy;
        this.rootView = rootView;
        statementStopService.addSubscriber(this);
        this.namedWindowEventType = rootView.getEventType();
    }

    public abstract void handleMatching(EventBean[] var1, EventBean[] var2);

    public void statementStopped() {
        log.debug(".statementStopped");
        this.rootView.removeOnExpr(this.lookupStrategy);
    }

    public void update(EventBean[] newData, EventBean[] oldData) {
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".update Received update,   newData.length==" + (newData == null ? 0 : newData.length) + "  oldData.length==" + (oldData == null ? 0 : oldData.length));
        }
        if (newData == null) {
            return;
        }
        EventBean[] eventsFound = this.lookupStrategy.lookup(newData);
        this.handleMatching(newData, eventsFound);
    }
}

