/*
 * Decompiled with CFR 0.152.
 */
package net.esper.eql.named;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.esper.collection.ArrayEventIterator;
import net.esper.collection.MultiKey;
import net.esper.collection.Pair;
import net.esper.core.EPStatementHandle;
import net.esper.core.InternalEventRouter;
import net.esper.eql.core.ResultSetProcessor;
import net.esper.eql.named.LookupStrategy;
import net.esper.eql.named.NamedWindowOnExprBaseView;
import net.esper.eql.named.NamedWindowRootView;
import net.esper.event.EventBean;
import net.esper.event.EventType;
import net.esper.view.StatementStopService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamedWindowOnSelectView
extends NamedWindowOnExprBaseView {
    private static final Log log = LogFactory.getLog(NamedWindowOnSelectView.class);
    private final InternalEventRouter internalEventRouter;
    private final ResultSetProcessor optionalResultSetProcessor;
    private final EPStatementHandle statementHandle;
    private EventBean[] lastResult;
    private Set<MultiKey<EventBean>> oldEvents = new HashSet<MultiKey<EventBean>>();

    public NamedWindowOnSelectView(StatementStopService statementStopService, LookupStrategy lookupStrategy, NamedWindowRootView rootView, InternalEventRouter internalEventRouter, ResultSetProcessor optionalResultSetProcessor, EPStatementHandle statementHandle) {
        super(statementStopService, lookupStrategy, rootView);
        this.internalEventRouter = internalEventRouter;
        this.optionalResultSetProcessor = optionalResultSetProcessor;
        this.statementHandle = statementHandle;
    }

    @Override
    public void handleMatching(EventBean[] triggerEvents, EventBean[] matchingEvents) {
        EventBean[] newData = null;
        if (this.optionalResultSetProcessor != null) {
            this.optionalResultSetProcessor.clear();
            HashSet<MultiKey<EventBean>> newEvents = new HashSet<MultiKey<EventBean>>();
            for (int i = 0; i < triggerEvents.length; ++i) {
                EventBean triggerEvent = triggerEvents[0];
                if (matchingEvents == null) continue;
                for (int j = 0; j < matchingEvents.length; ++j) {
                    EventBean[] eventsPerStream = new EventBean[]{matchingEvents[j], triggerEvent};
                    newEvents.add(new MultiKey<EventBean>(eventsPerStream));
                }
            }
            Pair<EventBean[], EventBean[]> pair = this.optionalResultSetProcessor.processJoinResult(newEvents, this.oldEvents);
            newData = pair.getFirst();
        } else {
            newData = matchingEvents;
        }
        if (this.internalEventRouter != null) {
            this.internalEventRouter.route(newData, this.statementHandle);
        }
        if (newData != null && newData.length > 0) {
            this.updateChildren(newData, null);
        }
        this.lastResult = newData;
    }

    @Override
    public EventType getEventType() {
        if (this.optionalResultSetProcessor != null) {
            return this.optionalResultSetProcessor.getResultEventType();
        }
        return this.namedWindowEventType;
    }

    @Override
    public Iterator<EventBean> iterator() {
        return new ArrayEventIterator(this.lastResult);
    }
}

