/*
 * Decompiled with CFR 0.152.
 */
package net.esper.eql.named;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.esper.collection.Pair;
import net.esper.core.EPStatementHandle;
import net.esper.core.InternalEventRouter;
import net.esper.eql.core.ResultSetProcessor;
import net.esper.eql.expression.ExprNode;
import net.esper.eql.join.plan.FilterExprAnalyzer;
import net.esper.eql.join.plan.QueryGraph;
import net.esper.eql.join.table.EventTable;
import net.esper.eql.join.table.PropertyIndexedEventTable;
import net.esper.eql.lookup.IndexedTableLookupStrategy;
import net.esper.eql.lookup.IndexedTableLookupStrategyCoercing;
import net.esper.eql.lookup.JoinedPropDesc;
import net.esper.eql.named.LookupStrategy;
import net.esper.eql.named.LookupStrategyAllRows;
import net.esper.eql.named.LookupStrategyIndexed;
import net.esper.eql.named.LookupStrategyTableScan;
import net.esper.eql.named.NamedWindowIndexRepository;
import net.esper.eql.named.NamedWindowOnDeleteView;
import net.esper.eql.named.NamedWindowOnExprBaseView;
import net.esper.eql.named.NamedWindowOnSelectView;
import net.esper.eql.spec.OnTriggerDesc;
import net.esper.eql.spec.OnTriggerType;
import net.esper.event.EventBean;
import net.esper.event.EventType;
import net.esper.util.ExecutionPathDebugLog;
import net.esper.util.JavaClassHelper;
import net.esper.view.StatementStopService;
import net.esper.view.ViewSupport;
import net.esper.view.Viewable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamedWindowRootView
extends ViewSupport {
    private static final Log log = LogFactory.getLog(NamedWindowRootView.class);
    private EventType namedWindowEventType;
    private final NamedWindowIndexRepository indexRepository = new NamedWindowIndexRepository();
    private Iterable<EventBean> dataWindowContents;
    private final Map<LookupStrategy, PropertyIndexedEventTable> tablePerStrategy = new HashMap<LookupStrategy, PropertyIndexedEventTable>();

    public void setDataWindowContents(Iterable<EventBean> dataWindowContents) {
        this.dataWindowContents = dataWindowContents;
    }

    public void removeOldData(EventBean[] oldData) {
        for (EventTable table : this.indexRepository.getTables()) {
            table.remove(oldData);
        }
    }

    @Override
    public void update(EventBean[] newData, EventBean[] oldData) {
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".update Received update,   newData.length==" + (newData == null ? 0 : newData.length) + "  oldData.length==" + (oldData == null ? 0 : oldData.length));
        }
        for (EventTable table : this.indexRepository.getTables()) {
            table.add(newData);
            table.remove(oldData);
        }
        this.updateChildren(newData, oldData);
    }

    public NamedWindowOnExprBaseView addOnExpr(OnTriggerDesc onTriggerDesc, ExprNode joinExpr, EventType filterEventType, StatementStopService statementStopService, InternalEventRouter internalEventRouter, ResultSetProcessor optionalResultSetProcessor, EPStatementHandle statementHandle) {
        Pair<LookupStrategy, PropertyIndexedEventTable> strategy = this.getStrategyPair(onTriggerDesc, joinExpr, filterEventType);
        if (strategy.getSecond() != null) {
            this.tablePerStrategy.put(strategy.getFirst(), strategy.getSecond());
        }
        if (onTriggerDesc.getOnTriggerType() == OnTriggerType.ON_DELETE) {
            return new NamedWindowOnDeleteView(statementStopService, strategy.getFirst(), this);
        }
        return new NamedWindowOnSelectView(statementStopService, strategy.getFirst(), this, internalEventRouter, optionalResultSetProcessor, statementHandle);
    }

    public void removeOnExpr(LookupStrategy strategy) {
        PropertyIndexedEventTable table = this.tablePerStrategy.remove(strategy);
        if (table != null) {
            this.indexRepository.removeTableReference(table);
        }
    }

    private Pair<LookupStrategy, PropertyIndexedEventTable> getStrategyPair(OnTriggerDesc onTriggerDesc, ExprNode joinExpr, EventType filterEventType) {
        if (joinExpr == null) {
            return new Pair<LookupStrategyAllRows, Object>(new LookupStrategyAllRows(this.dataWindowContents), null);
        }
        QueryGraph queryGraph = new QueryGraph(2);
        FilterExprAnalyzer.analyze(joinExpr, queryGraph);
        String[] keyPropertiesJoin = queryGraph.getKeyProperties(1, 0);
        String[] indexPropertiesJoin = queryGraph.getIndexProperties(1, 0);
        if (keyPropertiesJoin == null || keyPropertiesJoin.length == 0) {
            return new Pair<LookupStrategyTableScan, Object>(new LookupStrategyTableScan(joinExpr, this.dataWindowContents), null);
        }
        boolean mustCoerce = false;
        Class[] coercionTypes = new Class[indexPropertiesJoin.length];
        for (int i = 0; i < keyPropertiesJoin.length; ++i) {
            Class indexedPropType;
            Class keyPropType = JavaClassHelper.getBoxedType(filterEventType.getPropertyType(keyPropertiesJoin[i]));
            Class coercionType = indexedPropType = JavaClassHelper.getBoxedType(this.namedWindowEventType.getPropertyType(indexPropertiesJoin[i]));
            if (keyPropType != indexedPropType) {
                coercionType = JavaClassHelper.getCompareToCoercionType(keyPropType, keyPropType);
                mustCoerce = true;
            }
            coercionTypes[i] = coercionType;
        }
        Object[] joinedPropDesc = new JoinedPropDesc[keyPropertiesJoin.length];
        for (int i = 0; i < joinedPropDesc.length; ++i) {
            joinedPropDesc[i] = new JoinedPropDesc(indexPropertiesJoin[i], coercionTypes[i], keyPropertiesJoin[i], 1);
        }
        Arrays.sort(joinedPropDesc);
        keyPropertiesJoin = JoinedPropDesc.getKeyProperties((JoinedPropDesc[])joinedPropDesc);
        indexPropertiesJoin = JoinedPropDesc.getIndexProperties((JoinedPropDesc[])joinedPropDesc);
        PropertyIndexedEventTable table = this.indexRepository.addTable((JoinedPropDesc[])joinedPropDesc, this.dataWindowContents, this.namedWindowEventType, mustCoerce);
        EventType[] eventTypePerStream = new EventType[]{null, filterEventType};
        int[] streamNumbersPerProperty = new int[joinedPropDesc.length];
        for (int i = 0; i < streamNumbersPerProperty.length; ++i) {
            streamNumbersPerProperty[i] = 1;
        }
        IndexedTableLookupStrategy lookupStrategy = null;
        lookupStrategy = !mustCoerce ? new IndexedTableLookupStrategy(eventTypePerStream, streamNumbersPerProperty, keyPropertiesJoin, table) : new IndexedTableLookupStrategyCoercing(eventTypePerStream, streamNumbersPerProperty, keyPropertiesJoin, table, coercionTypes);
        return new Pair<LookupStrategy, PropertyIndexedEventTable>(new LookupStrategyIndexed(joinExpr, lookupStrategy), table);
    }

    @Override
    public void setParent(Viewable parent) {
        super.setParent(parent);
        this.namedWindowEventType = parent.getEventType();
    }

    @Override
    public EventType getEventType() {
        return this.namedWindowEventType;
    }

    @Override
    public Iterator<EventBean> iterator() {
        return null;
    }

    public void destroy() {
        this.indexRepository.destroy();
        this.tablePerStrategy.clear();
    }
}

