/*
 * Decompiled with CFR 0.152.
 */
package net.esper.eql.named;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.esper.core.EPStatementHandle;
import net.esper.core.StatementLockFactory;
import net.esper.eql.named.NamedWindowConsumerDispatchUnit;
import net.esper.eql.named.NamedWindowConsumerView;
import net.esper.eql.named.NamedWindowDeltaData;
import net.esper.eql.named.NamedWindowProcessor;
import net.esper.eql.named.NamedWindowService;
import net.esper.eql.variable.VariableService;
import net.esper.event.EventBean;
import net.esper.event.EventType;
import net.esper.util.ManagedLock;
import net.esper.view.ViewProcessingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamedWindowServiceImpl
implements NamedWindowService {
    private final Map<String, NamedWindowProcessor> processors;
    private final Map<String, ManagedLock> windowStatementLocks;
    private final StatementLockFactory statementLockFactory;
    private final VariableService variableService;
    private ThreadLocal<List<NamedWindowConsumerDispatchUnit>> threadLocal = new ThreadLocal<List<NamedWindowConsumerDispatchUnit>>(){

        @Override
        protected synchronized List<NamedWindowConsumerDispatchUnit> initialValue() {
            return new ArrayList<NamedWindowConsumerDispatchUnit>(100);
        }
    };
    private ThreadLocal<Map<EPStatementHandle, Object>> dispatchesPerStmtTL = new ThreadLocal<Map<EPStatementHandle, Object>>(){

        @Override
        protected synchronized Map<EPStatementHandle, Object> initialValue() {
            return new HashMap<EPStatementHandle, Object>();
        }
    };

    public NamedWindowServiceImpl(StatementLockFactory statementLockFactory, VariableService variableService) {
        this.processors = new HashMap<String, NamedWindowProcessor>();
        this.windowStatementLocks = new HashMap<String, ManagedLock>();
        this.statementLockFactory = statementLockFactory;
        this.variableService = variableService;
    }

    @Override
    public void destroy() {
        this.processors.clear();
        this.threadLocal.remove();
        this.dispatchesPerStmtTL.remove();
    }

    @Override
    public ManagedLock getNamedWindowLock(String windowName) {
        return this.windowStatementLocks.get(windowName);
    }

    @Override
    public void addNamedWindowLock(String windowName, ManagedLock statementResourceLock) {
        this.windowStatementLocks.put(windowName, statementResourceLock);
    }

    @Override
    public boolean isNamedWindow(String name) {
        return this.processors.containsKey(name);
    }

    @Override
    public NamedWindowProcessor getProcessor(String name) {
        NamedWindowProcessor processor = this.processors.get(name);
        if (processor == null) {
            throw new IllegalStateException("A named window by name '" + name + "' does not exist");
        }
        return processor;
    }

    @Override
    public NamedWindowProcessor addProcessor(String name, EventType eventType) throws ViewProcessingException {
        if (this.processors.containsKey(name)) {
            throw new ViewProcessingException("A named window by name '" + name + "' has already been created");
        }
        NamedWindowProcessor processor = new NamedWindowProcessor(this, name, eventType);
        this.processors.put(name, processor);
        return processor;
    }

    @Override
    public void removeProcessor(String name) {
        NamedWindowProcessor processor = this.processors.get(name);
        if (processor != null) {
            processor.destroy();
            this.processors.remove(name);
        }
    }

    @Override
    public void addDispatch(NamedWindowDeltaData delta, Map<EPStatementHandle, List<NamedWindowConsumerView>> consumers) {
        NamedWindowConsumerDispatchUnit unit = new NamedWindowConsumerDispatchUnit(delta, consumers);
        this.threadLocal.get().add(unit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean dispatch() {
        List<NamedWindowConsumerDispatchUnit> dispatches = this.threadLocal.get();
        if (dispatches.isEmpty()) {
            return false;
        }
        if (dispatches.size() == 1) {
            NamedWindowConsumerDispatchUnit unit = dispatches.get(0);
            EventBean[] newData = unit.getDeltaData().getNewData();
            EventBean[] eventBeanArray = unit.getDeltaData().getOldData();
            for (Map.Entry<EPStatementHandle, List<NamedWindowConsumerView>> entry : unit.getDispatchTo().entrySet()) {
                EPStatementHandle handle = entry.getKey();
                handle.getStatementLock().acquireLock(this.statementLockFactory);
                try {
                    if (handle.isHasVariables()) {
                        this.variableService.setLocalVersion();
                    }
                    for (NamedWindowConsumerView consumerView : entry.getValue()) {
                        consumerView.update(newData, eventBeanArray);
                    }
                    handle.internalDispatch();
                }
                finally {
                    handle.getStatementLock().releaseLock(null);
                }
            }
            dispatches.clear();
            return true;
        }
        Map<EPStatementHandle, Object> dispatchesPerStmt = this.dispatchesPerStmtTL.get();
        for (NamedWindowConsumerDispatchUnit namedWindowConsumerDispatchUnit : dispatches) {
            for (Map.Entry<EPStatementHandle, List<NamedWindowConsumerView>> entry : namedWindowConsumerDispatchUnit.getDispatchTo().entrySet()) {
                EPStatementHandle handle = entry.getKey();
                Object perStmtObj = dispatchesPerStmt.get(handle);
                if (perStmtObj == null) {
                    dispatchesPerStmt.put(handle, namedWindowConsumerDispatchUnit);
                    continue;
                }
                if (perStmtObj instanceof List) {
                    List list = (List)perStmtObj;
                    list.add(namedWindowConsumerDispatchUnit);
                    continue;
                }
                NamedWindowConsumerDispatchUnit unitObj = (NamedWindowConsumerDispatchUnit)perStmtObj;
                ArrayList<NamedWindowConsumerDispatchUnit> arrayList = new ArrayList<NamedWindowConsumerDispatchUnit>();
                arrayList.add(unitObj);
                arrayList.add(namedWindowConsumerDispatchUnit);
                dispatchesPerStmt.put(handle, arrayList);
            }
        }
        for (Map.Entry entry : dispatchesPerStmt.entrySet()) {
            EPStatementHandle handle = (EPStatementHandle)entry.getKey();
            Object perStmtObj = entry.getValue();
            if (entry instanceof NamedWindowConsumerDispatchUnit) {
                NamedWindowConsumerDispatchUnit unit = (NamedWindowConsumerDispatchUnit)perStmtObj;
                EventBean[] newData = unit.getDeltaData().getNewData();
                EventBean[] oldData = unit.getDeltaData().getOldData();
                handle.getStatementLock().acquireLock(this.statementLockFactory);
                try {
                    if (handle.isHasVariables()) {
                        this.variableService.setLocalVersion();
                    }
                    for (NamedWindowConsumerView consumerView : unit.getDispatchTo().get(handle)) {
                        consumerView.update(newData, oldData);
                    }
                    handle.internalDispatch();
                    continue;
                }
                finally {
                    handle.getStatementLock().releaseLock(null);
                    continue;
                }
            }
            List list = (List)perStmtObj;
            LinkedHashMap<NamedWindowConsumerView, NamedWindowDeltaData> deltaPerConsumer = new LinkedHashMap<NamedWindowConsumerView, NamedWindowDeltaData>();
            for (NamedWindowConsumerDispatchUnit namedWindowConsumerDispatchUnit : list) {
                for (NamedWindowConsumerView consumerView : namedWindowConsumerDispatchUnit.getDispatchTo().get(handle)) {
                    NamedWindowDeltaData deltaForConsumer = (NamedWindowDeltaData)deltaPerConsumer.get(consumerView);
                    if (deltaForConsumer == null) {
                        deltaPerConsumer.put(consumerView, namedWindowConsumerDispatchUnit.getDeltaData());
                        continue;
                    }
                    NamedWindowDeltaData aggregated = new NamedWindowDeltaData(deltaForConsumer, namedWindowConsumerDispatchUnit.getDeltaData());
                    deltaPerConsumer.put(consumerView, aggregated);
                }
            }
            handle.getStatementLock().acquireLock(this.statementLockFactory);
            try {
                if (handle.isHasVariables()) {
                    this.variableService.setLocalVersion();
                }
                for (Map.Entry entry2 : deltaPerConsumer.entrySet()) {
                    EventBean[] newData = ((NamedWindowDeltaData)entry2.getValue()).getNewData();
                    EventBean[] oldData = ((NamedWindowDeltaData)entry2.getValue()).getOldData();
                    ((NamedWindowConsumerView)entry2.getKey()).update(newData, oldData);
                }
                handle.internalDispatch();
            }
            finally {
                handle.getStatementLock().releaseLock(null);
            }
        }
        dispatches.clear();
        dispatchesPerStmt.clear();
        return true;
    }
}

