/*
 * Decompiled with CFR 0.152.
 */
package net.esper.eql.named;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.esper.core.EPStatementHandle;
import net.esper.eql.expression.ExprNode;
import net.esper.eql.named.NamedWindowConsumerView;
import net.esper.eql.named.NamedWindowDeltaData;
import net.esper.eql.named.NamedWindowRootView;
import net.esper.eql.named.NamedWindowService;
import net.esper.event.EventBean;
import net.esper.event.EventType;
import net.esper.view.StatementStopService;
import net.esper.view.ViewSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamedWindowTailView
extends ViewSupport
implements Iterable<EventBean> {
    private final EventType eventType;
    private final NamedWindowRootView namedWindowRootView;
    private final NamedWindowService namedWindowService;
    private final Map<EPStatementHandle, List<NamedWindowConsumerView>> consumers;

    public NamedWindowTailView(EventType eventType, NamedWindowService namedWindowService, NamedWindowRootView namedWindowRootView) {
        this.eventType = eventType;
        this.namedWindowService = namedWindowService;
        this.consumers = new HashMap<EPStatementHandle, List<NamedWindowConsumerView>>();
        this.namedWindowRootView = namedWindowRootView;
    }

    @Override
    public void update(EventBean[] newData, EventBean[] oldData) {
        if (oldData != null) {
            this.namedWindowRootView.removeOldData(oldData);
        }
        this.updateChildren(newData, oldData);
        NamedWindowDeltaData delta = new NamedWindowDeltaData(newData, oldData);
        this.namedWindowService.addDispatch(delta, this.consumers);
    }

    public NamedWindowConsumerView addConsumer(List<ExprNode> filterList, EPStatementHandle statementHandle, StatementStopService statementStopService) {
        NamedWindowConsumerView consumerView = new NamedWindowConsumerView(filterList, this.eventType, statementStopService, this);
        List<NamedWindowConsumerView> viewsPerStatements = this.consumers.get(statementHandle);
        if (viewsPerStatements == null) {
            viewsPerStatements = new ArrayList<NamedWindowConsumerView>();
            this.consumers.put(statementHandle, viewsPerStatements);
        }
        viewsPerStatements.add(consumerView);
        return consumerView;
    }

    public void removeConsumer(NamedWindowConsumerView namedWindowConsumerView) {
        Map.Entry<EPStatementHandle, List<NamedWindowConsumerView>> entry;
        boolean foundAndRemoved;
        EPStatementHandle handleRemoved = null;
        Iterator<Map.Entry<EPStatementHandle, List<NamedWindowConsumerView>>> i$ = this.consumers.entrySet().iterator();
        if (i$.hasNext() && (foundAndRemoved = (entry = i$.next()).getValue().remove(namedWindowConsumerView)) && entry.getValue().size() == 0) {
            handleRemoved = entry.getKey();
        }
        if (handleRemoved != null) {
            this.consumers.remove(handleRemoved);
        }
    }

    @Override
    public EventType getEventType() {
        return this.eventType;
    }

    @Override
    public Iterator<EventBean> iterator() {
        return this.parent.iterator();
    }

    public void destroy() {
        this.consumers.clear();
    }
}

