/*
 * Decompiled with CFR 0.152.
 */
package net.esper.eql.parse;

import antlr.collections.AST;
import net.esper.eql.generated.EqlEvalTokenTypes;
import net.esper.type.BoolValue;
import net.esper.type.DoubleValue;
import net.esper.type.FloatValue;
import net.esper.type.IntValue;
import net.esper.type.LongValue;
import net.esper.type.StringValue;

public class ASTConstantHelper
implements EqlEvalTokenTypes {
    public static Object parse(AST node) {
        switch (node.getType()) {
            case 172: {
                return ASTConstantHelper.parseIntLong(node.getText());
            }
            case 165: {
                return ASTConstantHelper.parseIntLong(node.getText());
            }
            case 166: {
                return LongValue.parseString(node.getText());
            }
            case 170: {
                return BoolValue.parseString(node.getText());
            }
            case 167: {
                return Float.valueOf(FloatValue.parseString(node.getText()));
            }
            case 168: {
                return DoubleValue.parseString(node.getText());
            }
            case 169: {
                return StringValue.parseString(node.getText());
            }
            case 171: {
                return null;
            }
        }
        throw new IllegalArgumentException("Unexpected constant of non-primitve type " + node.getType() + " encountered");
    }

    private static Object parseIntLong(String arg) {
        try {
            return IntValue.parseString(arg);
        }
        catch (NumberFormatException ex) {
            try {
                return LongValue.parseString(arg);
            }
            catch (Exception e) {
                throw ex;
            }
        }
    }
}

