/*
 * Decompiled with CFR 0.152.
 */
package net.esper.eql.parse;

import antlr.collections.AST;
import java.util.Arrays;
import java.util.HashSet;
import net.esper.eql.generated.EqlEvalTokenTypes;
import net.esper.eql.parse.ASTConstantHelper;
import net.esper.eql.parse.ASTWalkException;
import net.esper.type.BoolValue;
import net.esper.type.CronParameter;
import net.esper.type.DoubleValue;
import net.esper.type.FloatValue;
import net.esper.type.FrequencyParameter;
import net.esper.type.IntParameter;
import net.esper.type.IntValue;
import net.esper.type.ListParameter;
import net.esper.type.LongValue;
import net.esper.type.NumberSetParameter;
import net.esper.type.RangeParameter;
import net.esper.type.StringValue;
import net.esper.type.TimePeriodParameter;
import net.esper.type.WildcardParameter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ASTParameterHelper
implements EqlEvalTokenTypes {
    private static final Log log = LogFactory.getLog(ASTParameterHelper.class);

    public static Object makeParameter(AST parameterNode) throws ASTWalkException {
        return ASTParameterHelper.parseConstant(parameterNode);
    }

    private static Object parseConstant(AST node) throws ASTWalkException {
        if (log.isDebugEnabled()) {
            log.debug(".parseConstant Node type=" + node.getType() + " text=" + node.getText());
        }
        switch (node.getType()) {
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 169: 
            case 170: 
            case 172: {
                return ASTConstantHelper.parse(node);
            }
            case 76: {
                return ASTParameterHelper.makeFrequency(node);
            }
            case 74: {
                return ASTParameterHelper.makeRange(node);
            }
            case 51: 
            case 66: 
            case 152: 
            case 153: {
                return ASTParameterHelper.makeCronParameter(node);
            }
            case 188: {
                return new WildcardParameter();
            }
            case 75: {
                return ASTParameterHelper.makeList(node);
            }
            case 78: {
                return ASTParameterHelper.makeArray(node);
            }
            case 129: {
                return ASTParameterHelper.makeTimePeriod(node);
            }
        }
        throw new ASTWalkException("Unexpected constant of type " + node.getType() + " encountered");
    }

    private static TimePeriodParameter makeTimePeriod(AST node) {
        double result = 0.0;
        block7: for (AST child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            Number numValue = (Number)ASTParameterHelper.parseConstant(child.getFirstChild());
            double partValue = numValue.doubleValue();
            switch (child.getType()) {
                case 135: {
                    result += partValue / 1000.0;
                    continue block7;
                }
                case 134: {
                    result += partValue;
                    continue block7;
                }
                case 133: {
                    result += 60.0 * partValue;
                    continue block7;
                }
                case 132: {
                    result += 3600.0 * partValue;
                    continue block7;
                }
                case 131: {
                    result += 86400.0 * partValue;
                    continue block7;
                }
                default: {
                    throw new IllegalStateException("Illegal part of interval encountered, type=" + child.getType() + " text=" + child.getText());
                }
            }
        }
        return new TimePeriodParameter(result);
    }

    private static Object makeList(AST node) throws ASTWalkException {
        ListParameter list = new ListParameter();
        for (AST child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            Object parsedChild = ASTParameterHelper.parseConstant(child);
            if (parsedChild instanceof Integer) {
                list.add(new IntParameter((Integer)parsedChild));
                continue;
            }
            list.add((NumberSetParameter)parsedChild);
        }
        return list;
    }

    private static Object makeFrequency(AST node) {
        int frequency = IntValue.parseString(node.getFirstChild().getText());
        return new FrequencyParameter(frequency);
    }

    private static Object makeRange(AST node) {
        int low = IntValue.parseString(node.getFirstChild().getText());
        int high = IntValue.parseString(node.getFirstChild().getNextSibling().getText());
        return new RangeParameter(low, high);
    }

    private static Object makeCronParameter(AST node) {
        if (node.getFirstChild() == null) {
            return new CronParameter(node.getText(), null);
        }
        return new CronParameter(node.getText(), node.getFirstChild().getText());
    }

    private static Object makeArray(AST node) throws ASTWalkException {
        HashSet<Integer> nodeTypes = new HashSet<Integer>();
        for (AST child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            nodeTypes.add(child.getType());
        }
        if (nodeTypes.isEmpty()) {
            return new Object[0];
        }
        if (nodeTypes.size() == 1) {
            return ASTParameterHelper.makeUniform(node);
        }
        return ASTParameterHelper.makeNonUniform(node);
    }

    private static Object makeNonUniform(AST node) throws ASTWalkException {
        int count = node.getNumberOfChildren();
        Object[] result = new Object[count];
        int index = 0;
        for (AST child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            result[index++] = ASTParameterHelper.parseConstant(child);
        }
        return result;
    }

    private static Object makeUniform(AST node) throws ASTWalkException {
        int count = node.getNumberOfChildren();
        String[] values = new String[count];
        int index = 0;
        for (AST child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            values[index++] = child.getText();
        }
        return ASTParameterHelper.parseStringArray(node.getFirstChild().getType(), values);
    }

    private static Object parseStringArray(int nodeType, String[] nodeValues) throws ASTWalkException {
        if (log.isDebugEnabled()) {
            log.debug(".parseStringArray Node type=" + nodeType + " values=" + Arrays.toString(nodeValues));
        }
        switch (nodeType) {
            case 165: {
                return IntValue.parseString(nodeValues);
            }
            case 166: {
                return LongValue.parseString(nodeValues);
            }
            case 170: {
                return BoolValue.parseString(nodeValues);
            }
            case 167: {
                return FloatValue.parseString(nodeValues);
            }
            case 168: {
                return DoubleValue.parseString(nodeValues);
            }
            case 169: {
                return StringValue.parseString(nodeValues);
            }
        }
        throw new IllegalStateException("Unexpected constant of type " + nodeType + " encountered");
    }
}

