/*
 * Decompiled with CFR 0.152.
 */
package net.esper.eql.parse;

import antlr.SemanticException;
import antlr.collections.AST;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import net.esper.collection.UniformPair;
import net.esper.eql.agg.AggregationSupport;
import net.esper.eql.core.EngineImportException;
import net.esper.eql.core.EngineImportService;
import net.esper.eql.core.EngineImportUndefinedException;
import net.esper.eql.expression.ExprAggregateNode;
import net.esper.eql.expression.ExprAndNode;
import net.esper.eql.expression.ExprArrayNode;
import net.esper.eql.expression.ExprAvedevNode;
import net.esper.eql.expression.ExprAvgNode;
import net.esper.eql.expression.ExprBetweenNode;
import net.esper.eql.expression.ExprBitWiseNode;
import net.esper.eql.expression.ExprCaseNode;
import net.esper.eql.expression.ExprCastNode;
import net.esper.eql.expression.ExprCoalesceNode;
import net.esper.eql.expression.ExprConcatNode;
import net.esper.eql.expression.ExprConstantNode;
import net.esper.eql.expression.ExprCountNode;
import net.esper.eql.expression.ExprEqualsNode;
import net.esper.eql.expression.ExprIdentNode;
import net.esper.eql.expression.ExprInNode;
import net.esper.eql.expression.ExprInstanceofNode;
import net.esper.eql.expression.ExprLikeNode;
import net.esper.eql.expression.ExprMathNode;
import net.esper.eql.expression.ExprMedianNode;
import net.esper.eql.expression.ExprMinMaxAggrNode;
import net.esper.eql.expression.ExprMinMaxRowNode;
import net.esper.eql.expression.ExprNode;
import net.esper.eql.expression.ExprNotNode;
import net.esper.eql.expression.ExprOrNode;
import net.esper.eql.expression.ExprPlugInAggFunctionNode;
import net.esper.eql.expression.ExprPreviousNode;
import net.esper.eql.expression.ExprPriorNode;
import net.esper.eql.expression.ExprPropertyExistsNode;
import net.esper.eql.expression.ExprRegexpNode;
import net.esper.eql.expression.ExprRelationalOpNode;
import net.esper.eql.expression.ExprStaticMethodNode;
import net.esper.eql.expression.ExprStddevNode;
import net.esper.eql.expression.ExprSubselectExistsNode;
import net.esper.eql.expression.ExprSubselectInNode;
import net.esper.eql.expression.ExprSubselectRowNode;
import net.esper.eql.expression.ExprSubstitutionNode;
import net.esper.eql.expression.ExprSumNode;
import net.esper.eql.expression.ExprTimestampNode;
import net.esper.eql.expression.ExprVariableNode;
import net.esper.eql.generated.EQLBaseWalker;
import net.esper.eql.parse.ASTConstantHelper;
import net.esper.eql.parse.ASTFilterSpecHelper;
import net.esper.eql.parse.ASTOutputLimitHelper;
import net.esper.eql.parse.ASTParameterHelper;
import net.esper.eql.parse.ASTViewSpecHelper;
import net.esper.eql.parse.ASTWalkException;
import net.esper.eql.spec.CreateVariableDesc;
import net.esper.eql.spec.CreateWindowDesc;
import net.esper.eql.spec.DBStatementStreamSpec;
import net.esper.eql.spec.FilterSpecRaw;
import net.esper.eql.spec.FilterStreamSpecRaw;
import net.esper.eql.spec.InsertIntoDesc;
import net.esper.eql.spec.MethodStreamSpec;
import net.esper.eql.spec.OnTriggerSetAssignment;
import net.esper.eql.spec.OnTriggerSetDesc;
import net.esper.eql.spec.OnTriggerWindowDesc;
import net.esper.eql.spec.OrderByItem;
import net.esper.eql.spec.OuterJoinDesc;
import net.esper.eql.spec.OutputLimitSpec;
import net.esper.eql.spec.PatternGuardSpec;
import net.esper.eql.spec.PatternObserverSpec;
import net.esper.eql.spec.PatternStreamSpecRaw;
import net.esper.eql.spec.SelectClauseStreamSelectorEnum;
import net.esper.eql.spec.SelectExprElementRawSpec;
import net.esper.eql.spec.SelectExprElementStreamRawSpec;
import net.esper.eql.spec.StatementSpecRaw;
import net.esper.eql.spec.StreamSpecBase;
import net.esper.eql.spec.StreamSpecRaw;
import net.esper.eql.spec.ViewSpec;
import net.esper.eql.variable.VariableService;
import net.esper.pattern.EvalAndNode;
import net.esper.pattern.EvalEveryNode;
import net.esper.pattern.EvalFilterNode;
import net.esper.pattern.EvalFollowedByNode;
import net.esper.pattern.EvalGuardNode;
import net.esper.pattern.EvalNode;
import net.esper.pattern.EvalNotNode;
import net.esper.pattern.EvalObserverNode;
import net.esper.pattern.EvalOrNode;
import net.esper.type.BitWiseOpEnum;
import net.esper.type.MathArithTypeEnum;
import net.esper.type.MinMaxTypeEnum;
import net.esper.type.OuterJoinType;
import net.esper.type.RelationalOpEnum;
import net.esper.type.StringValue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EQLTreeWalker
extends EQLBaseWalker {
    private Map<AST, ExprNode> astExprNodeMap = new HashMap<AST, ExprNode>();
    private final Stack<Map<AST, ExprNode>> astExprNodeMapStack;
    private final Map<AST, EvalNode> astPatternNodeMap = new HashMap<AST, EvalNode>();
    private FilterSpecRaw filterSpec;
    private final List<ViewSpec> viewSpecs = new LinkedList<ViewSpec>();
    private boolean isProcessingPattern;
    private List<ExprSubstitutionNode> substitutionParamNodes = new ArrayList<ExprSubstitutionNode>();
    private StatementSpecRaw statementSpec;
    private final Stack<StatementSpecRaw> statementSpecStack;
    private final EngineImportService engineImportService;
    private final VariableService variableService;
    private static final Log log = LogFactory.getLog(EQLTreeWalker.class);

    public EQLTreeWalker(EngineImportService engineImportService, VariableService variableService) {
        this.engineImportService = engineImportService;
        this.variableService = variableService;
        this.statementSpec = new StatementSpecRaw();
        this.statementSpecStack = new Stack();
        this.astExprNodeMapStack = new Stack();
    }

    @Override
    protected void pushStmtContext() throws SemanticException {
        if (log.isDebugEnabled()) {
            log.debug(".pushStmtContext");
        }
        this.statementSpecStack.push(this.statementSpec);
        this.astExprNodeMapStack.push(this.astExprNodeMap);
        this.statementSpec = new StatementSpecRaw();
        this.astExprNodeMap = new HashMap<AST, ExprNode>();
    }

    public StatementSpecRaw getStatementSpec() {
        return this.statementSpec;
    }

    @Override
    protected void setIsPatternWalk(boolean isPatternWalk) {
        if (log.isDebugEnabled()) {
            log.debug(".setIsPatternWalk " + isPatternWalk);
        }
        this.isProcessingPattern = isPatternWalk;
    }

    @Override
    protected void leaveNode(AST node) throws ASTWalkException {
        if (log.isDebugEnabled()) {
            log.debug(".leaveNode " + node);
        }
        switch (node.getType()) {
            case 106: {
                this.leaveStreamExpr(node);
                break;
            }
            case 79: {
                this.leaveFilter(node);
                break;
            }
            case 93: {
                return;
            }
            case 92: {
                this.leaveView(node);
                break;
            }
            case 103: {
                this.leaveSelectClause(node);
                break;
            }
            case 143: {
                this.leaveWildcardSelect();
                break;
            }
            case 104: {
                this.leaveSelectionElement(node);
                break;
            }
            case 105: {
                this.leaveSelectionStream(node);
                break;
            }
            case 114: {
                this.leaveEventPropertyExpr(node);
                break;
            }
            case 98: {
                this.leaveJoinAndExpr(node);
                break;
            }
            case 99: {
                this.leaveJoinOrExpr(node);
                break;
            }
            case 100: 
            case 101: {
                this.leaveEqualsExpr(node);
                break;
            }
            case 95: {
                this.leaveWhereClause();
                break;
            }
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 169: 
            case 170: 
            case 171: 
            case 172: {
                this.leaveConstant(node);
                break;
            }
            case 154: {
                this.leaveSubstitution(node);
                break;
            }
            case 177: 
            case 178: 
            case 188: 
            case 204: 
            case 205: {
                this.leaveMath(node);
                break;
            }
            case 194: 
            case 195: 
            case 196: {
                this.leaveBitWise(node);
                break;
            }
            case 199: 
            case 200: 
            case 201: 
            case 202: {
                this.leaveRelationalOp(node);
                break;
            }
            case 21: {
                this.leaveCoalesce(node);
                break;
            }
            case 13: {
                this.leaveNot(node);
                break;
            }
            case 17: 
            case 18: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                this.leaveAggregate(node);
                break;
            }
            case 127: {
                this.leaveLibFunction(node);
                break;
            }
            case 108: 
            case 109: 
            case 110: {
                this.leaveOuterJoin(node);
                break;
            }
            case 111: {
                this.leaveGroupBy(node);
                break;
            }
            case 96: {
                this.leaveHavingClause();
                break;
            }
            case 112: {
                break;
            }
            case 113: {
                this.leaveOrderByElement(node);
                break;
            }
            case 121: 
            case 122: 
            case 123: {
                this.leaveOutputLimit(node);
                break;
            }
            case 124: {
                this.leaveInsertInto(node);
                break;
            }
            case 126: {
                this.leaveConcat(node);
                break;
            }
            case 27: {
                this.leaveCaseNode(node, false);
                break;
            }
            case 28: {
                this.leaveCaseNode(node, true);
                break;
            }
            case 14: {
                this.leaveEvery(node);
                break;
            }
            case 77: {
                this.leaveFollowedBy(node);
                break;
            }
            case 11: {
                this.leaveOr(node);
                break;
            }
            case 12: {
                this.leaveAnd(node);
                break;
            }
            case 90: {
                this.leaveGuard(node);
                break;
            }
            case 91: {
                this.leaveObserver(node);
                break;
            }
            case 6: 
            case 136: {
                this.leaveInSet(node);
                break;
            }
            case 145: 
            case 146: {
                this.leaveInRange(node);
                break;
            }
            case 7: 
            case 137: {
                this.leaveBetween(node);
                break;
            }
            case 8: 
            case 138: {
                this.leaveLike(node);
                break;
            }
            case 9: 
            case 139: {
                this.leaveRegexp(node);
                break;
            }
            case 62: {
                this.leavePrevious(node);
                break;
            }
            case 63: {
                this.leavePrior(node);
                break;
            }
            case 130: {
                this.leaveArray(node);
                break;
            }
            case 147: {
                this.leaveSubselectRow(node);
                break;
            }
            case 148: {
                this.leaveSubselectExists(node);
                break;
            }
            case 149: 
            case 150: {
                this.leaveSubselectIn(node);
                break;
            }
            case 151: {
                this.leaveSubselectQueryIn(node);
                break;
            }
            case 67: {
                this.leaveInstanceOf(node);
                break;
            }
            case 64: {
                this.leaveExists(node);
                break;
            }
            case 68: {
                this.leaveCast(node);
                break;
            }
            case 69: {
                this.leaveTimestamp(node);
                break;
            }
            case 156: {
                this.leaveCreateWindow(node);
                break;
            }
            case 157: {
                this.leaveCreateWindowSelect(node);
                break;
            }
            case 163: {
                this.leaveCreateVariable(node);
                break;
            }
            case 158: {
                this.leaveOnExpr(node);
                break;
            }
            default: {
                throw new ASTWalkException("Unhandled node type encountered, type '" + node.getType() + "' with text '" + node.getText() + '\'');
            }
        }
        ExprNode thisEvalNode = this.astExprNodeMap.get(node);
        AST childNode = node.getFirstChild();
        do {
            ExprNode childEvalNode;
            if ((childEvalNode = this.astExprNodeMap.get(childNode)) != null && thisEvalNode != null) {
                thisEvalNode.addChildNode(childEvalNode);
                this.astExprNodeMap.remove(childNode);
            }
            if (childNode == null) continue;
            childNode = childNode.getNextSibling();
        } while (childNode != null);
        EvalNode thisPatternNode = this.astPatternNodeMap.get(node);
        childNode = node.getFirstChild();
        do {
            EvalNode childEvalNode;
            if ((childEvalNode = this.astPatternNodeMap.get(childNode)) != null) {
                thisPatternNode.addChildNode(childEvalNode);
                this.astPatternNodeMap.remove(childNode);
            }
            if (childNode == null) continue;
            childNode = childNode.getNextSibling();
        } while (childNode != null);
    }

    private void leaveCreateWindow(AST node) {
        log.debug(".leaveCreateWindow");
        String windowName = node.getFirstChild().getText();
        String eventName = null;
        for (AST child = node.getFirstChild().getNextSibling(); child != null; child = child.getNextSibling()) {
            if (child.getType() != 89) continue;
            eventName = child.getText();
        }
        if (eventName == null) {
            throw new ASTWalkException("Event type AST not found");
        }
        CreateWindowDesc desc = new CreateWindowDesc(windowName, this.viewSpecs);
        this.statementSpec.setCreateWindowDesc(desc);
        FilterSpecRaw rawFilterSpec = new FilterSpecRaw(eventName, new LinkedList<ExprNode>());
        FilterStreamSpecRaw streamSpec = new FilterStreamSpecRaw(rawFilterSpec, new LinkedList<ViewSpec>(), null);
        this.statementSpec.getStreamSpecs().add(streamSpec);
    }

    private void leaveCreateVariable(AST node) {
        log.debug(".leaveCreateVariable");
        AST child = node.getFirstChild();
        String variableType = child.getText();
        child = child.getNextSibling();
        String variableName = child.getText();
        ExprNode assignment = null;
        child = child.getNextSibling();
        if (child != null) {
            assignment = this.astExprNodeMap.get(child);
            this.astExprNodeMap.remove(child);
        }
        CreateVariableDesc desc = new CreateVariableDesc(variableType, variableName, assignment);
        this.statementSpec.setCreateVariableDesc(desc);
    }

    private void leaveCreateWindowSelect(AST node) {
        log.debug(".leaveCreateWindowSelect");
    }

    private void leaveOnExpr(AST node) {
        StreamSpecBase streamSpec;
        AST typeChildNode;
        log.debug(".leaveOnExpr");
        boolean isOnDelete = false;
        for (typeChildNode = node.getFirstChild(); typeChildNode != null; typeChildNode = typeChildNode.getNextSibling()) {
            if (typeChildNode.getType() == 159) {
                isOnDelete = true;
                break;
            }
            if (typeChildNode.getType() == 160 || typeChildNode.getType() == 162) break;
        }
        if (typeChildNode == null) {
            throw new IllegalStateException("Could not determine on-expr type");
        }
        AST childNode = node.getFirstChild().getNextSibling();
        String streamAsName = null;
        if (childNode.getType() == 184) {
            streamAsName = childNode.getText();
        }
        if (node.getFirstChild().getType() == 79) {
            streamSpec = new FilterStreamSpecRaw(this.filterSpec, new ArrayList<ViewSpec>(), streamAsName);
        } else if (node.getFirstChild().getType() == 93) {
            if (this.astPatternNodeMap.size() > 1 || this.astPatternNodeMap.isEmpty()) {
                throw new ASTWalkException("Unexpected AST tree contains zero or more then 1 child elements for root");
            }
            EvalNode evalNode = this.astPatternNodeMap.values().iterator().next();
            streamSpec = new PatternStreamSpecRaw(evalNode, this.viewSpecs, streamAsName);
            this.astPatternNodeMap.clear();
        } else {
            throw new IllegalStateException("Invalid AST type node, cannot map to stream specification");
        }
        if (typeChildNode.getType() != 162) {
            UniformPair<String> windowName = this.getWindowName(typeChildNode);
            this.statementSpec.setOnTriggerDesc(new OnTriggerWindowDesc(windowName.getFirst(), windowName.getSecond(), isOnDelete));
        } else {
            OnTriggerSetDesc setDesc = this.getOnTriggerSet(typeChildNode);
            this.statementSpec.setOnTriggerDesc(setDesc);
        }
        this.statementSpec.getStreamSpecs().add((StreamSpecRaw)((Object)streamSpec));
    }

    private OnTriggerSetDesc getOnTriggerSet(AST typeChildNode) {
        OnTriggerSetDesc desc = new OnTriggerSetDesc();
        AST child = typeChildNode.getFirstChild();
        do {
            if (child.getType() != 184) {
                throw new IllegalStateException("Expected identifier but received type '" + child.getType() + "'");
            }
            String variableName = child.getText();
            child = child.getNextSibling();
            ExprNode childEvalNode = this.astExprNodeMap.get(child);
            this.astExprNodeMap.remove(child);
            desc.addAssignment(new OnTriggerSetAssignment(variableName, childEvalNode));
        } while ((child = child.getNextSibling()) != null);
        return desc;
    }

    private UniformPair<String> getWindowName(AST typeChildNode) {
        String windowName = null;
        String windowStreamName = null;
        for (AST child = typeChildNode.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getType() != 161) continue;
            windowName = child.getFirstChild().getText();
            if (child.getFirstChild().getNextSibling() == null) break;
            windowStreamName = child.getFirstChild().getNextSibling().getText();
            break;
        }
        if (windowName == null) {
            throw new IllegalStateException("Could not determine on-expr from-clause named window name");
        }
        return new UniformPair<Object>(windowName, windowStreamName);
    }

    private void leavePrevious(AST node) {
        log.debug(".leavePrevious");
        ExprPreviousNode previousNode = new ExprPreviousNode();
        this.astExprNodeMap.put(node, previousNode);
    }

    private void leavePrior(AST node) {
        log.debug(".leavePrior");
        ExprPriorNode priorNode = new ExprPriorNode();
        this.astExprNodeMap.put(node, priorNode);
    }

    private void leaveInstanceOf(AST node) {
        log.debug(".leaveInstanceOf");
        ArrayList<String> classes = new ArrayList<String>();
        for (AST classIdent = node.getFirstChild().getNextSibling(); classIdent != null; classIdent = classIdent.getNextSibling()) {
            classes.add(classIdent.getText());
        }
        String[] idents = classes.toArray(new String[0]);
        ExprInstanceofNode instanceofNode = new ExprInstanceofNode(idents);
        this.astExprNodeMap.put(node, instanceofNode);
    }

    private void leaveExists(AST node) {
        log.debug(".leaveExists");
        ExprPropertyExistsNode instanceofNode = new ExprPropertyExistsNode();
        this.astExprNodeMap.put(node, instanceofNode);
    }

    private void leaveCast(AST node) {
        log.debug(".leaveCast");
        String classIdent = node.getFirstChild().getNextSibling().getText();
        ExprCastNode castNode = new ExprCastNode(classIdent);
        this.astExprNodeMap.put(node, castNode);
    }

    private void leaveTimestamp(AST node) {
        log.debug(".leaveTimestamp");
        ExprTimestampNode timeNode = new ExprTimestampNode();
        this.astExprNodeMap.put(node, timeNode);
    }

    private void leaveArray(AST node) {
        log.debug(".leaveArray");
        ExprArrayNode arrayNode = new ExprArrayNode();
        this.astExprNodeMap.put(node, arrayNode);
    }

    private void leaveSubselectRow(AST node) {
        log.debug(".leaveSubselectRow");
        StatementSpecRaw currentSpec = this.popStacks();
        ExprSubselectRowNode subselectNode = new ExprSubselectRowNode(currentSpec);
        this.astExprNodeMap.put(node, subselectNode);
    }

    private void leaveSubselectExists(AST node) {
        log.debug(".leaveSubselectExists");
        StatementSpecRaw currentSpec = this.popStacks();
        ExprSubselectExistsNode subselectNode = new ExprSubselectExistsNode(currentSpec);
        this.astExprNodeMap.put(node, subselectNode);
    }

    private void leaveSubselectIn(AST node) {
        log.debug(".leaveSubselectIn");
        AST nodeEvalExpr = node.getFirstChild();
        AST nodeSubquery = nodeEvalExpr.getNextSibling();
        boolean isNot = false;
        if (node.getType() == 150) {
            isNot = true;
        }
        ExprSubselectInNode subqueryNode = (ExprSubselectInNode)this.astExprNodeMap.remove(nodeSubquery);
        subqueryNode.setNotIn(isNot);
        this.astExprNodeMap.put(node, subqueryNode);
    }

    private void leaveSubselectQueryIn(AST node) {
        log.debug(".leaveSubselectQueryIn");
        StatementSpecRaw currentSpec = this.popStacks();
        ExprSubselectInNode subselectNode = new ExprSubselectInNode(currentSpec);
        this.astExprNodeMap.put(node, subselectNode);
    }

    private StatementSpecRaw popStacks() {
        log.debug(".popStacks");
        StatementSpecRaw currentSpec = this.statementSpec;
        this.statementSpec = this.statementSpecStack.pop();
        if (currentSpec.isHasVariables()) {
            this.statementSpec.setHasVariables(true);
        }
        this.astExprNodeMap = this.astExprNodeMapStack.pop();
        return currentSpec;
    }

    @Override
    protected void endPattern() throws ASTWalkException {
        log.debug(".endPattern");
        if (this.astPatternNodeMap.size() > 1 || this.astPatternNodeMap.isEmpty()) {
            throw new ASTWalkException("Unexpected AST tree contains zero or more then 1 child elements for root");
        }
        EvalNode evalNode = this.astPatternNodeMap.values().iterator().next();
        PatternStreamSpecRaw streamSpec = new PatternStreamSpecRaw(evalNode, new LinkedList<ViewSpec>(), null);
        this.statementSpec.getStreamSpecs().add(streamSpec);
        this.statementSpec.setExistsSubstitutionParameters(this.substitutionParamNodes.size() > 0);
        this.astPatternNodeMap.clear();
    }

    @Override
    protected void end() throws ASTWalkException {
        log.debug(".end");
        if (this.astExprNodeMap.size() > 1) {
            throw new ASTWalkException("Unexpected AST tree contains left over child elements, not all expression nodes have been removed from AST-to-expression nodes map");
        }
        if (this.astPatternNodeMap.size() > 1) {
            throw new ASTWalkException("Unexpected AST tree contains left over child elements, not all pattern nodes have been removed from AST-to-pattern nodes map");
        }
        this.statementSpec.setExistsSubstitutionParameters(this.substitutionParamNodes.size() > 0);
    }

    private void leaveSelectionElement(AST node) throws ASTWalkException {
        log.debug(".leaveSelectionElement");
        if (this.astExprNodeMap.size() > 1 || this.astExprNodeMap.isEmpty()) {
            throw new ASTWalkException("Unexpected AST tree contains zero or more then 1 child element for root");
        }
        ExprNode exprNode = this.astExprNodeMap.values().iterator().next();
        this.astExprNodeMap.clear();
        String optionalName = null;
        if (node.getFirstChild().getNextSibling() != null) {
            optionalName = node.getFirstChild().getNextSibling().getText();
        }
        this.statementSpec.getSelectClauseSpec().add(new SelectExprElementRawSpec(exprNode, optionalName));
    }

    private void leaveSelectionStream(AST node) throws ASTWalkException {
        log.debug(".leaveSelectionStream");
        String streamName = node.getFirstChild().getText();
        String optionalName = null;
        if (node.getFirstChild().getNextSibling() != null) {
            optionalName = node.getFirstChild().getNextSibling().getText();
        }
        this.statementSpec.getSelectClauseSpec().add(new SelectExprElementStreamRawSpec(streamName, optionalName));
    }

    private void leaveWildcardSelect() {
        log.debug(".leaveWildcardSelect");
        this.statementSpec.getSelectClauseSpec().setIsUsingWildcard(true);
    }

    private void leaveView(AST node) throws ASTWalkException {
        log.debug(".leaveView");
        ViewSpec spec = ASTViewSpecHelper.buildSpec(node);
        this.viewSpecs.add(spec);
    }

    private void leaveStreamExpr(AST node) {
        StreamSpecBase streamSpec;
        AST streamNameNode;
        log.debug(".leaveStreamExpr");
        for (streamNameNode = node.getFirstChild().getNextSibling(); streamNameNode != null && streamNameNode.getType() != 184; streamNameNode = streamNameNode.getNextSibling()) {
        }
        String streamName = null;
        if (streamNameNode != null) {
            streamName = streamNameNode.getText();
        }
        if (node.getFirstChild().getType() == 79) {
            streamSpec = new FilterStreamSpecRaw(this.filterSpec, this.viewSpecs, streamName);
        } else if (node.getFirstChild().getType() == 93) {
            if (this.astPatternNodeMap.size() > 1 || this.astPatternNodeMap.isEmpty()) {
                throw new ASTWalkException("Unexpected AST tree contains zero or more then 1 child elements for root");
            }
            EvalNode evalNode = this.astPatternNodeMap.values().iterator().next();
            streamSpec = new PatternStreamSpecRaw(evalNode, this.viewSpecs, streamName);
            this.astPatternNodeMap.clear();
        } else if (node.getFirstChild().getType() == 94) {
            AST dbchildNode = node.getFirstChild().getFirstChild();
            String dbName = dbchildNode.getText();
            String sqlWithParams = StringValue.parseString(dbchildNode.getNextSibling().getText().trim());
            String sampleSQL = null;
            if (dbchildNode.getNextSibling().getNextSibling() != null) {
                sampleSQL = dbchildNode.getNextSibling().getNextSibling().getText();
                sampleSQL = StringValue.parseString(sampleSQL.trim());
            }
            streamSpec = new DBStatementStreamSpec(streamName, this.viewSpecs, dbName, sqlWithParams, sampleSQL);
        } else if (node.getFirstChild().getType() == 164) {
            String methodNamePart;
            String classNamePart;
            AST childNode = node.getFirstChild().getFirstChild();
            String prefixIdent = childNode.getText();
            childNode = childNode.getNextSibling();
            String className = childNode.getText();
            childNode = childNode.getNextSibling();
            int indexDot = className.lastIndexOf(46);
            if (indexDot == -1) {
                classNamePart = className;
                methodNamePart = null;
            } else {
                classNamePart = className.substring(0, indexDot);
                methodNamePart = className.substring(indexDot + 1);
            }
            List<ExprNode> exprNodes = this.getExprNodes(childNode);
            streamSpec = new MethodStreamSpec(streamName, this.viewSpecs, prefixIdent, classNamePart, methodNamePart, exprNodes);
        } else {
            throw new ASTWalkException("Unexpected AST child node to stream expression, type=" + node.getFirstChild().getType());
        }
        this.viewSpecs.clear();
        this.statementSpec.getStreamSpecs().add((StreamSpecRaw)((Object)streamSpec));
    }

    private void leaveEventPropertyExpr(AST node) {
        ExprNode exprNode;
        String propertyName;
        log.debug(".leaveEventPropertyExpr");
        if (node.getNumberOfChildren() == 0) {
            throw new IllegalStateException("Empty event property expression encountered");
        }
        if (node.getNumberOfChildren() == 1 || node.getFirstChild().getType() != 115) {
            propertyName = ASTFilterSpecHelper.getPropertyName(node.getFirstChild());
            exprNode = new ExprIdentNode(propertyName);
        } else {
            String streamOrNestedPropertyName = node.getFirstChild().getFirstChild().getText();
            propertyName = ASTFilterSpecHelper.getPropertyName(node.getFirstChild().getNextSibling());
            exprNode = new ExprIdentNode(propertyName, streamOrNestedPropertyName);
        }
        if (this.variableService.getReader(propertyName) != null) {
            exprNode = new ExprVariableNode(propertyName);
            this.statementSpec.setHasVariables(true);
        }
        this.astExprNodeMap.put(node, exprNode);
    }

    private void leaveLibFunction(AST node) {
        log.debug(".leaveLibFunction");
        String childNodeText = node.getFirstChild().getText();
        if (childNodeText.equals("max") || childNodeText.equals("min")) {
            this.handleMinMax(node);
            return;
        }
        if (node.getFirstChild().getType() == 89) {
            String className = node.getFirstChild().getText();
            String methodName = node.getFirstChild().getNextSibling().getText();
            this.astExprNodeMap.put(node, new ExprStaticMethodNode(className, methodName));
            return;
        }
        try {
            AggregationSupport aggregation = this.engineImportService.resolveAggregation(childNodeText);
            boolean isDistinct = false;
            if (node.getFirstChild().getNextSibling() != null && node.getFirstChild().getNextSibling().getType() == 44) {
                isDistinct = true;
            }
            this.astExprNodeMap.put(node, new ExprPlugInAggFunctionNode(isDistinct, aggregation, childNodeText));
            return;
        }
        catch (EngineImportUndefinedException e) {
        }
        catch (EngineImportException e) {
            throw new IllegalStateException("Error resolving aggregation: " + e.getMessage(), e);
        }
        throw new IllegalStateException("Unknown method named '" + childNodeText + "' could not be resolved");
    }

    private void leaveEqualsExpr(AST node) {
        log.debug(".leaveEqualsExpr");
        boolean isNot = false;
        if (node.getType() == 101) {
            isNot = true;
        }
        ExprEqualsNode identNode = new ExprEqualsNode(isNot);
        this.astExprNodeMap.put(node, identNode);
    }

    private void leaveJoinAndExpr(AST node) {
        log.debug(".leaveJoinAndExpr");
        ExprAndNode identNode = new ExprAndNode();
        this.astExprNodeMap.put(node, identNode);
    }

    private void leaveJoinOrExpr(AST node) {
        log.debug(".leaveJoinOrExpr");
        ExprOrNode identNode = new ExprOrNode();
        this.astExprNodeMap.put(node, identNode);
    }

    private void leaveConstant(AST node) {
        log.debug(".leaveConstant");
        ExprConstantNode constantNode = new ExprConstantNode(ASTConstantHelper.parse(node));
        this.astExprNodeMap.put(node, constantNode);
    }

    private void leaveSubstitution(AST node) {
        log.debug(".leaveSubstitution");
        int currentSize = this.substitutionParamNodes.size();
        ExprSubstitutionNode substitutionNode = new ExprSubstitutionNode(currentSize + 1);
        this.substitutionParamNodes.add(substitutionNode);
        this.astExprNodeMap.put(node, substitutionNode);
    }

    private void leaveMath(AST node) {
        MathArithTypeEnum mathArithTypeEnum;
        log.debug(".leaveMath");
        switch (node.getType()) {
            case 204: {
                mathArithTypeEnum = MathArithTypeEnum.DIVIDE;
                break;
            }
            case 188: {
                mathArithTypeEnum = MathArithTypeEnum.MULTIPLY;
                break;
            }
            case 178: {
                mathArithTypeEnum = MathArithTypeEnum.ADD;
                break;
            }
            case 177: {
                mathArithTypeEnum = MathArithTypeEnum.SUBTRACT;
                break;
            }
            case 205: {
                mathArithTypeEnum = MathArithTypeEnum.MODULO;
                break;
            }
            default: {
                throw new IllegalArgumentException("Node type " + node.getType() + " not a recognized math node type");
            }
        }
        ExprMathNode mathNode = new ExprMathNode(mathArithTypeEnum);
        this.astExprNodeMap.put(node, mathNode);
    }

    private void handleMinMax(AST libNode) {
        MinMaxTypeEnum minMaxTypeEnum;
        log.debug(".handleMinMax");
        AST childNode = libNode.getFirstChild();
        if (childNode.getText().equals("min")) {
            minMaxTypeEnum = MinMaxTypeEnum.MIN;
        } else if (childNode.getText().equals("max")) {
            minMaxTypeEnum = MinMaxTypeEnum.MAX;
        } else {
            throw new IllegalArgumentException("Node type " + childNode.getType() + ' ' + childNode.getText() + " not a recognized min max node");
        }
        AST nextNode = childNode.getNextSibling();
        boolean isDistinct = false;
        if (nextNode.getType() == 44) {
            isDistinct = true;
        }
        if (libNode.getNumberOfChildren() > 3 && isDistinct) {
            throw new ASTWalkException("The distinct keyword is not valid in per-row min and max functions with multiple sub-expressions");
        }
        ExprNode minMaxNode = !isDistinct && libNode.getNumberOfChildren() > 2 ? new ExprMinMaxRowNode(minMaxTypeEnum) : new ExprMinMaxAggrNode(isDistinct, minMaxTypeEnum);
        this.astExprNodeMap.put(libNode, minMaxNode);
    }

    private void leaveCoalesce(AST node) {
        log.debug(".leaveCoalesce");
        ExprCoalesceNode coalesceNode = new ExprCoalesceNode();
        this.astExprNodeMap.put(node, coalesceNode);
    }

    private void leaveAggregate(AST node) {
        ExprAggregateNode aggregateNode;
        log.debug(".leaveAggregate");
        boolean isDistinct = false;
        if (node.getFirstChild() != null && node.getFirstChild().getType() == 44) {
            isDistinct = true;
        }
        switch (node.getType()) {
            case 18: {
                aggregateNode = new ExprAvgNode(isDistinct);
                break;
            }
            case 17: {
                aggregateNode = new ExprSumNode(isDistinct);
                break;
            }
            case 25: {
                aggregateNode = new ExprCountNode(isDistinct);
                break;
            }
            case 22: {
                aggregateNode = new ExprMedianNode(isDistinct);
                break;
            }
            case 23: {
                aggregateNode = new ExprStddevNode(isDistinct);
                break;
            }
            case 24: {
                aggregateNode = new ExprAvedevNode(isDistinct);
                break;
            }
            default: {
                throw new IllegalArgumentException("Node type " + node.getType() + " not a recognized aggregate node type");
            }
        }
        this.astExprNodeMap.put(node, aggregateNode);
    }

    private void leaveRelationalOp(AST node) {
        RelationalOpEnum relationalOpEnum;
        log.debug(".leaveRelationalOp");
        switch (node.getType()) {
            case 199: {
                relationalOpEnum = RelationalOpEnum.LT;
                break;
            }
            case 200: {
                relationalOpEnum = RelationalOpEnum.GT;
                break;
            }
            case 201: {
                relationalOpEnum = RelationalOpEnum.LE;
                break;
            }
            case 202: {
                relationalOpEnum = RelationalOpEnum.GE;
                break;
            }
            default: {
                throw new IllegalArgumentException("Node type " + node.getType() + " not a recognized relational op node type");
            }
        }
        ExprRelationalOpNode mathNode = new ExprRelationalOpNode(relationalOpEnum);
        this.astExprNodeMap.put(node, mathNode);
    }

    private void leaveBitWise(AST node) {
        BitWiseOpEnum bitWiseOpEnum;
        log.debug(".leaveBitWise");
        switch (node.getType()) {
            case 194: {
                bitWiseOpEnum = BitWiseOpEnum.BAND;
                break;
            }
            case 195: {
                bitWiseOpEnum = BitWiseOpEnum.BOR;
                break;
            }
            case 196: {
                bitWiseOpEnum = BitWiseOpEnum.BXOR;
                break;
            }
            default: {
                throw new IllegalArgumentException("Node type " + node.getType() + " not a recognized bit wise node type");
            }
        }
        ExprBitWiseNode bwNode = new ExprBitWiseNode(bitWiseOpEnum);
        this.astExprNodeMap.put(node, bwNode);
    }

    private void leaveWhereClause() {
        log.debug(".leaveWhereClause");
        if (this.astExprNodeMap.size() != 1) {
            throw new IllegalStateException("Where clause generated zero or more then one expression nodes");
        }
        this.statementSpec.setFilterRootNode(this.astExprNodeMap.values().iterator().next());
        this.astExprNodeMap.clear();
    }

    private void leaveHavingClause() {
        log.debug(".leaveHavingClause");
        if (this.astExprNodeMap.size() != 1) {
            throw new IllegalStateException("Having clause generated zero or more then one expression nodes");
        }
        this.statementSpec.setHavingExprRootNode(this.astExprNodeMap.values().iterator().next());
        this.astExprNodeMap.clear();
    }

    private void leaveOutputLimit(AST node) throws ASTWalkException {
        log.debug(".leaveOutputLimit");
        OutputLimitSpec spec = ASTOutputLimitHelper.buildSpec(node);
        this.statementSpec.setOutputLimitSpec(spec);
        if (spec.getVariableName() != null) {
            this.statementSpec.setHasVariables(true);
        }
    }

    private void leaveOuterJoin(AST node) {
        OuterJoinType joinType;
        log.debug(".leaveOuterJoin");
        switch (node.getType()) {
            case 108: {
                joinType = OuterJoinType.LEFT;
                break;
            }
            case 109: {
                joinType = OuterJoinType.RIGHT;
                break;
            }
            case 110: {
                joinType = OuterJoinType.FULL;
                break;
            }
            default: {
                throw new IllegalArgumentException("Node type " + node.getType() + " not a recognized outer join node type");
            }
        }
        ExprIdentNode left = (ExprIdentNode)this.astExprNodeMap.get(node.getFirstChild());
        ExprIdentNode right = (ExprIdentNode)this.astExprNodeMap.get(node.getFirstChild().getNextSibling());
        this.astExprNodeMap.remove(node.getFirstChild());
        this.astExprNodeMap.remove(node.getFirstChild().getNextSibling());
        AST child = node.getFirstChild().getNextSibling().getNextSibling();
        ExprIdentNode[] addLeftArr = null;
        ExprIdentNode[] addRightArr = null;
        if (child != null) {
            ArrayList<ExprIdentNode> addLeft = new ArrayList<ExprIdentNode>();
            ArrayList<ExprIdentNode> addRight = new ArrayList<ExprIdentNode>();
            while (child != null) {
                addLeft.add((ExprIdentNode)this.astExprNodeMap.remove(child));
                addRight.add((ExprIdentNode)this.astExprNodeMap.remove(child.getNextSibling()));
                child = child.getNextSibling().getNextSibling();
            }
            addLeftArr = addLeft.toArray(new ExprIdentNode[0]);
            addRightArr = addRight.toArray(new ExprIdentNode[0]);
        }
        OuterJoinDesc outerJoinDesc = new OuterJoinDesc(joinType, left, right, addLeftArr, addRightArr);
        this.statementSpec.getOuterJoinDescList().add(outerJoinDesc);
    }

    private void leaveGroupBy(AST node) {
        log.debug(".leaveGroupBy");
        if (this.astExprNodeMap.size() < 1) {
            throw new IllegalStateException("Group-by clause generated no expression nodes");
        }
        for (AST child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            ExprNode exprNode = this.astExprNodeMap.get(child);
            if (exprNode == null) {
                throw new IllegalStateException("Expression node as a result of group-by child node not found in collection");
            }
            this.statementSpec.getGroupByExpressions().add(exprNode);
        }
        this.astExprNodeMap.clear();
    }

    private void leaveInsertInto(AST node) {
        log.debug(".leaveInsertInto");
        AST child = node.getFirstChild();
        boolean isIStream = true;
        if (child.getType() == 57) {
            isIStream = false;
            child = child.getNextSibling();
        }
        if (child.getType() == 58) {
            child = child.getNextSibling();
        }
        String eventAliasName = child.getText();
        InsertIntoDesc insertIntoDesc = new InsertIntoDesc(isIStream, eventAliasName);
        if ((child = child.getNextSibling()) != null && child.getType() == 125) {
            for (child = child.getFirstChild(); child != null; child = child.getNextSibling()) {
                insertIntoDesc.add(child.getText());
            }
        }
        this.statementSpec.setInsertIntoDesc(insertIntoDesc);
    }

    private void leaveOrderByElement(AST node) throws ASTWalkException {
        log.debug(".leaveOrderByElement");
        if (this.astExprNodeMap.size() > 1 || this.astExprNodeMap.isEmpty()) {
            throw new ASTWalkException("Unexpected AST tree contains zero or more then 1 child element for root");
        }
        ExprNode exprNode = this.astExprNodeMap.values().iterator().next();
        this.astExprNodeMap.clear();
        boolean descending = false;
        if (node.getFirstChild().getNextSibling() != null) {
            descending = node.getFirstChild().getNextSibling().getType() == 56;
        }
        this.statementSpec.getOrderByList().add(new OrderByItem(exprNode, descending));
    }

    private void leaveConcat(AST node) {
        ExprConcatNode concatNode = new ExprConcatNode();
        this.astExprNodeMap.put(node, concatNode);
    }

    private void leaveEvery(AST node) {
        log.debug(".leaveEvery");
        EvalEveryNode everyNode = new EvalEveryNode();
        this.astPatternNodeMap.put(node, everyNode);
    }

    private void leaveFilter(AST node) {
        log.debug(".leaveFilter");
        AST startNode = node.getFirstChild();
        String optionalPatternTagName = null;
        if (startNode.getType() == 80) {
            optionalPatternTagName = startNode.getText();
            startNode = startNode.getNextSibling();
        }
        String eventName = startNode.getText();
        AST currentNode = startNode.getNextSibling();
        List<ExprNode> exprNodes = this.getExprNodes(currentNode);
        FilterSpecRaw rawFilterSpec = new FilterSpecRaw(eventName, exprNodes);
        if (this.isProcessingPattern) {
            EvalFilterNode filterNode = new EvalFilterNode(rawFilterSpec, optionalPatternTagName);
            this.astPatternNodeMap.put(node, filterNode);
        } else {
            this.filterSpec = rawFilterSpec;
            this.astExprNodeMap.clear();
        }
    }

    private void leaveFollowedBy(AST node) {
        log.debug(".leaveFollowedBy");
        EvalFollowedByNode fbNode = new EvalFollowedByNode();
        this.astPatternNodeMap.put(node, fbNode);
    }

    private void leaveAnd(AST node) {
        log.debug(".leaveAnd");
        EvalAndNode andNode = new EvalAndNode();
        this.astPatternNodeMap.put(node, andNode);
    }

    private void leaveOr(AST node) {
        log.debug(".leaveOr");
        EvalOrNode orNode = new EvalOrNode();
        this.astPatternNodeMap.put(node, orNode);
    }

    private void leaveInSet(AST node) {
        log.debug(".leaveInSet");
        ExprInNode inNode = new ExprInNode(node.getType() == 136);
        this.astExprNodeMap.put(node, inNode);
    }

    private void leaveInRange(AST node) {
        log.debug(".leaveInRange");
        AST bracesNode = node.getFirstChild().getNextSibling();
        if (bracesNode.getType() != 191 && bracesNode.getType() != 189) {
            throw new IllegalStateException("Invalid in-range syntax, no braces but type '" + bracesNode.getType() + "'");
        }
        boolean isLowInclude = bracesNode.getType() == 191;
        if ((bracesNode = bracesNode.getNextSibling().getNextSibling().getNextSibling()).getType() != 192 && bracesNode.getType() != 190) {
            throw new IllegalStateException("Invalid in-range syntax, no braces but type '" + bracesNode.getType() + "'");
        }
        boolean isHighInclude = bracesNode.getType() == 192;
        ExprBetweenNode betweenNode = new ExprBetweenNode(isLowInclude, isHighInclude, node.getType() == 146);
        this.astExprNodeMap.put(node, betweenNode);
    }

    private void leaveBetween(AST node) {
        log.debug(".leaveBetween");
        ExprBetweenNode betweenNode = new ExprBetweenNode(true, true, node.getType() == 137);
        this.astExprNodeMap.put(node, betweenNode);
    }

    private void leaveLike(AST node) {
        log.debug(".leaveLike");
        boolean isNot = node.getType() == 138;
        ExprLikeNode likeNode = new ExprLikeNode(isNot);
        this.astExprNodeMap.put(node, likeNode);
    }

    private void leaveRegexp(AST node) {
        log.debug(".leaveRegexp");
        boolean isNot = node.getType() == 139;
        ExprRegexpNode regExpNode = new ExprRegexpNode(isNot);
        this.astExprNodeMap.put(node, regExpNode);
    }

    private void leaveNot(AST node) {
        log.debug(".leaveNot");
        if (this.isProcessingPattern) {
            EvalNotNode notNode = new EvalNotNode();
            this.astPatternNodeMap.put(node, notNode);
        } else {
            ExprNotNode notNode = new ExprNotNode();
            this.astExprNodeMap.put(node, notNode);
        }
    }

    private void leaveGuard(AST node) throws ASTWalkException {
        log.debug(".leaveGuard");
        AST startGuard = node.getFirstChild().getNextSibling();
        String objectNamespace = startGuard.getText();
        String objectName = startGuard.getNextSibling().getText();
        LinkedList<Object> objectParams = new LinkedList<Object>();
        for (AST child = startGuard.getNextSibling().getNextSibling(); child != null; child = child.getNextSibling()) {
            Object object = ASTParameterHelper.makeParameter(child);
            objectParams.add(object);
        }
        PatternGuardSpec guardSpec = new PatternGuardSpec(objectNamespace, objectName, objectParams);
        EvalGuardNode guardNode = new EvalGuardNode(guardSpec);
        this.astPatternNodeMap.put(node, guardNode);
    }

    private void leaveCaseNode(AST node, boolean inCase2) {
        if (log.isDebugEnabled()) {
            log.debug(".leaveCase2Node inCase2=" + inCase2);
        }
        if (this.astExprNodeMap.isEmpty()) {
            throw new ASTWalkException("Unexpected AST tree contains zero child element for case node");
        }
        AST childNode = node.getFirstChild();
        if (this.astExprNodeMap.size() == 1 && childNode.getType() != 30) {
            throw new ASTWalkException("AST tree doesn not contain at least when node for case node");
        }
        ExprCaseNode caseNode = new ExprCaseNode(inCase2);
        this.astExprNodeMap.put(node, caseNode);
    }

    private void leaveObserver(AST node) throws ASTWalkException {
        log.debug(".leaveObserver");
        String objectNamespace = node.getFirstChild().getText();
        String objectName = node.getFirstChild().getNextSibling().getText();
        LinkedList<Object> objectParams = new LinkedList<Object>();
        for (AST child = node.getFirstChild().getNextSibling().getNextSibling(); child != null; child = child.getNextSibling()) {
            Object object = ASTParameterHelper.makeParameter(child);
            objectParams.add(object);
        }
        PatternObserverSpec observerSpec = new PatternObserverSpec(objectNamespace, objectName, objectParams);
        EvalObserverNode observerNode = new EvalObserverNode(observerSpec);
        this.astPatternNodeMap.put(node, observerNode);
    }

    private void leaveSelectClause(AST node) {
        log.debug(".leaveSelectClause");
        int nodeType = node.getFirstChild().getType();
        if (nodeType == 57) {
            this.statementSpec.setSelectStreamDirEnum(SelectClauseStreamSelectorEnum.RSTREAM_ONLY);
        }
        if (nodeType == 58) {
            this.statementSpec.setSelectStreamDirEnum(SelectClauseStreamSelectorEnum.ISTREAM_ONLY);
        }
    }

    private List<ExprNode> getExprNodes(AST currentNode) {
        LinkedList<ExprNode> exprNodes = new LinkedList<ExprNode>();
        while (currentNode != null) {
            ExprNode exprNode = this.astExprNodeMap.get(currentNode);
            if (exprNode == null) {
                throw new IllegalStateException("Expression node for AST node not found for type " + currentNode.getType());
            }
            exprNodes.add(exprNode);
            this.astExprNodeMap.remove(currentNode);
            currentNode = currentNode.getNextSibling();
        }
        return exprNodes;
    }
}

