/*
 * Decompiled with CFR 0.152.
 */
package net.esper.eql.parse;

import antlr.MismatchedCharException;
import antlr.MismatchedTokenException;
import antlr.NoViableAltException;
import antlr.RecognitionException;
import antlr.TokenStreamException;
import antlr.TokenStreamRecognitionException;
import antlr.collections.AST;
import java.io.StringReader;
import net.esper.client.EPException;
import net.esper.eql.generated.EQLBaseWalker;
import net.esper.eql.generated.EQLStatementLexer;
import net.esper.eql.generated.EQLStatementParser;
import net.esper.eql.parse.EPStatementSyntaxException;
import net.esper.eql.parse.ParseRuleSelector;
import net.esper.eql.parse.WalkRuleSelector;
import net.esper.util.DebugFacility;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ParseHelper {
    private static Log log = LogFactory.getLog(ParseHelper.class);

    public static void walk(AST ast, EQLBaseWalker walker, WalkRuleSelector walkRuleSelector, String expression) {
        try {
            if (log.isDebugEnabled()) {
                log.debug(".walk Walking AST using walker " + walker.getClass().getName());
            }
            walkRuleSelector.invokeWalkRule(walker, ast);
            if (log.isDebugEnabled()) {
                log.debug(".walk AST tree after walking");
                DebugFacility.dumpAST(ast);
            }
        }
        catch (RecognitionException e) {
            throw EPStatementSyntaxException.convert(e, expression);
        }
    }

    public static AST parse(String expression, ParseRuleSelector parseRuleSelector) throws EPException {
        if (log.isDebugEnabled()) {
            log.debug(".parse Parsing expr=" + expression);
        }
        EQLStatementLexer lexer2 = new EQLStatementLexer(new StringReader(expression));
        EQLStatementParser parser2 = new EQLStatementParser(lexer2);
        try {
            parseRuleSelector.invokeParseRule(parser2);
        }
        catch (MismatchedTokenException mte) {
            if (mte.token.getText() == null) {
                throw EPStatementSyntaxException.convertEndOfInput(mte, EQLStatementParser._tokenNames[mte.expecting], expression);
            }
            throw EPStatementSyntaxException.convert(mte, expression);
        }
        catch (TokenStreamRecognitionException e) {
            if (e.recog instanceof MismatchedCharException) {
                MismatchedCharException mme = (MismatchedCharException)e.recog;
                if (mme.foundChar == 65535) {
                    char expected = (char)mme.expecting;
                    String wrapped = "'" + Character.toString(expected) + "'";
                    if (expected == '\'') {
                        wrapped = "a singe quote \"'\"";
                    }
                    throw EPStatementSyntaxException.convertEndOfInput(mme, wrapped, expression);
                }
            }
            throw EPStatementSyntaxException.convert(e, expression);
        }
        catch (TokenStreamException e) {
            throw EPStatementSyntaxException.convert(e, expression);
        }
        catch (NoViableAltException e) {
            if (e.token.getText() == null) {
                throw EPStatementSyntaxException.convertEndOfInput(e, expression);
            }
            throw EPStatementSyntaxException.convert(e, expression);
        }
        catch (RecognitionException e) {
            throw EPStatementSyntaxException.convert(e, expression);
        }
        AST ast = parser2.getAST();
        if (log.isDebugEnabled()) {
            log.debug(".parse Dumping AST...");
            DebugFacility.dumpAST(ast);
        }
        return ast;
    }
}

