/*
 * Decompiled with CFR 0.152.
 */
package net.esper.eql.spec;

import java.util.List;
import net.esper.eql.core.MethodResolutionService;
import net.esper.eql.core.StreamTypeServiceImpl;
import net.esper.eql.expression.ExprNode;
import net.esper.eql.expression.ExprValidationException;
import net.esper.eql.named.NamedWindowService;
import net.esper.eql.spec.FilterSpecRaw;
import net.esper.eql.spec.FilterStreamSpecCompiled;
import net.esper.eql.spec.NamedWindowConsumerStreamSpec;
import net.esper.eql.spec.StreamSpecBase;
import net.esper.eql.spec.StreamSpecCompiled;
import net.esper.eql.spec.StreamSpecRaw;
import net.esper.eql.spec.ViewSpec;
import net.esper.eql.variable.VariableService;
import net.esper.event.EventAdapterException;
import net.esper.event.EventAdapterService;
import net.esper.event.EventType;
import net.esper.filter.FilterSpecCompiled;
import net.esper.filter.FilterSpecCompiler;
import net.esper.pattern.PatternObjectResolutionService;
import net.esper.schedule.TimeProvider;
import net.esper.util.MetaDefItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterStreamSpecRaw
extends StreamSpecBase
implements StreamSpecRaw,
MetaDefItem {
    private FilterSpecRaw rawFilterSpec;

    public FilterStreamSpecRaw(FilterSpecRaw rawFilterSpec, List<ViewSpec> viewSpecs, String optionalStreamName) {
        super(optionalStreamName, viewSpecs);
        this.rawFilterSpec = rawFilterSpec;
    }

    public FilterStreamSpecRaw() {
    }

    public FilterSpecRaw getRawFilterSpec() {
        return this.rawFilterSpec;
    }

    @Override
    public StreamSpecCompiled compile(EventAdapterService eventAdapterService, MethodResolutionService methodResolutionService, PatternObjectResolutionService patternObjectResolutionService, TimeProvider timeProvider, NamedWindowService namedWindowService, VariableService variableService) throws ExprValidationException {
        String eventName = this.rawFilterSpec.getEventTypeAlias();
        if (namedWindowService.isNamedWindow(eventName)) {
            EventType namedWindowType = namedWindowService.getProcessor(eventName).getTailView().getEventType();
            StreamTypeServiceImpl streamTypeService = new StreamTypeServiceImpl(new EventType[]{namedWindowType}, new String[]{"s0"});
            List<ExprNode> validatedNodes = FilterSpecCompiler.validateDisallowSubquery(this.rawFilterSpec.getFilterExpressions(), streamTypeService, methodResolutionService, timeProvider, variableService);
            return new NamedWindowConsumerStreamSpec(eventName, this.getOptionalStreamName(), this.getViewSpecs(), validatedNodes);
        }
        EventType eventType = FilterStreamSpecRaw.resolveType(eventName, eventAdapterService);
        StreamTypeServiceImpl streamTypeService = new StreamTypeServiceImpl(new EventType[]{eventType}, new String[]{"s0"});
        FilterSpecCompiled spec = FilterSpecCompiler.makeFilterSpec(eventType, this.rawFilterSpec.getFilterExpressions(), null, streamTypeService, methodResolutionService, timeProvider, variableService);
        return new FilterStreamSpecCompiled(spec, this.getViewSpecs(), this.getOptionalStreamName());
    }

    protected static EventType resolveType(String eventName, EventAdapterService eventAdapterService) throws ExprValidationException {
        EventType eventType = eventAdapterService.getExistsTypeByAlias(eventName);
        if (eventType == null) {
            try {
                eventType = eventAdapterService.addBeanType(eventName, eventName, true);
            }
            catch (EventAdapterException ex) {
                throw new ExprValidationException("Failed to resolve event type: " + ex.getMessage());
            }
        }
        return eventType;
    }
}

