/*
 * Decompiled with CFR 0.152.
 */
package net.esper.eql.spec;

import java.util.List;
import net.esper.util.MetaDefItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ObjectSpec
implements MetaDefItem {
    private final String objectNamespace;
    private final String objectName;
    private final List<Object> objectParameters;

    public ObjectSpec(String namespace, String objectName, List<Object> objectParameters) {
        this.objectNamespace = namespace;
        this.objectName = objectName;
        this.objectParameters = objectParameters;
    }

    public String getObjectNamespace() {
        return this.objectNamespace;
    }

    public final String getObjectName() {
        return this.objectName;
    }

    public final List<Object> getObjectParameters() {
        return this.objectParameters;
    }

    public final boolean equals(Object otherObject) {
        if (otherObject == this) {
            return true;
        }
        if (otherObject == null) {
            return false;
        }
        if (this.getClass() != otherObject.getClass()) {
            return false;
        }
        ObjectSpec other = (ObjectSpec)otherObject;
        if (!this.objectName.equals(other.objectName)) {
            return false;
        }
        if (this.objectParameters.size() != other.objectParameters.size()) {
            return false;
        }
        int index = 0;
        for (Object thisParam : this.objectParameters) {
            Object otherParam = other.objectParameters.get(index);
            ++index;
            if (thisParam.equals(otherParam)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = this.objectNamespace.hashCode();
        result = 31 * result + this.objectName.hashCode();
        return result;
    }

    public final String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("objectName=");
        buffer.append(this.objectName);
        buffer.append("  objectParameters=(");
        int delimiter = 32;
        if (this.objectParameters != null) {
            for (Object param : this.objectParameters) {
                buffer.append((char)delimiter);
                buffer.append(param.toString());
                delimiter = 44;
            }
        }
        buffer.append(')');
        return buffer.toString();
    }
}

