/*
 * Decompiled with CFR 0.152.
 */
package net.esper.eql.spec;

import java.util.LinkedHashMap;
import java.util.List;
import net.esper.eql.core.MethodResolutionService;
import net.esper.eql.core.StreamTypeServiceImpl;
import net.esper.eql.expression.ExprNode;
import net.esper.eql.expression.ExprValidationException;
import net.esper.eql.named.NamedWindowService;
import net.esper.eql.spec.FilterStreamSpecRaw;
import net.esper.eql.spec.PatternStreamSpecCompiled;
import net.esper.eql.spec.StreamSpecBase;
import net.esper.eql.spec.StreamSpecCompiled;
import net.esper.eql.spec.StreamSpecRaw;
import net.esper.eql.spec.ViewSpec;
import net.esper.eql.variable.VariableService;
import net.esper.event.EventAdapterService;
import net.esper.event.EventType;
import net.esper.filter.FilterSpecCompiled;
import net.esper.filter.FilterSpecCompiler;
import net.esper.pattern.EvalFilterNode;
import net.esper.pattern.EvalGuardNode;
import net.esper.pattern.EvalNode;
import net.esper.pattern.EvalNodeAnalysisResult;
import net.esper.pattern.EvalObserverNode;
import net.esper.pattern.PatternObjectException;
import net.esper.pattern.PatternObjectResolutionService;
import net.esper.pattern.guard.GuardFactory;
import net.esper.pattern.guard.GuardParameterException;
import net.esper.pattern.observer.ObserverFactory;
import net.esper.pattern.observer.ObserverParameterException;
import net.esper.schedule.TimeProvider;
import net.esper.util.UuidGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatternStreamSpecRaw
extends StreamSpecBase
implements StreamSpecRaw {
    private final EvalNode evalNode;

    public PatternStreamSpecRaw(EvalNode evalNode, List<ViewSpec> viewSpecs, String optionalStreamName) {
        super(optionalStreamName, viewSpecs);
        this.evalNode = evalNode;
    }

    public EvalNode getEvalNode() {
        return this.evalNode;
    }

    @Override
    public StreamSpecCompiled compile(EventAdapterService eventAdapterService, MethodResolutionService methodResolutionService, PatternObjectResolutionService patternObjectResolutionService, TimeProvider timeProvider, NamedWindowService namedWindowService, VariableService variableService) throws ExprValidationException {
        EvalNodeAnalysisResult evalNodeAnalysisResult = EvalNode.recursiveAnalyzeChildNodes(this.evalNode);
        try {
            for (EvalGuardNode guardNode : evalNodeAnalysisResult.getGuardNodes()) {
                GuardFactory guardFactory = patternObjectResolutionService.create(guardNode.getPatternGuardSpec());
                guardFactory.setGuardParameters(guardNode.getPatternGuardSpec().getObjectParameters());
                guardNode.setGuardFactory(guardFactory);
            }
            for (EvalObserverNode observerNode : evalNodeAnalysisResult.getObserverNodes()) {
                ObserverFactory observerFactory = patternObjectResolutionService.create(observerNode.getPatternObserverSpec());
                observerFactory.setObserverParameters(observerNode.getPatternObserverSpec().getObjectParameters());
                observerNode.setObserverFactory(observerFactory);
            }
        }
        catch (ObserverParameterException e) {
            throw new ExprValidationException("Invalid parameter for pattern observer: " + e.getMessage(), e);
        }
        catch (GuardParameterException e) {
            throw new ExprValidationException("Invalid parameter for pattern guard: " + e.getMessage(), e);
        }
        catch (PatternObjectException e) {
            throw new ExprValidationException("Failed to resolve pattern object: " + e.getMessage(), e);
        }
        LinkedHashMap<String, EventType> taggedEventTypes = new LinkedHashMap<String, EventType>();
        for (EvalFilterNode filterNode : evalNodeAnalysisResult.getFilterNodes()) {
            String selfStreamName;
            String eventName = filterNode.getRawFilterSpec().getEventTypeAlias();
            EventType eventType = FilterStreamSpecRaw.resolveType(eventName, eventAdapterService);
            String optionalTag = filterNode.getEventAsName();
            if (optionalTag != null) {
                EventType existingType = taggedEventTypes.get(optionalTag);
                if (existingType != null && existingType != eventType) {
                    throw new IllegalArgumentException("Tag '" + optionalTag + "' for event '" + eventName + "' has already been declared for events of type " + existingType.getUnderlyingType().getName());
                }
                taggedEventTypes.put(optionalTag, eventType);
            }
            if ((selfStreamName = optionalTag) == null) {
                selfStreamName = "s_" + UuidGenerator.generate(filterNode);
            }
            LinkedHashMap<String, EventType> filterTypes = new LinkedHashMap<String, EventType>();
            filterTypes.put(selfStreamName, eventType);
            filterTypes.putAll(taggedEventTypes);
            StreamTypeServiceImpl streamTypeService = new StreamTypeServiceImpl(filterTypes, true, false);
            List<ExprNode> exprNodes = filterNode.getRawFilterSpec().getFilterExpressions();
            FilterSpecCompiled spec = FilterSpecCompiler.makeFilterSpec(eventType, exprNodes, taggedEventTypes, streamTypeService, methodResolutionService, timeProvider, variableService);
            filterNode.setFilterSpec(spec);
        }
        return new PatternStreamSpecCompiled(this.evalNode, taggedEventTypes, this.getViewSpecs(), this.getOptionalStreamName());
    }
}

