/*
 * Decompiled with CFR 0.152.
 */
package net.esper.eql.spec;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.esper.client.ConfigurationException;
import net.esper.client.ConfigurationPlugInPatternObject;
import net.esper.client.ConfigurationPlugInView;
import net.esper.collection.Pair;
import net.esper.eql.spec.PluggableObjectType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluggableObjectCollection {
    private Map<String, Map<String, Pair<Class, PluggableObjectType>>> pluggables = new HashMap<String, Map<String, Pair<Class, PluggableObjectType>>>();

    public void addViews(List<ConfigurationPlugInView> configurationPlugInViews) throws ConfigurationException {
        this.initViews(configurationPlugInViews);
    }

    public void addPatternObjects(List<ConfigurationPlugInPatternObject> configPattern) throws ConfigurationException {
        this.initPatterns(configPattern);
    }

    public void addObjects(PluggableObjectCollection other) {
        for (Map.Entry<String, Map<String, Pair<Class, PluggableObjectType>>> entry : other.getPluggables().entrySet()) {
            Map<String, Pair<Class, PluggableObjectType>> namespaceMap = this.pluggables.get(entry.getKey());
            if (namespaceMap == null) {
                namespaceMap = new HashMap<String, Pair<Class, PluggableObjectType>>();
                this.pluggables.put(entry.getKey(), namespaceMap);
            }
            for (String name : entry.getValue().keySet()) {
                if (!namespaceMap.containsKey(name)) continue;
                throw new ConfigurationException("Duplicate object detected in namespace '" + entry.getKey() + "' by name '" + name + "'");
            }
            namespaceMap.putAll(entry.getValue());
        }
    }

    public void addObject(String namespace, String name, Class clazz, PluggableObjectType type) {
        Map<String, Pair<Class, PluggableObjectType>> namespaceMap = this.pluggables.get(namespace);
        if (namespaceMap == null) {
            namespaceMap = new HashMap<String, Pair<Class, PluggableObjectType>>();
            this.pluggables.put(namespace, namespaceMap);
        }
        namespaceMap.put(name, new Pair<Class, PluggableObjectType>(clazz, type));
    }

    public Map<String, Map<String, Pair<Class, PluggableObjectType>>> getPluggables() {
        return this.pluggables;
    }

    private void initViews(List<ConfigurationPlugInView> configurationPlugInViews) {
        if (configurationPlugInViews == null) {
            return;
        }
        for (ConfigurationPlugInView entry : configurationPlugInViews) {
            Class<?> clazz;
            if (entry.getFactoryClassName() == null) {
                throw new ConfigurationException("Factory class name has not been supplied for object '" + entry.getName() + "'");
            }
            if (entry.getNamespace() == null) {
                throw new ConfigurationException("Namespace name has not been supplied for object '" + entry.getName() + "'");
            }
            if (entry.getName() == null) {
                throw new ConfigurationException("Name has not been supplied for object in namespace '" + entry.getNamespace() + "'");
            }
            try {
                clazz = Class.forName(entry.getFactoryClassName());
            }
            catch (ClassNotFoundException ex) {
                throw new ConfigurationException("View factory class " + entry.getFactoryClassName() + " could not be loaded");
            }
            Map<String, Pair<Class, PluggableObjectType>> namespaceMap = this.pluggables.get(entry.getNamespace());
            if (namespaceMap == null) {
                namespaceMap = new HashMap<String, Pair<Class, PluggableObjectType>>();
                this.pluggables.put(entry.getNamespace(), namespaceMap);
            }
            namespaceMap.put(entry.getName(), new Pair(clazz, PluggableObjectType.VIEW));
        }
    }

    private void initPatterns(List<ConfigurationPlugInPatternObject> configEntries) throws ConfigurationException {
        if (configEntries == null) {
            return;
        }
        for (ConfigurationPlugInPatternObject entry : configEntries) {
            PluggableObjectType typeEnum;
            Class<?> clazz;
            if (entry.getFactoryClassName() == null) {
                throw new ConfigurationException("Factory class name has not been supplied for object '" + entry.getName() + "'");
            }
            if (entry.getNamespace() == null) {
                throw new ConfigurationException("Namespace name has not been supplied for object '" + entry.getName() + "'");
            }
            if (entry.getName() == null) {
                throw new ConfigurationException("Name has not been supplied for object in namespace '" + entry.getNamespace() + "'");
            }
            if (entry.getPatternObjectType() == null) {
                throw new ConfigurationException("Pattern object type has not been supplied for object '" + entry.getName() + "'");
            }
            try {
                clazz = Class.forName(entry.getFactoryClassName());
            }
            catch (ClassNotFoundException ex) {
                throw new ConfigurationException("Pattern object factory class " + entry.getFactoryClassName() + " could not be loaded");
            }
            Map<String, Pair<Class, PluggableObjectType>> namespaceMap = this.pluggables.get(entry.getNamespace());
            if (namespaceMap == null) {
                namespaceMap = new HashMap<String, Pair<Class, PluggableObjectType>>();
                this.pluggables.put(entry.getNamespace(), namespaceMap);
            }
            if (entry.getPatternObjectType() == ConfigurationPlugInPatternObject.PatternObjectType.GUARD) {
                typeEnum = PluggableObjectType.PATTERN_GUARD;
            } else if (entry.getPatternObjectType() == ConfigurationPlugInPatternObject.PatternObjectType.OBSERVER) {
                typeEnum = PluggableObjectType.PATTERN_OBSERVER;
            } else {
                throw new IllegalArgumentException("Pattern object type '" + (Object)((Object)entry.getPatternObjectType()) + "' not known");
            }
            namespaceMap.put(entry.getName(), new Pair(clazz, typeEnum));
        }
    }
}

