/*
 * Decompiled with CFR 0.152.
 */
package net.esper.eql.spec;

import java.util.ArrayList;
import java.util.List;
import net.esper.client.EPException;
import net.esper.client.soda.ArithmaticExpression;
import net.esper.client.soda.ArrayExpression;
import net.esper.client.soda.AvedevProjectionExpression;
import net.esper.client.soda.AvgProjectionExpression;
import net.esper.client.soda.BetweenExpression;
import net.esper.client.soda.BitwiseOpExpression;
import net.esper.client.soda.CaseSwitchExpression;
import net.esper.client.soda.CaseWhenThenExpression;
import net.esper.client.soda.CastExpression;
import net.esper.client.soda.CoalesceExpression;
import net.esper.client.soda.ConcatExpression;
import net.esper.client.soda.Conjunction;
import net.esper.client.soda.ConstantExpression;
import net.esper.client.soda.CountProjectionExpression;
import net.esper.client.soda.CountStarProjectionExpression;
import net.esper.client.soda.CreateVariableClause;
import net.esper.client.soda.CreateWindowClause;
import net.esper.client.soda.CurrentTimestampExpression;
import net.esper.client.soda.Disjunction;
import net.esper.client.soda.EPStatementObjectModel;
import net.esper.client.soda.Expression;
import net.esper.client.soda.Filter;
import net.esper.client.soda.FilterStream;
import net.esper.client.soda.FromClause;
import net.esper.client.soda.GroupByClause;
import net.esper.client.soda.InExpression;
import net.esper.client.soda.InsertIntoClause;
import net.esper.client.soda.InstanceOfExpression;
import net.esper.client.soda.LikeExpression;
import net.esper.client.soda.MaxProjectionExpression;
import net.esper.client.soda.MaxRowExpression;
import net.esper.client.soda.MedianProjectionExpression;
import net.esper.client.soda.MethodInvocationStream;
import net.esper.client.soda.MinProjectionExpression;
import net.esper.client.soda.MinRowExpression;
import net.esper.client.soda.NotExpression;
import net.esper.client.soda.OnClause;
import net.esper.client.soda.OnDeleteClause;
import net.esper.client.soda.OnSelectClause;
import net.esper.client.soda.OnSetClause;
import net.esper.client.soda.OrderByClause;
import net.esper.client.soda.OrderByElement;
import net.esper.client.soda.OuterJoinQualifier;
import net.esper.client.soda.OutputLimitClause;
import net.esper.client.soda.OutputLimitSelector;
import net.esper.client.soda.OutputLimitUnit;
import net.esper.client.soda.PatternAndExpr;
import net.esper.client.soda.PatternEveryExpr;
import net.esper.client.soda.PatternExpr;
import net.esper.client.soda.PatternFilterExpr;
import net.esper.client.soda.PatternFollowedByExpr;
import net.esper.client.soda.PatternGuardExpr;
import net.esper.client.soda.PatternNotExpr;
import net.esper.client.soda.PatternObserverExpr;
import net.esper.client.soda.PatternOrExpr;
import net.esper.client.soda.PatternStream;
import net.esper.client.soda.PlugInProjectionExpression;
import net.esper.client.soda.PreviousExpression;
import net.esper.client.soda.PriorExpression;
import net.esper.client.soda.ProjectedStream;
import net.esper.client.soda.PropertyExistsExpression;
import net.esper.client.soda.PropertyValueExpression;
import net.esper.client.soda.RegExpExpression;
import net.esper.client.soda.RelationalOpExpression;
import net.esper.client.soda.SQLStream;
import net.esper.client.soda.SelectClause;
import net.esper.client.soda.SelectClauseElement;
import net.esper.client.soda.SelectClauseStreamWildcard;
import net.esper.client.soda.StaticMethodExpression;
import net.esper.client.soda.StddevProjectionExpression;
import net.esper.client.soda.Stream;
import net.esper.client.soda.StreamSelector;
import net.esper.client.soda.SubqueryExistsExpression;
import net.esper.client.soda.SubqueryExpression;
import net.esper.client.soda.SubqueryInExpression;
import net.esper.client.soda.SumProjectionExpression;
import net.esper.client.soda.View;
import net.esper.collection.Pair;
import net.esper.eql.agg.AggregationSupport;
import net.esper.eql.core.EngineImportException;
import net.esper.eql.core.EngineImportService;
import net.esper.eql.core.EngineImportUndefinedException;
import net.esper.eql.expression.ExprAndNode;
import net.esper.eql.expression.ExprArrayNode;
import net.esper.eql.expression.ExprAvedevNode;
import net.esper.eql.expression.ExprAvgNode;
import net.esper.eql.expression.ExprBetweenNode;
import net.esper.eql.expression.ExprBitWiseNode;
import net.esper.eql.expression.ExprCaseNode;
import net.esper.eql.expression.ExprCastNode;
import net.esper.eql.expression.ExprCoalesceNode;
import net.esper.eql.expression.ExprConcatNode;
import net.esper.eql.expression.ExprConstantNode;
import net.esper.eql.expression.ExprCountNode;
import net.esper.eql.expression.ExprEqualsNode;
import net.esper.eql.expression.ExprIdentNode;
import net.esper.eql.expression.ExprInNode;
import net.esper.eql.expression.ExprInstanceofNode;
import net.esper.eql.expression.ExprLikeNode;
import net.esper.eql.expression.ExprMathNode;
import net.esper.eql.expression.ExprMedianNode;
import net.esper.eql.expression.ExprMinMaxAggrNode;
import net.esper.eql.expression.ExprMinMaxRowNode;
import net.esper.eql.expression.ExprNode;
import net.esper.eql.expression.ExprNotNode;
import net.esper.eql.expression.ExprOrNode;
import net.esper.eql.expression.ExprPlugInAggFunctionNode;
import net.esper.eql.expression.ExprPreviousNode;
import net.esper.eql.expression.ExprPriorNode;
import net.esper.eql.expression.ExprPropertyExistsNode;
import net.esper.eql.expression.ExprRegexpNode;
import net.esper.eql.expression.ExprRelationalOpNode;
import net.esper.eql.expression.ExprStaticMethodNode;
import net.esper.eql.expression.ExprStddevNode;
import net.esper.eql.expression.ExprSubselectExistsNode;
import net.esper.eql.expression.ExprSubselectInNode;
import net.esper.eql.expression.ExprSubselectRowNode;
import net.esper.eql.expression.ExprSubstitutionNode;
import net.esper.eql.expression.ExprSumNode;
import net.esper.eql.expression.ExprTimestampNode;
import net.esper.eql.expression.ExprVariableNode;
import net.esper.eql.spec.CreateVariableDesc;
import net.esper.eql.spec.CreateWindowDesc;
import net.esper.eql.spec.DBStatementStreamSpec;
import net.esper.eql.spec.FilterSpecRaw;
import net.esper.eql.spec.FilterStreamSpecRaw;
import net.esper.eql.spec.InsertIntoDesc;
import net.esper.eql.spec.MethodStreamSpec;
import net.esper.eql.spec.OnTriggerDesc;
import net.esper.eql.spec.OnTriggerSetAssignment;
import net.esper.eql.spec.OnTriggerSetDesc;
import net.esper.eql.spec.OnTriggerType;
import net.esper.eql.spec.OnTriggerWindowDesc;
import net.esper.eql.spec.OrderByItem;
import net.esper.eql.spec.OuterJoinDesc;
import net.esper.eql.spec.OutputLimitLimitType;
import net.esper.eql.spec.OutputLimitRateType;
import net.esper.eql.spec.OutputLimitSpec;
import net.esper.eql.spec.PatternGuardSpec;
import net.esper.eql.spec.PatternObserverSpec;
import net.esper.eql.spec.PatternStreamSpecRaw;
import net.esper.eql.spec.SelectClauseSpec;
import net.esper.eql.spec.SelectClauseStreamSelectorEnum;
import net.esper.eql.spec.SelectExprElementRawSpec;
import net.esper.eql.spec.SelectExprElementStreamRawSpec;
import net.esper.eql.spec.StatementSpecMapContext;
import net.esper.eql.spec.StatementSpecRaw;
import net.esper.eql.spec.StatementSpecUnMapContext;
import net.esper.eql.spec.StatementSpecUnMapResult;
import net.esper.eql.spec.StreamSpecBase;
import net.esper.eql.spec.StreamSpecRaw;
import net.esper.eql.spec.SubstitutionParameterExpression;
import net.esper.eql.spec.ViewSpec;
import net.esper.eql.variable.VariableService;
import net.esper.pattern.EvalAndNode;
import net.esper.pattern.EvalEveryNode;
import net.esper.pattern.EvalFilterNode;
import net.esper.pattern.EvalFollowedByNode;
import net.esper.pattern.EvalGuardNode;
import net.esper.pattern.EvalNode;
import net.esper.pattern.EvalNotNode;
import net.esper.pattern.EvalObserverNode;
import net.esper.pattern.EvalOrNode;
import net.esper.type.MathArithTypeEnum;
import net.esper.type.MinMaxTypeEnum;
import net.esper.type.RelationalOpEnum;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatementSpecMapper {
    public static StatementSpecRaw map(EPStatementObjectModel sodaStatement, EngineImportService engineImportService, VariableService variableService) {
        StatementSpecMapContext mapContext = new StatementSpecMapContext(engineImportService, variableService);
        StatementSpecRaw raw = StatementSpecMapper.map(sodaStatement, mapContext);
        if (mapContext.isHasVariables()) {
            raw.setHasVariables(true);
        }
        return raw;
    }

    private static StatementSpecRaw map(EPStatementObjectModel sodaStatement, StatementSpecMapContext mapContext) {
        StatementSpecRaw raw = new StatementSpecRaw();
        StatementSpecMapper.mapCreateWindow(sodaStatement.getCreateWindow(), raw);
        StatementSpecMapper.mapCreateVariable(sodaStatement.getCreateVariable(), raw, mapContext);
        StatementSpecMapper.mapOnTrigger(sodaStatement.getOnExpr(), raw, mapContext);
        StatementSpecMapper.mapInsertInto(sodaStatement.getInsertInto(), raw);
        StatementSpecMapper.mapSelect(sodaStatement.getSelectClause(), raw, mapContext);
        StatementSpecMapper.mapFrom(sodaStatement.getFromClause(), raw, mapContext);
        StatementSpecMapper.mapWhere(sodaStatement.getWhereClause(), raw, mapContext);
        StatementSpecMapper.mapGroupBy(sodaStatement.getGroupByClause(), raw, mapContext);
        StatementSpecMapper.mapHaving(sodaStatement.getHavingClause(), raw, mapContext);
        StatementSpecMapper.mapOutputLimit(sodaStatement.getOutputLimitClause(), raw, mapContext);
        StatementSpecMapper.mapOrderBy(sodaStatement.getOrderByClause(), raw, mapContext);
        return raw;
    }

    public static StatementSpecUnMapResult unmap(StatementSpecRaw statementSpec) {
        StatementSpecUnMapContext unmapContext = new StatementSpecUnMapContext();
        EPStatementObjectModel model = new EPStatementObjectModel();
        StatementSpecMapper.unmapCreateWindow(statementSpec.getCreateWindowDesc(), model);
        StatementSpecMapper.unmapCreateVariable(statementSpec.getCreateVariableDesc(), model, unmapContext);
        StatementSpecMapper.unmapOnClause(statementSpec.getOnTriggerDesc(), model, unmapContext);
        StatementSpecMapper.unmapInsertInto(statementSpec.getInsertIntoDesc(), model);
        StatementSpecMapper.unmapSelect(statementSpec.getSelectClauseSpec(), statementSpec.getSelectStreamSelectorEnum(), model, unmapContext);
        StatementSpecMapper.unmapFrom(statementSpec.getStreamSpecs(), statementSpec.getOuterJoinDescList(), model, unmapContext);
        StatementSpecMapper.unmapWhere(statementSpec.getFilterRootNode(), model, unmapContext);
        StatementSpecMapper.unmapGroupBy(statementSpec.getGroupByExpressions(), model, unmapContext);
        StatementSpecMapper.unmapHaving(statementSpec.getHavingExprRootNode(), model, unmapContext);
        StatementSpecMapper.unmapOutputLimit(statementSpec.getOutputLimitSpec(), model);
        StatementSpecMapper.unmapOrderBy(statementSpec.getOrderByList(), model, unmapContext);
        return new StatementSpecUnMapResult(model, unmapContext.getIndexedParams());
    }

    private static void unmapOnClause(OnTriggerDesc onTriggerDesc, EPStatementObjectModel model, StatementSpecUnMapContext unmapContext) {
        OnTriggerWindowDesc window;
        if (onTriggerDesc == null) {
            return;
        }
        if (onTriggerDesc.getOnTriggerType() == OnTriggerType.ON_DELETE) {
            window = (OnTriggerWindowDesc)onTriggerDesc;
            model.setOnExpr(new OnDeleteClause(window.getWindowName(), window.getOptionalAsName()));
        }
        if (onTriggerDesc.getOnTriggerType() == OnTriggerType.ON_SELECT) {
            window = (OnTriggerWindowDesc)onTriggerDesc;
            model.setOnExpr(new OnSelectClause(window.getWindowName(), window.getOptionalAsName()));
        }
        if (onTriggerDesc.getOnTriggerType() == OnTriggerType.ON_SET) {
            OnTriggerSetDesc trigger = (OnTriggerSetDesc)onTriggerDesc;
            OnSetClause clause = new OnSetClause();
            for (OnTriggerSetAssignment assignment : trigger.getAssignments()) {
                Expression expr = StatementSpecMapper.unmapExpressionDeep(assignment.getExpression(), unmapContext);
                clause.addAssignment(assignment.getVariableName(), expr);
            }
            model.setOnExpr(clause);
        }
    }

    private static void unmapCreateWindow(CreateWindowDesc createWindowDesc, EPStatementObjectModel model) {
        if (createWindowDesc == null) {
            return;
        }
        model.setCreateWindow(new CreateWindowClause(createWindowDesc.getWindowName(), StatementSpecMapper.unmapViews(createWindowDesc.getViewSpecs())));
    }

    private static void unmapCreateVariable(CreateVariableDesc createVariableDesc, EPStatementObjectModel model, StatementSpecUnMapContext unmapContext) {
        if (createVariableDesc == null) {
            return;
        }
        Expression assignment = null;
        if (createVariableDesc.getAssignment() != null) {
            assignment = StatementSpecMapper.unmapExpressionDeep(createVariableDesc.getAssignment(), unmapContext);
        }
        model.setCreateVariable(new CreateVariableClause(createVariableDesc.getVariableType(), createVariableDesc.getVariableName(), assignment));
    }

    private static void unmapOrderBy(List<OrderByItem> orderByList, EPStatementObjectModel model, StatementSpecUnMapContext unmapContext) {
        if (orderByList == null || orderByList.size() == 0) {
            return;
        }
        OrderByClause clause = new OrderByClause();
        for (OrderByItem item : orderByList) {
            Expression expr = StatementSpecMapper.unmapExpressionDeep(item.getExprNode(), unmapContext);
            clause.add(expr, item.isDescending());
        }
        model.setOrderByClause(clause);
    }

    private static void unmapOutputLimit(OutputLimitSpec outputLimitSpec, EPStatementObjectModel model) {
        if (outputLimitSpec == null) {
            return;
        }
        OutputLimitSelector selector = OutputLimitSelector.ALL;
        if (outputLimitSpec.getDisplayLimit() == OutputLimitLimitType.FIRST) {
            selector = OutputLimitSelector.FIRST;
        }
        if (outputLimitSpec.getDisplayLimit() == OutputLimitLimitType.LAST) {
            selector = OutputLimitSelector.LAST;
        }
        if (outputLimitSpec.getDisplayLimit() == OutputLimitLimitType.SNAPSHOT) {
            selector = OutputLimitSelector.SNAPSHOT;
        }
        OutputLimitUnit unit = OutputLimitUnit.EVENTS;
        if (outputLimitSpec.getRateType() == OutputLimitRateType.TIME_MIN) {
            unit = OutputLimitUnit.MINUTES;
        }
        if (outputLimitSpec.getRateType() == OutputLimitRateType.TIME_SEC) {
            unit = OutputLimitUnit.SECONDS;
        }
        OutputLimitClause clause = new OutputLimitClause(selector, outputLimitSpec.getRate(), outputLimitSpec.getVariableName(), unit);
        model.setOutputLimitClause(clause);
    }

    private static void mapOrderBy(OrderByClause orderByClause, StatementSpecRaw raw, StatementSpecMapContext mapContext) {
        if (orderByClause == null) {
            return;
        }
        for (OrderByElement element : orderByClause.getOrderByExpressions()) {
            ExprNode orderExpr = StatementSpecMapper.mapExpressionDeep(element.getExpression(), mapContext);
            OrderByItem item = new OrderByItem(orderExpr, element.isDescending());
            raw.getOrderByList().add(item);
        }
    }

    private static void mapOutputLimit(OutputLimitClause outputLimitClause, StatementSpecRaw raw, StatementSpecMapContext mapContext) {
        if (outputLimitClause == null) {
            return;
        }
        OutputLimitLimitType displayLimit = OutputLimitLimitType.valueOf(outputLimitClause.getSelector().toString().toUpperCase());
        OutputLimitRateType rateType = OutputLimitRateType.TIME_SEC;
        if (outputLimitClause.getUnit() == OutputLimitUnit.EVENTS) {
            rateType = OutputLimitRateType.EVENTS;
        } else if (outputLimitClause.getUnit() == OutputLimitUnit.MINUTES) {
            rateType = OutputLimitRateType.TIME_MIN;
        } else if (outputLimitClause.getUnit() == OutputLimitUnit.SECONDS) {
            rateType = OutputLimitRateType.TIME_SEC;
        }
        Double frequency = outputLimitClause.getFrequency();
        String frequencyVariable = outputLimitClause.getFrequencyVariable();
        if (frequencyVariable != null) {
            mapContext.setHasVariables(true);
        }
        OutputLimitSpec spec = new OutputLimitSpec(frequency, frequencyVariable, rateType, displayLimit);
        raw.setOutputLimitSpec(spec);
    }

    private static void mapOnTrigger(OnClause onExpr, StatementSpecRaw raw, StatementSpecMapContext mapContext) {
        if (onExpr == null) {
            return;
        }
        if (onExpr instanceof OnDeleteClause) {
            OnDeleteClause onDeleteClause = (OnDeleteClause)onExpr;
            raw.setOnTriggerDesc(new OnTriggerWindowDesc(onDeleteClause.getWindowName(), onDeleteClause.getOptionalAsName(), true));
        } else if (onExpr instanceof OnSelectClause) {
            OnSelectClause onSelectClause = (OnSelectClause)onExpr;
            raw.setOnTriggerDesc(new OnTriggerWindowDesc(onSelectClause.getWindowName(), onSelectClause.getOptionalAsName(), true));
        } else if (onExpr instanceof OnSetClause) {
            OnSetClause setClause = (OnSetClause)onExpr;
            OnTriggerSetDesc desc = new OnTriggerSetDesc();
            mapContext.setHasVariables(true);
            for (Pair<String, Expression> pair : setClause.getAssignments()) {
                ExprNode expr = StatementSpecMapper.mapExpressionDeep(pair.getSecond(), mapContext);
                desc.addAssignment(new OnTriggerSetAssignment(pair.getFirst(), expr));
            }
            raw.setOnTriggerDesc(desc);
        } else {
            throw new IllegalArgumentException("Cannot map on-clause expression type : " + onExpr);
        }
    }

    private static void mapHaving(Expression havingClause, StatementSpecRaw raw, StatementSpecMapContext mapContext) {
        if (havingClause == null) {
            return;
        }
        ExprNode node = StatementSpecMapper.mapExpressionDeep(havingClause, mapContext);
        raw.setHavingExprRootNode(node);
    }

    private static void unmapHaving(ExprNode havingExprRootNode, EPStatementObjectModel model, StatementSpecUnMapContext unmapContext) {
        if (havingExprRootNode == null) {
            return;
        }
        Expression expr = StatementSpecMapper.unmapExpressionDeep(havingExprRootNode, unmapContext);
        model.setHavingClause(expr);
    }

    private static void mapGroupBy(GroupByClause groupByClause, StatementSpecRaw raw, StatementSpecMapContext mapContext) {
        if (groupByClause == null) {
            return;
        }
        for (Expression expr : groupByClause.getGroupByExpressions()) {
            ExprNode node = StatementSpecMapper.mapExpressionDeep(expr, mapContext);
            raw.getGroupByExpressions().add(node);
        }
    }

    private static void unmapGroupBy(List<ExprNode> groupByExpressions, EPStatementObjectModel model, StatementSpecUnMapContext unmapContext) {
        if (groupByExpressions.size() == 0) {
            return;
        }
        GroupByClause clause = new GroupByClause();
        for (ExprNode node : groupByExpressions) {
            Expression expr = StatementSpecMapper.unmapExpressionDeep(node, unmapContext);
            clause.getGroupByExpressions().add(expr);
        }
        model.setGroupByClause(clause);
    }

    private static void mapWhere(Expression whereClause, StatementSpecRaw raw, StatementSpecMapContext mapContext) {
        if (whereClause == null) {
            return;
        }
        ExprNode node = StatementSpecMapper.mapExpressionDeep(whereClause, mapContext);
        raw.setFilterRootNode(node);
    }

    private static void unmapWhere(ExprNode filterRootNode, EPStatementObjectModel model, StatementSpecUnMapContext unmapContext) {
        if (filterRootNode == null) {
            return;
        }
        Expression expr = StatementSpecMapper.unmapExpressionDeep(filterRootNode, unmapContext);
        model.setWhereClause(expr);
    }

    private static void unmapFrom(List<StreamSpecRaw> streamSpecs, List<OuterJoinDesc> outerJoinDescList, EPStatementObjectModel model, StatementSpecUnMapContext unmapContext) {
        FromClause from = new FromClause(new Stream[0]);
        model.setFromClause(from);
        for (StreamSpecRaw stream : streamSpecs) {
            Stream targetStream;
            if (stream instanceof FilterStreamSpecRaw) {
                FilterStreamSpecRaw filterStreamSpec = (FilterStreamSpecRaw)stream;
                Filter filter = StatementSpecMapper.unmapFilter(filterStreamSpec.getRawFilterSpec(), unmapContext);
                targetStream = new FilterStream(filter, filterStreamSpec.getOptionalStreamName());
            } else if (stream instanceof DBStatementStreamSpec) {
                DBStatementStreamSpec db = (DBStatementStreamSpec)stream;
                targetStream = new SQLStream(db.getDatabaseName(), db.getSqlWithSubsParams(), db.getOptionalStreamName(), db.getMetadataSQL());
            } else if (stream instanceof PatternStreamSpecRaw) {
                PatternStreamSpecRaw pattern = (PatternStreamSpecRaw)stream;
                PatternExpr patternExpr = StatementSpecMapper.unmapPatternEvalDeep(pattern.getEvalNode(), unmapContext);
                targetStream = new PatternStream(patternExpr, pattern.getOptionalStreamName());
            } else if (stream instanceof MethodStreamSpec) {
                MethodStreamSpec method = (MethodStreamSpec)stream;
                MethodInvocationStream methodStream = new MethodInvocationStream(method.getClassName(), method.getMethodName(), method.getOptionalStreamName());
                for (ExprNode exprNode : method.getExpressions()) {
                    Expression expr = StatementSpecMapper.unmapExpressionDeep(exprNode, unmapContext);
                    methodStream.addParameter(expr);
                }
                targetStream = methodStream;
            } else {
                throw new IllegalArgumentException("Stream modelled by " + stream.getClass() + " cannot be unmapped");
            }
            if (targetStream instanceof ProjectedStream) {
                ProjectedStream projStream = targetStream;
                for (ViewSpec viewSpec : stream.getViewSpecs()) {
                    projStream.addView(View.create(viewSpec.getObjectNamespace(), viewSpec.getObjectName(), viewSpec.getObjectParameters()));
                }
            }
            from.add(targetStream);
        }
        for (OuterJoinDesc desc : outerJoinDescList) {
            PropertyValueExpression left = (PropertyValueExpression)StatementSpecMapper.unmapExpressionFlat(desc.getLeftNode(), unmapContext);
            PropertyValueExpression right = (PropertyValueExpression)StatementSpecMapper.unmapExpressionFlat(desc.getRightNode(), unmapContext);
            ArrayList<Pair<PropertyValueExpression, PropertyValueExpression>> additionalProperties = new ArrayList<Pair<PropertyValueExpression, PropertyValueExpression>>();
            if (desc.getAdditionalLeftNodes() != null) {
                for (int i = 0; i < desc.getAdditionalLeftNodes().length; ++i) {
                    ExprIdentNode leftNode = desc.getAdditionalLeftNodes()[i];
                    ExprIdentNode rightNode = desc.getAdditionalRightNodes()[i];
                    PropertyValueExpression propLeft = (PropertyValueExpression)StatementSpecMapper.unmapExpressionFlat(leftNode, unmapContext);
                    PropertyValueExpression propRight = (PropertyValueExpression)StatementSpecMapper.unmapExpressionFlat(rightNode, unmapContext);
                    additionalProperties.add(new Pair<PropertyValueExpression, PropertyValueExpression>(propLeft, propRight));
                }
            }
            from.add(new OuterJoinQualifier(desc.getOuterJoinType(), left, right, additionalProperties));
        }
    }

    private static void unmapSelect(SelectClauseSpec selectClauseSpec, SelectClauseStreamSelectorEnum selectStreamSelectorEnum, EPStatementObjectModel model, StatementSpecUnMapContext unmapContext) {
        SelectClause clause = SelectClause.create();
        clause.setWildcard(selectClauseSpec.isUsingWildcard());
        clause.setStreamSelector(SelectClauseStreamSelectorEnum.mapFromSODA(selectStreamSelectorEnum));
        for (SelectExprElementRawSpec selectExprElementRawSpec : selectClauseSpec.getSelectExprList()) {
            Expression expression = StatementSpecMapper.unmapExpressionDeep(selectExprElementRawSpec.getSelectExpression(), unmapContext);
            clause.add(expression, selectExprElementRawSpec.getOptionalAsName());
        }
        for (SelectExprElementStreamRawSpec selectExprElementStreamRawSpec : selectClauseSpec.getSelectStreamsList()) {
            clause.addStreamWildcard(selectExprElementStreamRawSpec.getStreamAliasName(), selectExprElementStreamRawSpec.getOptionalAsName());
        }
        model.setSelectClause(clause);
    }

    private static void unmapInsertInto(InsertIntoDesc insertIntoDesc, EPStatementObjectModel model) {
        StreamSelector s = StreamSelector.ISTREAM_ONLY;
        if (insertIntoDesc == null) {
            return;
        }
        if (!insertIntoDesc.isIStream()) {
            s = StreamSelector.RSTREAM_ONLY;
        }
        model.setInsertInto(InsertIntoClause.create(insertIntoDesc.getEventTypeAlias(), insertIntoDesc.getColumnNames().toArray(new String[0]), s));
    }

    private static void mapCreateWindow(CreateWindowClause createWindow, StatementSpecRaw raw) {
        if (createWindow == null) {
            return;
        }
        raw.setCreateWindowDesc(new CreateWindowDesc(createWindow.getWindowName(), StatementSpecMapper.mapViews(createWindow.getViews())));
    }

    private static void mapCreateVariable(CreateVariableClause createVariable, StatementSpecRaw raw, StatementSpecMapContext mapContext) {
        if (createVariable == null) {
            return;
        }
        ExprNode assignment = null;
        if (createVariable.getOptionalAssignment() != null) {
            assignment = StatementSpecMapper.mapExpressionDeep(createVariable.getOptionalAssignment(), mapContext);
        }
        raw.setCreateVariableDesc(new CreateVariableDesc(createVariable.getVariableType(), createVariable.getVariableName(), assignment));
    }

    private static void mapInsertInto(InsertIntoClause insertInto, StatementSpecRaw raw) {
        if (insertInto == null) {
            return;
        }
        boolean isIStream = insertInto.isIStream();
        String eventTypeAlias = insertInto.getStreamName();
        InsertIntoDesc desc = new InsertIntoDesc(isIStream, eventTypeAlias);
        for (String name : insertInto.getColumnNames()) {
            desc.add(name);
        }
        raw.setInsertIntoDesc(desc);
    }

    private static void mapSelect(SelectClause selectClause, StatementSpecRaw raw, StatementSpecMapContext mapContext) {
        if (selectClause == null) {
            return;
        }
        SelectClauseSpec spec = new SelectClauseSpec();
        spec.setIsUsingWildcard(selectClause.isWildcard());
        raw.setSelectStreamDirEnum(SelectClauseStreamSelectorEnum.mapFromSODA(selectClause.getStreamSelector()));
        raw.setSelectClauseSpec(spec);
        for (SelectClauseElement selectClauseElement : selectClause.getSelectList()) {
            Expression expr = selectClauseElement.getExpression();
            ExprNode exprNode = StatementSpecMapper.mapExpressionDeep(expr, mapContext);
            SelectExprElementRawSpec rawElement = new SelectExprElementRawSpec(exprNode, selectClauseElement.getAsName());
            spec.add(rawElement);
        }
        for (SelectClauseStreamWildcard selectClauseStreamWildcard : selectClause.getStreamWildcardSelectList()) {
            SelectExprElementStreamRawSpec rawElement = new SelectExprElementStreamRawSpec(selectClauseStreamWildcard.getStreamAliasName(), selectClauseStreamWildcard.getOptionalColumnAlias());
            spec.add(rawElement);
        }
    }

    private static Expression unmapExpressionDeep(ExprNode exprNode, StatementSpecUnMapContext unmapContext) {
        Expression parent = StatementSpecMapper.unmapExpressionFlat(exprNode, unmapContext);
        StatementSpecMapper.unmapExpressionRecursive(parent, exprNode, unmapContext);
        return parent;
    }

    private static ExprNode mapExpressionDeep(Expression expr, StatementSpecMapContext mapContext) {
        ExprNode parent = StatementSpecMapper.mapExpressionFlat(expr, mapContext);
        StatementSpecMapper.mapExpressionRecursive(parent, expr, mapContext);
        return parent;
    }

    private static ExprNode mapExpressionFlat(Expression expr, StatementSpecMapContext mapContext) {
        if (expr == null) {
            throw new IllegalArgumentException("Null expression parameter");
        }
        if (expr instanceof ArithmaticExpression) {
            ArithmaticExpression arith = (ArithmaticExpression)expr;
            return new ExprMathNode(MathArithTypeEnum.parseOperator(arith.getOperator()));
        }
        if (expr instanceof PropertyValueExpression) {
            PropertyValueExpression prop = (PropertyValueExpression)expr;
            int indexDot = prop.getPropertyName().indexOf(46);
            if (indexDot != -1) {
                String stream = prop.getPropertyName().substring(0, indexDot);
                String property = prop.getPropertyName().substring(indexDot + 1, prop.getPropertyName().length());
                return new ExprIdentNode(property, stream);
            }
            if (mapContext.getVariableService().getReader(prop.getPropertyName()) != null) {
                mapContext.setHasVariables(true);
                return new ExprVariableNode(prop.getPropertyName());
            }
            return new ExprIdentNode(prop.getPropertyName());
        }
        if (expr instanceof Conjunction) {
            return new ExprAndNode();
        }
        if (expr instanceof Disjunction) {
            return new ExprOrNode();
        }
        if (expr instanceof RelationalOpExpression) {
            RelationalOpExpression op = (RelationalOpExpression)expr;
            if (op.getOperator().equals("=")) {
                return new ExprEqualsNode(false);
            }
            if (op.getOperator().equals("!=")) {
                return new ExprEqualsNode(true);
            }
            return new ExprRelationalOpNode(RelationalOpEnum.parse(op.getOperator()));
        }
        if (expr instanceof ConstantExpression) {
            ConstantExpression op = (ConstantExpression)expr;
            return new ExprConstantNode(op.getConstant());
        }
        if (expr instanceof ConcatExpression) {
            return new ExprConcatNode();
        }
        if (expr instanceof SubqueryExpression) {
            SubqueryExpression sub = (SubqueryExpression)expr;
            StatementSpecRaw rawSubselect = StatementSpecMapper.map(sub.getModel(), mapContext);
            return new ExprSubselectRowNode(rawSubselect);
        }
        if (expr instanceof SubqueryInExpression) {
            SubqueryInExpression sub = (SubqueryInExpression)expr;
            StatementSpecRaw rawSubselect = StatementSpecMapper.map(sub.getModel(), mapContext);
            ExprSubselectInNode inSub = new ExprSubselectInNode(rawSubselect);
            inSub.setNotIn(sub.isNotIn());
            return inSub;
        }
        if (expr instanceof SubqueryExistsExpression) {
            SubqueryExistsExpression sub = (SubqueryExistsExpression)expr;
            StatementSpecRaw rawSubselect = StatementSpecMapper.map(sub.getModel(), mapContext);
            return new ExprSubselectExistsNode(rawSubselect);
        }
        if (expr instanceof CountStarProjectionExpression) {
            return new ExprCountNode(false);
        }
        if (expr instanceof CountProjectionExpression) {
            CountProjectionExpression count = (CountProjectionExpression)expr;
            return new ExprCountNode(count.isDistinct());
        }
        if (expr instanceof AvgProjectionExpression) {
            AvgProjectionExpression avg = (AvgProjectionExpression)expr;
            return new ExprAvgNode(avg.isDistinct());
        }
        if (expr instanceof SumProjectionExpression) {
            SumProjectionExpression avg = (SumProjectionExpression)expr;
            return new ExprSumNode(avg.isDistinct());
        }
        if (expr instanceof BetweenExpression) {
            BetweenExpression between = (BetweenExpression)expr;
            return new ExprBetweenNode(between.isLowEndpointIncluded(), between.isHighEndpointIncluded(), between.isNotBetween());
        }
        if (expr instanceof PriorExpression) {
            return new ExprPriorNode();
        }
        if (expr instanceof PreviousExpression) {
            return new ExprPreviousNode();
        }
        if (expr instanceof StaticMethodExpression) {
            StaticMethodExpression method = (StaticMethodExpression)expr;
            return new ExprStaticMethodNode(method.getClassName(), method.getMethod());
        }
        if (expr instanceof MinProjectionExpression) {
            MinProjectionExpression method = (MinProjectionExpression)expr;
            return new ExprMinMaxAggrNode(method.isDistinct(), MinMaxTypeEnum.MIN);
        }
        if (expr instanceof MaxProjectionExpression) {
            MaxProjectionExpression method = (MaxProjectionExpression)expr;
            return new ExprMinMaxAggrNode(method.isDistinct(), MinMaxTypeEnum.MAX);
        }
        if (expr instanceof NotExpression) {
            return new ExprNotNode();
        }
        if (expr instanceof InExpression) {
            InExpression in = (InExpression)expr;
            return new ExprInNode(in.isNotIn());
        }
        if (expr instanceof CoalesceExpression) {
            return new ExprCoalesceNode();
        }
        if (expr instanceof CaseWhenThenExpression) {
            return new ExprCaseNode(false);
        }
        if (expr instanceof CaseSwitchExpression) {
            return new ExprCaseNode(true);
        }
        if (expr instanceof MaxRowExpression) {
            return new ExprMinMaxRowNode(MinMaxTypeEnum.MAX);
        }
        if (expr instanceof MinRowExpression) {
            return new ExprMinMaxRowNode(MinMaxTypeEnum.MIN);
        }
        if (expr instanceof BitwiseOpExpression) {
            BitwiseOpExpression bit = (BitwiseOpExpression)expr;
            return new ExprBitWiseNode(bit.getBinaryOp());
        }
        if (expr instanceof ArrayExpression) {
            return new ExprArrayNode();
        }
        if (expr instanceof LikeExpression) {
            return new ExprLikeNode(false);
        }
        if (expr instanceof RegExpExpression) {
            return new ExprRegexpNode(false);
        }
        if (expr instanceof MedianProjectionExpression) {
            MedianProjectionExpression median = (MedianProjectionExpression)expr;
            return new ExprMedianNode(median.isDistinct());
        }
        if (expr instanceof AvedevProjectionExpression) {
            AvedevProjectionExpression node = (AvedevProjectionExpression)expr;
            return new ExprAvedevNode(node.isDistinct());
        }
        if (expr instanceof StddevProjectionExpression) {
            StddevProjectionExpression node = (StddevProjectionExpression)expr;
            return new ExprStddevNode(node.isDistinct());
        }
        if (expr instanceof InstanceOfExpression) {
            InstanceOfExpression node = (InstanceOfExpression)expr;
            return new ExprInstanceofNode(node.getTypeNames());
        }
        if (expr instanceof CastExpression) {
            CastExpression node = (CastExpression)expr;
            return new ExprCastNode(node.getTypeName());
        }
        if (expr instanceof PropertyExistsExpression) {
            return new ExprPropertyExistsNode();
        }
        if (expr instanceof CurrentTimestampExpression) {
            return new ExprTimestampNode();
        }
        if (expr instanceof SubstitutionParameterExpression) {
            SubstitutionParameterExpression node = (SubstitutionParameterExpression)expr;
            if (!node.isSatisfied()) {
                throw new EPException("Substitution parameter value for index " + node.getIndex() + " not set, please provide a value for this parameter");
            }
            return new ExprConstantNode(node.getConstant());
        }
        if (expr instanceof PlugInProjectionExpression) {
            PlugInProjectionExpression node = (PlugInProjectionExpression)expr;
            try {
                AggregationSupport aggregation = mapContext.getEngineImportService().resolveAggregation(node.getFunctionName());
                return new ExprPlugInAggFunctionNode(node.isDistinct(), aggregation, node.getFunctionName());
            }
            catch (EngineImportUndefinedException e) {
                throw new EPException("Error resolving aggregation: " + e.getMessage(), e);
            }
            catch (EngineImportException e) {
                throw new EPException("Error resolving aggregation: " + e.getMessage(), e);
            }
        }
        throw new IllegalArgumentException("Could not map expression node of type " + expr.getClass().getSimpleName());
    }

    private static Expression unmapExpressionFlat(ExprNode expr, StatementSpecUnMapContext unmapContext) {
        if (expr instanceof ExprMathNode) {
            ExprMathNode math = (ExprMathNode)expr;
            return new ArithmaticExpression(math.getMathArithTypeEnum().getExpressionText());
        }
        if (expr instanceof ExprIdentNode) {
            ExprIdentNode prop = (ExprIdentNode)expr;
            String propertyName = prop.getUnresolvedPropertyName();
            if (prop.getStreamOrPropertyName() != null) {
                propertyName = prop.getStreamOrPropertyName() + "." + prop.getUnresolvedPropertyName();
            }
            return new PropertyValueExpression(propertyName);
        }
        if (expr instanceof ExprVariableNode) {
            ExprVariableNode prop = (ExprVariableNode)expr;
            String propertyName = prop.getVariableName();
            return new PropertyValueExpression(propertyName);
        }
        if (expr instanceof ExprEqualsNode) {
            ExprEqualsNode equals = (ExprEqualsNode)expr;
            String operator = "=";
            if (equals.isNotEquals()) {
                operator = "!=";
            }
            return new RelationalOpExpression(operator);
        }
        if (expr instanceof ExprRelationalOpNode) {
            ExprRelationalOpNode rel = (ExprRelationalOpNode)expr;
            return new RelationalOpExpression(rel.getRelationalOpEnum().getExpressionText());
        }
        if (expr instanceof ExprAndNode) {
            return new Conjunction();
        }
        if (expr instanceof ExprOrNode) {
            return new Disjunction();
        }
        if (expr instanceof ExprConstantNode) {
            ExprConstantNode constNode = (ExprConstantNode)expr;
            return new ConstantExpression(constNode.getValue());
        }
        if (expr instanceof ExprConcatNode) {
            return new ConcatExpression();
        }
        if (expr instanceof ExprSubselectRowNode) {
            ExprSubselectRowNode sub = (ExprSubselectRowNode)expr;
            StatementSpecUnMapResult unmapped = StatementSpecMapper.unmap(sub.getStatementSpecRaw());
            unmapContext.addAll(unmapped.getIndexedParams());
            return new SubqueryExpression(unmapped.getObjectModel());
        }
        if (expr instanceof ExprSubselectInNode) {
            ExprSubselectInNode sub = (ExprSubselectInNode)expr;
            StatementSpecUnMapResult unmapped = StatementSpecMapper.unmap(sub.getStatementSpecRaw());
            unmapContext.addAll(unmapped.getIndexedParams());
            return new SubqueryInExpression(unmapped.getObjectModel(), sub.isNotIn());
        }
        if (expr instanceof ExprSubselectExistsNode) {
            ExprSubselectExistsNode sub = (ExprSubselectExistsNode)expr;
            StatementSpecUnMapResult unmapped = StatementSpecMapper.unmap(sub.getStatementSpecRaw());
            unmapContext.addAll(unmapped.getIndexedParams());
            return new SubqueryExistsExpression(unmapped.getObjectModel());
        }
        if (expr instanceof ExprCountNode) {
            ExprCountNode sub = (ExprCountNode)expr;
            if (sub.getChildNodes().size() == 0) {
                return new CountStarProjectionExpression();
            }
            return new CountProjectionExpression(sub.isDistinct());
        }
        if (expr instanceof ExprAvgNode) {
            ExprAvgNode sub = (ExprAvgNode)expr;
            return new AvgProjectionExpression(sub.isDistinct());
        }
        if (expr instanceof ExprSumNode) {
            ExprSumNode sub = (ExprSumNode)expr;
            return new SumProjectionExpression(sub.isDistinct());
        }
        if (expr instanceof ExprBetweenNode) {
            ExprBetweenNode between = (ExprBetweenNode)expr;
            return new BetweenExpression(between.isLowEndpointIncluded(), between.isHighEndpointIncluded(), between.isNotBetween());
        }
        if (expr instanceof ExprPriorNode) {
            return new PriorExpression();
        }
        if (expr instanceof ExprPreviousNode) {
            return new PreviousExpression();
        }
        if (expr instanceof ExprStaticMethodNode) {
            ExprStaticMethodNode node = (ExprStaticMethodNode)expr;
            return new StaticMethodExpression(node.getClassName(), node.getMethodName());
        }
        if (expr instanceof ExprMinMaxAggrNode) {
            ExprMinMaxAggrNode node = (ExprMinMaxAggrNode)expr;
            if (node.getMinMaxTypeEnum() == MinMaxTypeEnum.MIN) {
                return new MinProjectionExpression(node.isDistinct());
            }
            return new MaxProjectionExpression(node.isDistinct());
        }
        if (expr instanceof ExprNotNode) {
            return new NotExpression();
        }
        if (expr instanceof ExprInNode) {
            ExprInNode in = (ExprInNode)expr;
            return new InExpression(in.isNotIn());
        }
        if (expr instanceof ExprCoalesceNode) {
            return new CoalesceExpression();
        }
        if (expr instanceof ExprCaseNode) {
            ExprCaseNode mycase = (ExprCaseNode)expr;
            if (mycase.isCase2()) {
                return new CaseSwitchExpression();
            }
            return new CaseWhenThenExpression();
        }
        if (expr instanceof ExprMinMaxRowNode) {
            ExprMinMaxRowNode node = (ExprMinMaxRowNode)expr;
            if (node.getMinMaxTypeEnum() == MinMaxTypeEnum.MAX) {
                return new MaxRowExpression();
            }
            return new MinRowExpression();
        }
        if (expr instanceof ExprBitWiseNode) {
            ExprBitWiseNode node = (ExprBitWiseNode)expr;
            return new BitwiseOpExpression(node.getBitWiseOpEnum());
        }
        if (expr instanceof ExprArrayNode) {
            return new ArrayExpression();
        }
        if (expr instanceof ExprLikeNode) {
            return new LikeExpression();
        }
        if (expr instanceof ExprRegexpNode) {
            return new RegExpExpression();
        }
        if (expr instanceof ExprMedianNode) {
            ExprMedianNode median = (ExprMedianNode)expr;
            return new MedianProjectionExpression(median.isDistinct());
        }
        if (expr instanceof ExprAvedevNode) {
            ExprAvedevNode node = (ExprAvedevNode)expr;
            return new AvedevProjectionExpression(node.isDistinct());
        }
        if (expr instanceof ExprStddevNode) {
            ExprStddevNode node = (ExprStddevNode)expr;
            return new StddevProjectionExpression(node.isDistinct());
        }
        if (expr instanceof ExprPlugInAggFunctionNode) {
            ExprPlugInAggFunctionNode node = (ExprPlugInAggFunctionNode)expr;
            return new PlugInProjectionExpression(node.getAggregationFunctionName(), node.isDistinct());
        }
        if (expr instanceof ExprInstanceofNode) {
            ExprInstanceofNode node = (ExprInstanceofNode)expr;
            return new InstanceOfExpression(node.getClassIdentifiers());
        }
        if (expr instanceof ExprCastNode) {
            ExprCastNode node = (ExprCastNode)expr;
            return new CastExpression(node.getClassIdentifier());
        }
        if (expr instanceof ExprPropertyExistsNode) {
            return new PropertyExistsExpression();
        }
        if (expr instanceof ExprTimestampNode) {
            return new CurrentTimestampExpression();
        }
        if (expr instanceof ExprSubstitutionNode) {
            ExprSubstitutionNode node = (ExprSubstitutionNode)expr;
            SubstitutionParameterExpression subParam = new SubstitutionParameterExpression(node.getIndex());
            unmapContext.add(node.getIndex(), subParam);
            return subParam;
        }
        throw new IllegalArgumentException("Could not map expression node of type " + expr.getClass().getSimpleName());
    }

    private static void unmapExpressionRecursive(Expression parent, ExprNode expr, StatementSpecUnMapContext unmapContext) {
        for (ExprNode child : expr.getChildNodes()) {
            Expression result = StatementSpecMapper.unmapExpressionFlat(child, unmapContext);
            parent.getChildren().add(result);
            StatementSpecMapper.unmapExpressionRecursive(result, child, unmapContext);
        }
    }

    private static void mapExpressionRecursive(ExprNode parent, Expression expr, StatementSpecMapContext mapContext) {
        for (Expression child : expr.getChildren()) {
            ExprNode result = StatementSpecMapper.mapExpressionFlat(child, mapContext);
            parent.addChildNode(result);
            StatementSpecMapper.mapExpressionRecursive(result, child, mapContext);
        }
    }

    private static void mapFrom(FromClause fromClause, StatementSpecRaw raw, StatementSpecMapContext mapContext) {
        if (fromClause == null) {
            return;
        }
        for (Stream stream : fromClause.getStreams()) {
            StreamSpecBase spec;
            if (stream instanceof FilterStream) {
                FilterStream filterStream = (FilterStream)stream;
                FilterSpecRaw filterSpecRaw = StatementSpecMapper.mapFilter(filterStream.getFilter(), mapContext);
                spec = new FilterStreamSpecRaw(filterSpecRaw, new ArrayList<ViewSpec>(), filterStream.getStreamName());
            } else if (stream instanceof SQLStream) {
                SQLStream sqlStream = (SQLStream)stream;
                spec = new DBStatementStreamSpec(sqlStream.getStreamName(), new ArrayList<ViewSpec>(), sqlStream.getDatabaseName(), sqlStream.getSqlWithSubsParams(), sqlStream.getOptionalMetadataSQL());
            } else if (stream instanceof PatternStream) {
                PatternStream patternStream = (PatternStream)stream;
                EvalNode child = StatementSpecMapper.mapPatternEvalDeep(patternStream.getExpression(), mapContext);
                spec = new PatternStreamSpecRaw(child, new ArrayList<ViewSpec>(), patternStream.getStreamName());
            } else if (stream instanceof MethodInvocationStream) {
                MethodInvocationStream methodStream = (MethodInvocationStream)stream;
                ArrayList<ExprNode> expressions = new ArrayList<ExprNode>();
                for (Expression expr : methodStream.getParameterExpressions()) {
                    ExprNode exprNode = StatementSpecMapper.mapExpressionDeep(expr, mapContext);
                    expressions.add(exprNode);
                }
                spec = new MethodStreamSpec(methodStream.getStreamName(), new ArrayList<ViewSpec>(), "method", methodStream.getClassName(), methodStream.getMethodName(), expressions);
            } else {
                throw new IllegalArgumentException("Could not map from stream " + stream + " to an internal representation");
            }
            raw.getStreamSpecs().add((StreamSpecRaw)((Object)spec));
            if (!(stream instanceof ProjectedStream)) continue;
            ProjectedStream projectedStream = (ProjectedStream)stream;
            spec.getViewSpecs().addAll(StatementSpecMapper.mapViews(projectedStream.getViews()));
        }
        for (OuterJoinQualifier qualifier : fromClause.getOuterJoinQualifiers()) {
            ExprIdentNode left = (ExprIdentNode)StatementSpecMapper.mapExpressionFlat(qualifier.getLeft(), mapContext);
            ExprIdentNode right = (ExprIdentNode)StatementSpecMapper.mapExpressionFlat(qualifier.getRight(), mapContext);
            ExprIdentNode[] additionalLeft = null;
            ExprIdentNode[] additionalRight = null;
            if (qualifier.getAdditionalProperties().size() != 0) {
                additionalLeft = new ExprIdentNode[qualifier.getAdditionalProperties().size()];
                additionalRight = new ExprIdentNode[qualifier.getAdditionalProperties().size()];
                int count = 0;
                for (Pair<PropertyValueExpression, PropertyValueExpression> pair : qualifier.getAdditionalProperties()) {
                    additionalLeft[count] = (ExprIdentNode)StatementSpecMapper.mapExpressionFlat(pair.getFirst(), mapContext);
                    additionalRight[count] = (ExprIdentNode)StatementSpecMapper.mapExpressionFlat(pair.getSecond(), mapContext);
                    ++count;
                }
            }
            raw.getOuterJoinDescList().add(new OuterJoinDesc(qualifier.getType(), left, right, additionalLeft, additionalRight));
        }
    }

    private static List<ViewSpec> mapViews(List<View> views) {
        ArrayList<ViewSpec> viewSpecs = new ArrayList<ViewSpec>();
        for (View view : views) {
            viewSpecs.add(new ViewSpec(view.getNamespace(), view.getName(), view.getParameters()));
        }
        return viewSpecs;
    }

    private static List<View> unmapViews(List<ViewSpec> viewSpecs) {
        ArrayList<View> views = new ArrayList<View>();
        for (ViewSpec viewSpec : viewSpecs) {
            views.add(View.create(viewSpec.getObjectNamespace(), viewSpec.getObjectName(), viewSpec.getObjectParameters()));
        }
        return views;
    }

    private static EvalNode mapPatternEvalFlat(PatternExpr eval, StatementSpecMapContext mapContext) {
        if (eval == null) {
            throw new IllegalArgumentException("Null expression parameter");
        }
        if (eval instanceof PatternAndExpr) {
            return new EvalAndNode();
        }
        if (eval instanceof PatternOrExpr) {
            return new EvalOrNode();
        }
        if (eval instanceof PatternFollowedByExpr) {
            return new EvalFollowedByNode();
        }
        if (eval instanceof PatternEveryExpr) {
            return new EvalEveryNode();
        }
        if (eval instanceof PatternFilterExpr) {
            PatternFilterExpr filterExpr = (PatternFilterExpr)eval;
            FilterSpecRaw filterSpec = StatementSpecMapper.mapFilter(filterExpr.getFilter(), mapContext);
            return new EvalFilterNode(filterSpec, filterExpr.getTagName());
        }
        if (eval instanceof PatternObserverExpr) {
            PatternObserverExpr observer = (PatternObserverExpr)eval;
            return new EvalObserverNode(new PatternObserverSpec(observer.getNamespace(), observer.getName(), observer.getParameters()));
        }
        if (eval instanceof PatternGuardExpr) {
            PatternGuardExpr guard = (PatternGuardExpr)eval;
            return new EvalGuardNode(new PatternGuardSpec(guard.getNamespace(), guard.getName(), guard.getParameters()));
        }
        if (eval instanceof PatternNotExpr) {
            return new EvalNotNode();
        }
        throw new IllegalArgumentException("Could not map pattern expression node of type " + eval.getClass().getSimpleName());
    }

    private static PatternExpr unmapPatternEvalFlat(EvalNode eval, StatementSpecUnMapContext unmapContext) {
        if (eval instanceof EvalAndNode) {
            return new PatternAndExpr();
        }
        if (eval instanceof EvalOrNode) {
            return new PatternOrExpr();
        }
        if (eval instanceof EvalFollowedByNode) {
            return new PatternFollowedByExpr();
        }
        if (eval instanceof EvalEveryNode) {
            return new PatternEveryExpr();
        }
        if (eval instanceof EvalNotNode) {
            return new PatternNotExpr();
        }
        if (eval instanceof EvalFilterNode) {
            EvalFilterNode filterNode = (EvalFilterNode)eval;
            Filter filter = StatementSpecMapper.unmapFilter(filterNode.getRawFilterSpec(), unmapContext);
            return new PatternFilterExpr(filter, filterNode.getEventAsName());
        }
        if (eval instanceof EvalObserverNode) {
            EvalObserverNode observerNode = (EvalObserverNode)eval;
            return new PatternObserverExpr(observerNode.getPatternObserverSpec().getObjectNamespace(), observerNode.getPatternObserverSpec().getObjectName(), observerNode.getPatternObserverSpec().getObjectParameters());
        }
        if (eval instanceof EvalGuardNode) {
            EvalGuardNode guardNode = (EvalGuardNode)eval;
            return new PatternGuardExpr(guardNode.getPatternGuardSpec().getObjectNamespace(), guardNode.getPatternGuardSpec().getObjectName(), guardNode.getPatternGuardSpec().getObjectParameters());
        }
        throw new IllegalArgumentException("Could not map pattern expression node of type " + eval.getClass().getSimpleName());
    }

    private static void unmapPatternEvalRecursive(PatternExpr parent, EvalNode eval, StatementSpecUnMapContext unmapContext) {
        for (EvalNode child : eval.getChildNodes()) {
            PatternExpr result = StatementSpecMapper.unmapPatternEvalFlat(child, unmapContext);
            parent.getChildren().add(result);
            StatementSpecMapper.unmapPatternEvalRecursive(result, child, unmapContext);
        }
    }

    private static void mapPatternEvalRecursive(EvalNode parent, PatternExpr expr, StatementSpecMapContext mapContext) {
        for (PatternExpr child : expr.getChildren()) {
            EvalNode result = StatementSpecMapper.mapPatternEvalFlat(child, mapContext);
            parent.addChildNode(result);
            StatementSpecMapper.mapPatternEvalRecursive(result, child, mapContext);
        }
    }

    private static PatternExpr unmapPatternEvalDeep(EvalNode exprNode, StatementSpecUnMapContext unmapContext) {
        PatternExpr parent = StatementSpecMapper.unmapPatternEvalFlat(exprNode, unmapContext);
        StatementSpecMapper.unmapPatternEvalRecursive(parent, exprNode, unmapContext);
        return parent;
    }

    private static EvalNode mapPatternEvalDeep(PatternExpr expr, StatementSpecMapContext mapContext) {
        EvalNode parent = StatementSpecMapper.mapPatternEvalFlat(expr, mapContext);
        StatementSpecMapper.mapPatternEvalRecursive(parent, expr, mapContext);
        return parent;
    }

    private static FilterSpecRaw mapFilter(Filter filter, StatementSpecMapContext mapContext) {
        ArrayList<ExprNode> expr = new ArrayList<ExprNode>();
        if (filter.getFilter() != null) {
            ExprNode exprNode = StatementSpecMapper.mapExpressionDeep(filter.getFilter(), mapContext);
            expr.add(exprNode);
        }
        return new FilterSpecRaw(filter.getEventTypeAlias(), expr);
    }

    private static Filter unmapFilter(FilterSpecRaw filter, StatementSpecUnMapContext unmapContext) {
        Expression expr = null;
        if (filter.getFilterExpressions().size() > 1) {
            expr = new Conjunction();
            for (ExprNode exprNode : filter.getFilterExpressions()) {
                Expression expression = StatementSpecMapper.unmapExpressionDeep(exprNode, unmapContext);
                expr.getChildren().add(expression);
            }
        } else if (filter.getFilterExpressions().size() == 1) {
            expr = StatementSpecMapper.unmapExpressionDeep(filter.getFilterExpressions().get(0), unmapContext);
        }
        return new Filter(filter.getEventTypeAlias(), expr);
    }
}

