/*
 * Decompiled with CFR 0.152.
 */
package net.esper.eql.variable;

import java.util.HashMap;
import java.util.Iterator;
import net.esper.collection.SingleEventIterator;
import net.esper.eql.variable.VariableChangeCallback;
import net.esper.eql.variable.VariableReader;
import net.esper.eql.variable.VariableService;
import net.esper.event.EventAdapterService;
import net.esper.event.EventBean;
import net.esper.event.EventType;
import net.esper.view.ViewSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateVariableView
extends ViewSupport
implements VariableChangeCallback {
    private static final Log log = LogFactory.getLog(CreateVariableView.class);
    private final EventAdapterService eventAdapterService;
    private final VariableReader reader;
    private final EventType eventType;
    private final String variableName;

    public CreateVariableView(EventAdapterService eventAdapterService, VariableService variableService, String variableName) {
        this.eventAdapterService = eventAdapterService;
        this.variableName = variableName;
        this.reader = variableService.getReader(variableName);
        HashMap<String, Class> variableTypes = new HashMap<String, Class>();
        variableTypes.put(variableName, this.reader.getType());
        this.eventType = eventAdapterService.createAnonymousMapType(variableTypes);
    }

    @Override
    public void update(Object newValue, Object oldValue) {
        if (this.hasViews()) {
            HashMap<String, Object> valuesOld = new HashMap<String, Object>();
            valuesOld.put(this.variableName, oldValue);
            EventBean eventOld = this.eventAdapterService.createMapFromValues(valuesOld, this.eventType);
            HashMap<String, Object> valuesNew = new HashMap<String, Object>();
            valuesNew.put(this.variableName, newValue);
            EventBean eventNew = this.eventAdapterService.createMapFromValues(valuesNew, this.eventType);
            this.updateChildren(new EventBean[]{eventNew}, new EventBean[]{eventOld});
        }
    }

    @Override
    public void update(EventBean[] newData, EventBean[] oldData) {
        throw new UnsupportedOperationException("Update not supported");
    }

    @Override
    public EventType getEventType() {
        return this.eventType;
    }

    @Override
    public Iterator<EventBean> iterator() {
        Object value = this.reader.getValue();
        HashMap<String, Object> values = new HashMap<String, Object>();
        values.put(this.variableName, value);
        EventBean event = this.eventAdapterService.createMapFromValues(values, this.eventType);
        return new SingleEventIterator(event);
    }
}

