/*
 * Decompiled with CFR 0.152.
 */
package net.esper.eql.variable;

import java.util.HashMap;
import java.util.Iterator;
import net.esper.collection.SingleEventIterator;
import net.esper.eql.expression.ExprValidationException;
import net.esper.eql.spec.OnTriggerSetAssignment;
import net.esper.eql.spec.OnTriggerSetDesc;
import net.esper.eql.variable.VariableReader;
import net.esper.eql.variable.VariableService;
import net.esper.event.EventAdapterService;
import net.esper.event.EventBean;
import net.esper.event.EventType;
import net.esper.util.ExecutionPathDebugLog;
import net.esper.util.JavaClassHelper;
import net.esper.view.ViewSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OnSetVariableView
extends ViewSupport {
    private static final Log log = LogFactory.getLog(OnSetVariableView.class);
    private final OnTriggerSetDesc desc;
    private final EventAdapterService eventAdapterService;
    private final VariableService variableService;
    private final EventType eventType;
    private final VariableReader[] readers;
    private final EventBean[] eventsPerStream = new EventBean[1];
    private final boolean[] mustCoerce;

    public OnSetVariableView(OnTriggerSetDesc desc, EventAdapterService eventAdapterService, VariableService variableService) throws ExprValidationException {
        this.desc = desc;
        this.eventAdapterService = eventAdapterService;
        this.variableService = variableService;
        HashMap<String, Class> variableTypes = new HashMap<String, Class>();
        this.readers = new VariableReader[desc.getAssignments().size()];
        this.mustCoerce = new boolean[desc.getAssignments().size()];
        int count = 0;
        for (OnTriggerSetAssignment assignment : desc.getAssignments()) {
            String variableName = assignment.getVariableName();
            this.readers[count] = variableService.getReader(variableName);
            if (this.readers[count] == null) {
                throw new ExprValidationException("Variable by name '" + variableName + "' has not been created or configured");
            }
            Class variableType = this.readers[count].getType();
            Class expressionType = assignment.getExpression().getType();
            variableTypes.put(variableName, variableType);
            if (JavaClassHelper.getBoxedType(expressionType) != variableType && expressionType != null) {
                if (!JavaClassHelper.isNumeric(variableType) || !JavaClassHelper.isNumeric(expressionType)) {
                    throw new ExprValidationException("Variable '" + variableName + "' of declared type '" + variableType.getName() + "' cannot be assigned a value of type '" + expressionType.getName() + "'");
                }
                if (!JavaClassHelper.canCoerce(expressionType, variableType)) {
                    throw new ExprValidationException("Variable '" + variableName + "' of declared type '" + variableType.getName() + "' cannot be assigned a value of type '" + expressionType.getName() + "'");
                }
                this.mustCoerce[count] = true;
            }
            ++count;
        }
        this.eventType = eventAdapterService.createAnonymousMapType(variableTypes);
    }

    @Override
    public void update(EventBean[] newData, EventBean[] oldData) {
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".update Received update,   newData.length==" + (newData == null ? 0 : newData.length) + "  oldData.length==" + (oldData == null ? 0 : oldData.length));
        }
        if (newData == null || newData.length == 0) {
            return;
        }
        HashMap<String, Object> values = null;
        if (this.hasViews()) {
            values = new HashMap<String, Object>();
        }
        this.eventsPerStream[0] = newData[newData.length - 1];
        int count = 0;
        this.variableService.getReadWriteLock().writeLock().lock();
        try {
            this.variableService.setLocalVersion();
            for (OnTriggerSetAssignment assignment : this.desc.getAssignments()) {
                VariableReader reader = this.readers[count];
                Object value = assignment.getExpression().evaluate(this.eventsPerStream, true);
                if (value != null && this.mustCoerce[count]) {
                    value = JavaClassHelper.coerceBoxed((Number)value, reader.getType());
                }
                this.variableService.write(reader.getVariableNumber(), value);
                ++count;
                if (values == null) continue;
                values.put(assignment.getVariableName(), value);
            }
            this.variableService.commit();
        }
        catch (RuntimeException ex) {
            log.error("Error evaluating on-set variable expressions: " + ex.getMessage(), ex);
            this.variableService.rollback();
            throw ex;
        }
        finally {
            this.variableService.getReadWriteLock().writeLock().unlock();
        }
        if (values != null) {
            EventBean[] newDataOut = new EventBean[]{this.eventAdapterService.createMapFromValues(values, this.eventType)};
            this.updateChildren(newDataOut, null);
        }
    }

    @Override
    public EventType getEventType() {
        return this.eventType;
    }

    @Override
    public Iterator<EventBean> iterator() {
        HashMap<String, Object> values = new HashMap<String, Object>();
        int count = 0;
        for (OnTriggerSetAssignment assignment : this.desc.getAssignments()) {
            Object value = this.readers[count].getValue();
            values.put(assignment.getVariableName(), value);
            ++count;
        }
        EventBean event = this.eventAdapterService.createMapFromValues(values, this.eventType);
        return new SingleEventIterator(event);
    }
}

