/*
 * Decompiled with CFR 0.152.
 */
package net.esper.eql.variable;

import net.esper.eql.variable.VariableVersionThreadEntry;
import net.esper.eql.variable.VariableVersionThreadLocal;
import net.esper.eql.variable.VersionedValueList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VariableReader {
    private static final Log log = LogFactory.getLog(VariableReader.class);
    private final String variableName;
    private final int variableNumber;
    private final VariableVersionThreadLocal versionThreadLocal;
    private transient VersionedValueList<Object> versionsHigh;
    private transient VersionedValueList<Object> versionsLow;
    private final Class type;

    public VariableReader(VariableVersionThreadLocal versionThreadLocal, Class type, String variableName, int variableNumber, VersionedValueList<Object> versions) {
        this.variableName = variableName;
        this.variableNumber = variableNumber;
        this.versionThreadLocal = versionThreadLocal;
        this.type = type;
        this.versionsLow = versions;
        this.versionsHigh = null;
    }

    public int getVariableNumber() {
        return this.variableNumber;
    }

    public Class getType() {
        return this.type;
    }

    public void setVersionsHigh(VersionedValueList<Object> versionsHigh) {
        this.versionsHigh = versionsHigh;
    }

    public void setVersionsLow(VersionedValueList<Object> versionsLow) {
        this.versionsLow = versionsLow;
    }

    public Object getValue() {
        VariableVersionThreadEntry entry = this.versionThreadLocal.getCurrentThread();
        if (entry.getUncommitted() != null && entry.getUncommitted().containsKey(this.variableNumber)) {
            return entry.getUncommitted().get(this.variableNumber);
        }
        int myVersion = entry.getVersion();
        VersionedValueList<Object> versions = this.versionsLow;
        if (myVersion >= 2147383647 && this.versionsHigh != null) {
            versions = this.versionsHigh;
        }
        return versions.getVersion(myVersion);
    }
}

