/*
 * Decompiled with CFR 0.152.
 */
package net.esper.eql.variable;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.esper.collection.Pair;
import net.esper.core.StatementExtensionSvcContext;
import net.esper.eql.variable.VariableChangeCallback;
import net.esper.eql.variable.VariableExistsException;
import net.esper.eql.variable.VariableReader;
import net.esper.eql.variable.VariableService;
import net.esper.eql.variable.VariableStateHandler;
import net.esper.eql.variable.VariableTypeException;
import net.esper.eql.variable.VariableVersionThreadEntry;
import net.esper.eql.variable.VariableVersionThreadLocal;
import net.esper.eql.variable.VersionedValueList;
import net.esper.schedule.TimeProvider;
import net.esper.util.JavaClassHelper;

public class VariableServiceImpl
implements VariableService {
    protected static final int ROLLOVER_READER_BOUNDARY = 2147383647;
    protected static final int ROLLOVER_WRITER_BOUNDARY = 2147393647;
    protected static final int HIGH_WATERMARK_VERSIONS = 50;
    private final Map<String, VariableReader> variables;
    private final ArrayList<VersionedValueList<Object>> variableVersions;
    private final ArrayList<VariableChangeCallback> changeCallbacks;
    private final ReadWriteLock readWriteLock;
    private final VariableVersionThreadLocal versionThreadLocal = new VariableVersionThreadLocal();
    private final long millisecondLifetimeOldVersions;
    private final TimeProvider timeProvider;
    private final VariableStateHandler optionalStateHandler;
    private transient int currentVersionNumber;
    private int currentVariableNumber;

    public VariableServiceImpl(long millisecondLifetimeOldVersions, TimeProvider timeProvider, VariableStateHandler optionalStateHandler) {
        this(0, millisecondLifetimeOldVersions, timeProvider, optionalStateHandler);
    }

    protected VariableServiceImpl(int startVersion, long millisecondLifetimeOldVersions, TimeProvider timeProvider, VariableStateHandler optionalStateHandler) {
        this.millisecondLifetimeOldVersions = millisecondLifetimeOldVersions;
        this.timeProvider = timeProvider;
        this.optionalStateHandler = optionalStateHandler;
        this.variables = new HashMap<String, VariableReader>();
        this.variableVersions = new ArrayList();
        this.readWriteLock = new ReentrantReadWriteLock();
        this.changeCallbacks = new ArrayList();
        this.currentVersionNumber = startVersion;
    }

    public void setLocalVersion() {
        this.versionThreadLocal.getCurrentThread().setVersion(this.currentVersionNumber);
    }

    public void registerCallback(int variableNumber, VariableChangeCallback variableChangeCallback) {
        this.changeCallbacks.set(variableNumber, variableChangeCallback);
    }

    public synchronized void createNewVariable(String variableName, Class type, Object value, StatementExtensionSvcContext extensionServicesContext) throws VariableExistsException, VariableTypeException {
        Pair<Boolean, Object> priorValue;
        VariableReader reader;
        Class variableType = JavaClassHelper.getBoxedType(type);
        if (!JavaClassHelper.isJavaBuiltinDataType(variableType)) {
            throw new VariableTypeException("Invalid variable type for variable '" + variableName + "' as type '" + variableType.getName() + "', only Java primitive, boxed or String types are allowed");
        }
        Object coercedValue = value;
        if (coercedValue != null && coercedValue instanceof String) {
            try {
                coercedValue = JavaClassHelper.parse(type, (String)coercedValue);
            }
            catch (Exception ex) {
                throw new VariableTypeException("Variable '" + variableName + "' of declared type '" + variableType.getName() + "' cannot be initialized by value '" + coercedValue + "': " + ex.toString());
            }
        }
        if (coercedValue != null && variableType != coercedValue.getClass()) {
            if (!JavaClassHelper.isNumeric(variableType) || !(coercedValue instanceof Number)) {
                throw new VariableTypeException("Variable '" + variableName + "' of declared type '" + variableType.getName() + "' cannot be initialized by a value of type '" + coercedValue.getClass().getName() + "'");
            }
            if (!JavaClassHelper.canCoerce(coercedValue.getClass(), variableType)) {
                throw new VariableTypeException("Variable '" + variableName + "' of declared type '" + variableType.getName() + "' cannot be initialized by a value of type '" + coercedValue.getClass().getName() + "'");
            }
            coercedValue = JavaClassHelper.coerceBoxed((Number)coercedValue, variableType);
        }
        if ((reader = this.variables.get(variableName)) != null) {
            throw new VariableExistsException("Variable by name '" + variableName + "' has already been created");
        }
        long timestamp = this.timeProvider.getTime();
        if (this.optionalStateHandler != null && (priorValue = this.optionalStateHandler.getHasState(variableName, this.currentVariableNumber, variableType, extensionServicesContext)).getFirst().booleanValue()) {
            coercedValue = priorValue.getSecond();
        }
        VersionedValueList<Object> valuePerVersion = new VersionedValueList<Object>(variableName, this.currentVersionNumber, coercedValue, timestamp, this.millisecondLifetimeOldVersions, this.readWriteLock.readLock(), 50, false);
        this.variableVersions.add(valuePerVersion);
        this.changeCallbacks.add(null);
        reader = new VariableReader(this.versionThreadLocal, variableType, variableName, this.currentVariableNumber, valuePerVersion);
        this.variables.put(variableName, reader);
        ++this.currentVariableNumber;
    }

    public VariableReader getReader(String variableName) {
        return this.variables.get(variableName);
    }

    public void write(int variableNumber, Object newValue) {
        VariableVersionThreadEntry entry = this.versionThreadLocal.getCurrentThread();
        if (entry.getUncommitted() == null) {
            entry.setUncommitted(new HashMap<Integer, Object>());
        }
        entry.getUncommitted().put(variableNumber, newValue);
    }

    public ReadWriteLock getReadWriteLock() {
        return this.readWriteLock;
    }

    public void commit() {
        VariableVersionThreadEntry entry = this.versionThreadLocal.getCurrentThread();
        if (entry.getUncommitted() == null) {
            return;
        }
        int newVersion = this.currentVersionNumber + 1;
        if (this.currentVersionNumber == 2147383647) {
            this.rollOver();
            newVersion = 2;
        }
        long timestamp = this.timeProvider.getTime();
        for (Map.Entry<Integer, Object> uncommittedEntry : entry.getUncommitted().entrySet()) {
            VersionedValueList<Object> versions = this.variableVersions.get(uncommittedEntry.getKey());
            Object oldValue = versions.addValue(newVersion, uncommittedEntry.getValue(), timestamp);
            VariableChangeCallback callback = this.changeCallbacks.get(uncommittedEntry.getKey());
            if (callback != null) {
                callback.update(uncommittedEntry.getValue(), oldValue);
            }
            if (this.optionalStateHandler == null) continue;
            String name = versions.getName();
            this.optionalStateHandler.setState(name, uncommittedEntry.getKey(), uncommittedEntry.getValue());
        }
        this.currentVersionNumber = newVersion;
        entry.setUncommitted(null);
    }

    public void rollback() {
        VariableVersionThreadEntry entry = this.versionThreadLocal.getCurrentThread();
        entry.setUncommitted(null);
    }

    private void rollOver() {
        for (Map.Entry<String, VariableReader> entry : this.variables.entrySet()) {
            int variableNum = entry.getValue().getVariableNumber();
            String name = entry.getKey();
            long timestamp = this.timeProvider.getTime();
            VersionedValueList<Object> versionsOld = this.variableVersions.get(variableNum);
            Object currentValue = versionsOld.getCurrentAndPriorValue().getCurrentVersion().getValue();
            VersionedValueList<Object> versionsNew = new VersionedValueList<Object>(name, 1, currentValue, timestamp, this.millisecondLifetimeOldVersions, this.readWriteLock.readLock(), 50, false);
            entry.getValue().setVersionsHigh(versionsOld);
            entry.getValue().setVersionsLow(versionsNew);
            this.variableVersions.set(variableNum, versionsNew);
        }
    }

    public String toString() {
        StringWriter writer = new StringWriter();
        for (Map.Entry<String, VariableReader> entry : this.variables.entrySet()) {
            int variableNum = entry.getValue().getVariableNumber();
            VersionedValueList<Object> list = this.variableVersions.get(variableNum);
            writer.write("Variable '" + entry.getKey() + "' : " + list.toString() + "\n");
        }
        return writer.toString();
    }
}

