/*
 * Decompiled with CFR 0.152.
 */
package net.esper.eql.view;

import java.util.Iterator;
import net.esper.eql.expression.ExprEvaluator;
import net.esper.eql.view.FilterExprViewIterator;
import net.esper.event.EventBean;
import net.esper.event.EventType;
import net.esper.view.ViewSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterExprView
extends ViewSupport {
    private ExprEvaluator exprEvaluator;

    public FilterExprView(ExprEvaluator exprEvaluator) {
        this.exprEvaluator = exprEvaluator;
    }

    @Override
    public EventType getEventType() {
        return this.parent.getEventType();
    }

    @Override
    public Iterator<EventBean> iterator() {
        return new FilterExprViewIterator(this.parent.iterator(), this.exprEvaluator);
    }

    @Override
    public void update(EventBean[] newData, EventBean[] oldData) {
        EventBean[] filteredNewData = FilterExprView.filterEvents(this.exprEvaluator, newData, true);
        EventBean[] filteredOldData = FilterExprView.filterEvents(this.exprEvaluator, oldData, false);
        if (filteredNewData != null || filteredOldData != null) {
            this.updateChildren(filteredNewData, filteredOldData);
        }
    }

    protected static EventBean[] filterEvents(ExprEvaluator exprEvaluator, EventBean[] events, boolean isNewData) {
        if (events == null) {
            return null;
        }
        EventBean[] evalEventArr = new EventBean[1];
        boolean[] passResult = new boolean[events.length];
        int passCount = 0;
        for (int i = 0; i < events.length; ++i) {
            evalEventArr[0] = events[i];
            Boolean pass = (Boolean)exprEvaluator.evaluate(evalEventArr, isNewData);
            if (pass == null || !pass.booleanValue()) continue;
            passResult[i] = true;
            ++passCount;
        }
        if (passCount == 0) {
            return null;
        }
        if (passCount == events.length) {
            return events;
        }
        EventBean[] resultArray = new EventBean[passCount];
        int count = 0;
        for (int i = 0; i < passResult.length; ++i) {
            if (!passResult[i]) continue;
            resultArray[count] = events[i];
            ++count;
        }
        return resultArray;
    }
}

