/*
 * Decompiled with CFR 0.152.
 */
package net.esper.eql.view;

import net.esper.eql.variable.VariableReader;
import net.esper.eql.view.OutputCallback;
import net.esper.eql.view.OutputCondition;
import net.esper.util.ExecutionPathDebugLog;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class OutputConditionCount
implements OutputCondition {
    private static final boolean DO_OUTPUT = true;
    private static final boolean FORCE_UPDATE = false;
    private long eventRate;
    private int newEventsCount;
    private int oldEventsCount;
    private final OutputCallback outputCallback;
    private final VariableReader variableReader;
    private static final Log log = LogFactory.getLog(OutputConditionCount.class);

    public OutputConditionCount(int eventRate, VariableReader variableReader, OutputCallback outputCallback) {
        if (eventRate < 1 && variableReader == null) {
            throw new IllegalArgumentException("Limiting output by event count requires an event count of at least 1 or a variable name");
        }
        if (outputCallback == null) {
            throw new NullPointerException("Output condition by count requires a non-null callback");
        }
        this.eventRate = eventRate;
        this.outputCallback = outputCallback;
        this.variableReader = variableReader;
    }

    public int getNewEventsCount() {
        return this.newEventsCount;
    }

    public int getOldEventsCount() {
        return this.oldEventsCount;
    }

    public final long getEventRate() {
        return this.eventRate;
    }

    public final void updateOutputCondition(int newDataCount, int oldDataCount) {
        Object value;
        if (this.variableReader != null && (value = this.variableReader.getValue()) != null) {
            this.eventRate = ((Number)value).longValue();
        }
        this.newEventsCount += newDataCount;
        this.oldEventsCount += oldDataCount;
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".updateBatchCondition,   newEventsCount==" + this.newEventsCount + "  oldEventsCount==" + this.oldEventsCount);
        }
        if (this.isSatisfied()) {
            log.debug(".updateOutputCondition() condition satisfied");
            this.newEventsCount = 0;
            this.oldEventsCount = 0;
            this.outputCallback.continueOutputProcessing(true, false);
        }
    }

    public final String toString() {
        return this.getClass().getName() + " eventRate=" + this.eventRate;
    }

    private boolean isSatisfied() {
        return (long)this.newEventsCount >= this.eventRate || (long)this.oldEventsCount >= this.eventRate;
    }
}

