/*
 * Decompiled with CFR 0.152.
 */
package net.esper.eql.view;

import net.esper.core.StatementContext;
import net.esper.eql.spec.OutputLimitLimitType;
import net.esper.eql.spec.OutputLimitRateType;
import net.esper.eql.spec.OutputLimitSpec;
import net.esper.eql.variable.VariableReader;
import net.esper.eql.view.OutputCallback;
import net.esper.eql.view.OutputCondition;
import net.esper.eql.view.OutputConditionCount;
import net.esper.eql.view.OutputConditionFactory;
import net.esper.eql.view.OutputConditionFirst;
import net.esper.eql.view.OutputConditionNull;
import net.esper.eql.view.OutputConditionTime;
import net.esper.util.JavaClassHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OutputConditionFactoryDefault
implements OutputConditionFactory {
    private static final Log log = LogFactory.getLog(OutputConditionFactoryDefault.class);

    public OutputCondition createCondition(OutputLimitSpec outputLimitSpec, StatementContext statementContext, OutputCallback outputCallback) {
        if (outputCallback == null) {
            throw new NullPointerException("Output condition by count requires a non-null callback");
        }
        if (outputLimitSpec == null) {
            return new OutputConditionNull(outputCallback);
        }
        VariableReader reader = null;
        if (outputLimitSpec.getVariableName() != null && (reader = statementContext.getVariableService().getReader(outputLimitSpec.getVariableName())) == null) {
            throw new IllegalArgumentException("Variable named '" + outputLimitSpec.getVariableName() + "' has not been declared");
        }
        if (outputLimitSpec.getDisplayLimit() == OutputLimitLimitType.FIRST) {
            log.debug(".createCondition creating OutputConditionFirst");
            return new OutputConditionFirst(outputLimitSpec, statementContext, outputCallback);
        }
        if (outputLimitSpec.getRateType() == OutputLimitRateType.EVENTS) {
            if (log.isDebugEnabled()) {
                log.debug(".createCondition creating OutputConditionCount with event rate " + outputLimitSpec);
            }
            if (reader != null && !JavaClassHelper.isNumericNonFP(reader.getType())) {
                throw new IllegalArgumentException("Variable named '" + outputLimitSpec.getVariableName() + "' must be type integer, long or short");
            }
            int rate = -1;
            if (outputLimitSpec.getRate() != null) {
                rate = outputLimitSpec.getRate().intValue();
            }
            return new OutputConditionCount(rate, reader, outputCallback);
        }
        if (log.isDebugEnabled()) {
            log.debug(".createCondition creating OutputConditionTime with interval length " + outputLimitSpec.getRate());
        }
        if (reader != null && !JavaClassHelper.isNumeric(reader.getType())) {
            throw new IllegalArgumentException("Variable named '" + outputLimitSpec.getVariableName() + "' must be of numeric type");
        }
        boolean isMinutesUnit = outputLimitSpec.getRateType() == OutputLimitRateType.TIME_MIN;
        return new OutputConditionTime(outputLimitSpec.getRate(), isMinutesUnit, reader, statementContext, outputCallback);
    }
}

