/*
 * Decompiled with CFR 0.152.
 */
package net.esper.eql.view;

import net.esper.core.StatementContext;
import net.esper.eql.spec.OutputLimitLimitType;
import net.esper.eql.spec.OutputLimitSpec;
import net.esper.eql.view.OutputCallback;
import net.esper.eql.view.OutputCondition;

public class OutputConditionFirst
implements OutputCondition {
    private final OutputCallback outputCallback;
    private final OutputCondition innerCondition;
    private boolean witnessedFirst;

    public OutputConditionFirst(OutputLimitSpec outputLimitSpec, StatementContext statementContext, OutputCallback outputCallback) {
        if (outputCallback == null) {
            throw new NullPointerException("Output condition by count requires a non-null callback");
        }
        this.outputCallback = outputCallback;
        OutputLimitSpec innerSpec = new OutputLimitSpec(outputLimitSpec.getRate(), outputLimitSpec.getVariableName(), outputLimitSpec.getRateType(), OutputLimitLimitType.ALL);
        OutputCallback localCallback = this.createCallbackToLocal();
        this.innerCondition = statementContext.getOutputConditionFactory().createCondition(innerSpec, statementContext, localCallback);
        this.witnessedFirst = false;
    }

    public void updateOutputCondition(int newEventsCount, int oldEventsCount) {
        if (!this.witnessedFirst) {
            this.witnessedFirst = true;
            boolean doOutput = true;
            boolean forceUpdate = false;
            this.outputCallback.continueOutputProcessing(doOutput, forceUpdate);
        }
        this.innerCondition.updateOutputCondition(newEventsCount, oldEventsCount);
    }

    private OutputCallback createCallbackToLocal() {
        return new OutputCallback(){

            public void continueOutputProcessing(boolean doOutput, boolean forceUpdate) {
                OutputConditionFirst.this.continueOutputProcessing(forceUpdate);
            }
        };
    }

    private void continueOutputProcessing(boolean forceUpdate) {
        boolean doOutput = !this.witnessedFirst;
        this.outputCallback.continueOutputProcessing(doOutput, forceUpdate);
        this.witnessedFirst = false;
    }
}

