/*
 * Decompiled with CFR 0.152.
 */
package net.esper.eql.view;

import net.esper.core.EPStatementHandleCallback;
import net.esper.core.ExtensionServicesContext;
import net.esper.core.StatementContext;
import net.esper.eql.variable.VariableReader;
import net.esper.eql.view.OutputCallback;
import net.esper.eql.view.OutputCondition;
import net.esper.schedule.ScheduleHandle;
import net.esper.schedule.ScheduleHandleCallback;
import net.esper.schedule.ScheduleSlot;
import net.esper.util.ExecutionPathDebugLog;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class OutputConditionTime
implements OutputCondition {
    private static final boolean DO_OUTPUT = true;
    private static final boolean FORCE_UPDATE = true;
    private long msecIntervalSize;
    private final OutputCallback outputCallback;
    private final ScheduleSlot scheduleSlot;
    private Long currentReferencePoint;
    private StatementContext context;
    private boolean isCallbackScheduled;
    private final VariableReader reader;
    private EPStatementHandleCallback handle;
    private boolean isMinutesUnit;
    private static final Log log = LogFactory.getLog(OutputConditionTime.class);

    public OutputConditionTime(Double intervalSize, boolean isMinutesUnit, VariableReader reader, StatementContext context, OutputCallback outputCallback) {
        if (outputCallback == null) {
            throw new NullPointerException("Output condition by count requires a non-null callback");
        }
        if (!isMinutesUnit && intervalSize < 0.1 && reader == null) {
            throw new IllegalArgumentException("Output condition by time requires a millisecond interval size of at least 100 msec or a variable");
        }
        if (context == null) {
            String message = "OutputConditionTime requires a non-null view context";
            throw new NullPointerException(message);
        }
        this.reader = reader;
        this.context = context;
        this.outputCallback = outputCallback;
        this.scheduleSlot = context.getScheduleBucket().allocateSlot();
        this.isMinutesUnit = isMinutesUnit;
        if (reader != null) {
            intervalSize = ((Number)reader.getValue()).doubleValue();
        }
        if (isMinutesUnit) {
            intervalSize = intervalSize * 60.0;
        }
        this.msecIntervalSize = Math.round(1000.0 * intervalSize);
    }

    public final long getMsecIntervalSize() {
        return this.msecIntervalSize;
    }

    public final void updateOutputCondition(int newEventsCount, int oldEventsCount) {
        Object value;
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".updateOutputCondition,   newEventsCount==" + newEventsCount + "  oldEventsCount==" + oldEventsCount);
        }
        if (this.currentReferencePoint == null) {
            this.currentReferencePoint = this.context.getSchedulingService().getTime();
        }
        if (this.reader != null && (value = this.reader.getValue()) != null) {
            long newMsecIntervalSize;
            double intervalSize = ((Number)this.reader.getValue()).doubleValue();
            if (this.isMinutesUnit) {
                intervalSize *= 60.0;
            }
            if ((newMsecIntervalSize = Math.round(1000.0 * intervalSize)) != this.msecIntervalSize && this.isCallbackScheduled) {
                this.context.getSchedulingService().remove(this.handle, this.scheduleSlot);
                this.scheduleCallback();
            }
        }
        if (!this.isCallbackScheduled) {
            this.scheduleCallback();
        }
    }

    public final String toString() {
        return this.getClass().getName() + " msecIntervalSize=" + this.msecIntervalSize;
    }

    private void scheduleCallback() {
        Object value;
        if (this.reader != null && (value = this.reader.getValue()) != null) {
            double intervalSize = ((Number)this.reader.getValue()).doubleValue();
            if (this.isMinutesUnit) {
                intervalSize *= 60.0;
            }
            this.msecIntervalSize = Math.round(1000.0 * intervalSize);
        }
        this.isCallbackScheduled = true;
        long current = this.context.getSchedulingService().getTime();
        long afterMSec = OutputConditionTime.computeWaitMSec(current, this.currentReferencePoint, this.msecIntervalSize);
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".scheduleCallback Scheduled new callback for  afterMsec=" + afterMSec + " now=" + current + " currentReferencePoint=" + this.currentReferencePoint + " msecIntervalSize=" + this.msecIntervalSize);
        }
        ScheduleHandleCallback callback = new ScheduleHandleCallback(){

            public void scheduledTrigger(ExtensionServicesContext extensionServicesContext) {
                OutputConditionTime.this.isCallbackScheduled = false;
                OutputConditionTime.this.outputCallback.continueOutputProcessing(true, true);
                OutputConditionTime.this.scheduleCallback();
            }
        };
        this.handle = new EPStatementHandleCallback(this.context.getEpStatementHandle(), callback);
        this.context.getSchedulingService().add(afterMSec, (ScheduleHandle)this.handle, this.scheduleSlot);
    }

    protected static long computeWaitMSec(long current, long reference, long interval) {
        long solution;
        long n = (long)((float)(current - reference) / ((float)interval * 1.0f));
        if (reference > current) {
            --n;
        }
        if ((solution = reference + (n + 1L) * interval - current) == 0L) {
            return interval;
        }
        return solution;
    }
}

