/*
 * Decompiled with CFR 0.152.
 */
package net.esper.eql.view;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import net.esper.collection.MultiKey;
import net.esper.collection.Pair;
import net.esper.core.StatementContext;
import net.esper.eql.core.ResultSetProcessor;
import net.esper.eql.spec.OutputLimitLimitType;
import net.esper.eql.spec.OutputLimitSpec;
import net.esper.eql.view.OutputCallback;
import net.esper.eql.view.OutputCondition;
import net.esper.eql.view.OutputProcessView;
import net.esper.event.EventBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutputProcessViewPolicy
extends OutputProcessView {
    private final boolean outputLastOnly;
    private final OutputCondition outputCondition;
    private final boolean outputSnapshot;
    private List<EventBean> newEventsList = new ArrayList<EventBean>();
    private List<EventBean> oldEventsList = new ArrayList<EventBean>();
    private Set<MultiKey<EventBean>> newEventsSet = new LinkedHashSet<MultiKey<EventBean>>();
    private Set<MultiKey<EventBean>> oldEventsSet = new LinkedHashSet<MultiKey<EventBean>>();
    private static final Log log = LogFactory.getLog(OutputProcessViewPolicy.class);

    public OutputProcessViewPolicy(ResultSetProcessor resultSetProcessor, int streamCount, OutputLimitSpec outputLimitSpec, StatementContext statementContext) {
        super(resultSetProcessor);
        log.debug(".ctor");
        if (streamCount < 1) {
            throw new IllegalArgumentException("Output process view is part of at least 1 stream");
        }
        OutputCallback outputCallback = this.getCallbackToLocal(streamCount);
        this.outputCondition = statementContext.getOutputConditionFactory().createCondition(outputLimitSpec, statementContext, outputCallback);
        this.outputLastOnly = outputLimitSpec != null && outputLimitSpec.getDisplayLimit() == OutputLimitLimitType.LAST;
        this.outputSnapshot = outputLimitSpec != null && outputLimitSpec.getDisplayLimit() == OutputLimitLimitType.SNAPSHOT;
    }

    @Override
    public void update(EventBean[] newData, EventBean[] oldData) {
        if (log.isDebugEnabled()) {
            log.debug(".update Received update,   newData.length==" + (newData == null ? 0 : newData.length) + "  oldData.length==" + (oldData == null ? 0 : oldData.length));
        }
        int newDataLength = 0;
        int oldDataLength = 0;
        if (newData != null) {
            newDataLength = newData.length;
            for (EventBean event : newData) {
                this.newEventsList.add(event);
            }
        }
        if (oldData != null) {
            oldDataLength = oldData.length;
            for (EventBean event : oldData) {
                this.oldEventsList.add(event);
            }
        }
        this.outputCondition.updateOutputCondition(newDataLength, oldDataLength);
    }

    @Override
    public void process(Set<MultiKey<EventBean>> newEvents, Set<MultiKey<EventBean>> oldEvents) {
        if (log.isDebugEnabled()) {
            log.debug(".process Received update,   newData.length==" + (newEvents == null ? 0 : newEvents.size()) + "  oldData.length==" + (oldEvents == null ? 0 : oldEvents.size()));
        }
        int newEventsSize = 0;
        if (newEvents != null) {
            newEventsSize = newEvents.size();
            for (MultiKey<EventBean> event : newEvents) {
                this.newEventsSet.add(event);
            }
        }
        int oldEventsSize = 0;
        if (oldEvents != null) {
            oldEventsSize = oldEvents.size();
            for (MultiKey<EventBean> event : oldEvents) {
                this.oldEventsSet.add(event);
            }
        }
        this.outputCondition.updateOutputCondition(newEventsSize, oldEventsSize);
    }

    protected void continueOutputProcessingView(boolean doOutput, boolean forceUpdate) {
        EventBean[] oldEvents;
        log.debug(".continueOutputProcessingView");
        EventBean[] newEvents = !this.newEventsList.isEmpty() ? this.newEventsList.toArray(new EventBean[0]) : null;
        EventBean[] eventBeanArray = oldEvents = !this.oldEventsList.isEmpty() ? this.oldEventsList.toArray(new EventBean[0]) : null;
        if (this.resultSetProcessor != null) {
            Pair<EventBean[], EventBean[]> newOldEvents = this.resultSetProcessor.processViewResult(newEvents, oldEvents);
            newEvents = newOldEvents != null ? newOldEvents.getFirst() : null;
            oldEvents = newOldEvents != null ? newOldEvents.getSecond() : null;
        } else if (this.outputLastOnly) {
            EventBean[] eventBeanArray2;
            EventBean[] eventBeanArray3;
            if (newEvents != null) {
                EventBean[] eventBeanArray4 = new EventBean[1];
                eventBeanArray3 = eventBeanArray4;
                eventBeanArray4[0] = newEvents[newEvents.length - 1];
            } else {
                eventBeanArray3 = newEvents = null;
            }
            if (oldEvents != null) {
                EventBean[] eventBeanArray5 = new EventBean[1];
                eventBeanArray2 = eventBeanArray5;
                eventBeanArray5[0] = oldEvents[oldEvents.length - 1];
            } else {
                eventBeanArray2 = oldEvents = null;
            }
        }
        if (this.outputSnapshot) {
            Iterator<EventBean> it = this.iterator();
            if (it.hasNext()) {
                ArrayList<EventBean> snapshot = new ArrayList<EventBean>();
                for (EventBean bean : this) {
                    snapshot.add(bean);
                }
                newEvents = snapshot.toArray(new EventBean[0]);
                oldEvents = null;
            } else {
                newEvents = null;
                oldEvents = null;
            }
        }
        if (doOutput) {
            this.output(forceUpdate, newEvents, oldEvents);
        }
        this.resetEventBatches();
    }

    private void output(boolean forceUpdate, EventBean[] newEvents, EventBean[] oldEvents) {
        if (newEvents != null || oldEvents != null) {
            this.updateChildren(newEvents, oldEvents);
        } else if (forceUpdate) {
            this.updateChildren(null, null);
        }
    }

    private void resetEventBatches() {
        this.newEventsList.clear();
        this.oldEventsList.clear();
        this.newEventsSet.clear();
        this.oldEventsSet.clear();
    }

    protected void continueOutputProcessingJoin(boolean doOutput, boolean forceUpdate) {
        log.debug(".continueOutputProcessingJoin");
        EventBean[] newEvents = null;
        EventBean[] oldEvents = null;
        Pair<EventBean[], EventBean[]> newOldEvents = this.resultSetProcessor.processJoinResult(this.newEventsSet, this.oldEventsSet);
        if (newOldEvents != null) {
            newEvents = newOldEvents.getFirst();
            oldEvents = newOldEvents.getSecond();
        }
        if (doOutput) {
            this.output(forceUpdate, newEvents, oldEvents);
        }
        this.resetEventBatches();
    }

    private OutputCallback getCallbackToLocal(int streamCount) {
        if (streamCount == 1) {
            return new OutputCallback(){

                public void continueOutputProcessing(boolean doOutput, boolean forceUpdate) {
                    OutputProcessViewPolicy.this.continueOutputProcessingView(doOutput, forceUpdate);
                }
            };
        }
        return new OutputCallback(){

            public void continueOutputProcessing(boolean doOutput, boolean forceUpdate) {
                OutputProcessViewPolicy.this.continueOutputProcessingJoin(doOutput, forceUpdate);
            }
        };
    }
}

