/*
 * Decompiled with CFR 0.152.
 */
package net.esper.event;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.esper.client.Configuration;
import net.esper.client.ConfigurationEventTypeLegacy;
import net.esper.event.BeanEventType;
import net.esper.event.BeanEventTypeFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanEventAdapter
implements BeanEventTypeFactory {
    private final ConcurrentHashMap<Class, BeanEventType> typesPerJavaBean;
    private final Lock typesPerJavaBeanLock;
    private Map<String, ConfigurationEventTypeLegacy> classToLegacyConfigs;
    private Configuration.PropertyResolutionStyle defaultPropertyResolutionStyle;

    public BeanEventAdapter(ConcurrentHashMap<Class, BeanEventType> typesPerJavaBean) {
        this.typesPerJavaBean = typesPerJavaBean;
        this.typesPerJavaBeanLock = new ReentrantLock();
        this.classToLegacyConfigs = new HashMap<String, ConfigurationEventTypeLegacy>();
        this.defaultPropertyResolutionStyle = Configuration.PropertyResolutionStyle.getDefault();
    }

    public void setClassToLegacyConfigs(Map<String, ConfigurationEventTypeLegacy> classToLegacyConfigs) {
        this.classToLegacyConfigs.putAll(classToLegacyConfigs);
    }

    public void setDefaultPropertyResolutionStyle(Configuration.PropertyResolutionStyle defaultPropertyResolutionStyle) {
        this.defaultPropertyResolutionStyle = defaultPropertyResolutionStyle;
    }

    @Override
    public Configuration.PropertyResolutionStyle getDefaultPropertyResolutionStyle() {
        return this.defaultPropertyResolutionStyle;
    }

    @Override
    public final BeanEventType createBeanType(String alias, Class clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("Null value passed as class");
        }
        BeanEventType eventType = null;
        this.typesPerJavaBeanLock.lock();
        try {
            eventType = this.typesPerJavaBean.get(clazz);
            if (eventType != null) {
                BeanEventType beanEventType = eventType;
                return beanEventType;
            }
            ConfigurationEventTypeLegacy legacyDef = this.classToLegacyConfigs.get(clazz.getName());
            eventType = new BeanEventType(clazz, this, legacyDef, alias);
            this.typesPerJavaBean.put(clazz, eventType);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        finally {
            this.typesPerJavaBeanLock.unlock();
        }
        return eventType;
    }
}

