/*
 * Decompiled with CFR 0.152.
 */
package net.esper.event;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.esper.client.Configuration;
import net.esper.client.ConfigurationEventTypeLegacy;
import net.esper.client.EPException;
import net.esper.event.BeanEventTypeFactory;
import net.esper.event.EventPropertyDescriptor;
import net.esper.event.EventPropertyGetter;
import net.esper.event.EventPropertyType;
import net.esper.event.EventType;
import net.esper.event.ReflectionPropFieldGetter;
import net.esper.event.property.Property;
import net.esper.event.property.PropertyHelper;
import net.esper.event.property.PropertyListBuilder;
import net.esper.event.property.PropertyListBuilderFactory;
import net.esper.event.property.PropertyParser;
import net.esper.event.property.SimpleProperty;
import net.sf.cglib.reflect.FastClass;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanEventType
implements EventType {
    private final Class clazz;
    private final BeanEventTypeFactory beanEventTypeFactory;
    private final ConfigurationEventTypeLegacy optionalLegacyDef;
    private final String alias;
    private String[] propertyNames;
    private Map<String, SimplePropertyInfo> simpleProperties;
    private Map<String, EventPropertyDescriptor> mappedPropertyDescriptors;
    private Map<String, EventPropertyDescriptor> indexedPropertyDescriptors;
    private EventType[] superTypes;
    private FastClass fastClass;
    private Set<EventType> deepSuperTypes;
    private Configuration.PropertyResolutionStyle propertyResolutionStyle;
    private Map<String, List<SimplePropertyInfo>> simpleSmartPropertyTable;
    private Map<String, List<SimplePropertyInfo>> indexedSmartPropertyTable;
    private Map<String, List<SimplePropertyInfo>> mappedSmartPropertyTable;
    private static final Log log = LogFactory.getLog(BeanEventType.class);

    public BeanEventType(Class clazz, BeanEventTypeFactory beanEventTypeFactory, ConfigurationEventTypeLegacy optionalLegacyDef, String alias) {
        this.clazz = clazz;
        this.beanEventTypeFactory = beanEventTypeFactory;
        this.optionalLegacyDef = optionalLegacyDef;
        this.alias = alias;
        this.propertyResolutionStyle = optionalLegacyDef != null ? optionalLegacyDef.getPropertyResolutionStyle() : beanEventTypeFactory.getDefaultPropertyResolutionStyle();
        this.initialize();
    }

    @Override
    public final Class getPropertyType(String propertyName) {
        SimplePropertyInfo simpleProp = this.getSimplePropertyInfo(propertyName);
        if (simpleProp != null && simpleProp.getClazz() != null) {
            return simpleProp.getClazz();
        }
        Property prop = PropertyParser.parse(propertyName, this.beanEventTypeFactory);
        if (prop instanceof SimpleProperty) {
            return null;
        }
        return prop.getPropertyType(this);
    }

    @Override
    public boolean isProperty(String propertyName) {
        return this.getPropertyType(propertyName) != null;
    }

    @Override
    public final Class getUnderlyingType() {
        return this.clazz;
    }

    public Configuration.PropertyResolutionStyle getPropertyResolutionStyle() {
        return this.propertyResolutionStyle;
    }

    @Override
    public EventPropertyGetter getGetter(String propertyName) {
        SimplePropertyInfo simpleProp = this.getSimplePropertyInfo(propertyName);
        if (simpleProp != null && simpleProp.getter != null) {
            return simpleProp.getGetter();
        }
        Property prop = PropertyParser.parse(propertyName, this.beanEventTypeFactory);
        if (prop instanceof SimpleProperty) {
            return null;
        }
        return prop.getGetter(this);
    }

    public final EventPropertyDescriptor getSimpleProperty(String propertyName) {
        SimplePropertyInfo simpleProp = this.getSimplePropertyInfo(propertyName);
        if (simpleProp != null) {
            return simpleProp.getDescriptor();
        }
        return null;
    }

    public final EventPropertyDescriptor getMappedProperty(String propertyName) {
        List<SimplePropertyInfo> propertyInfos;
        if (this.getPropertyResolutionStyle().equals((Object)Configuration.PropertyResolutionStyle.CASE_SENSITIVE)) {
            return this.mappedPropertyDescriptors.get(propertyName);
        }
        if (this.getPropertyResolutionStyle().equals((Object)Configuration.PropertyResolutionStyle.CASE_INSENSITIVE)) {
            List<SimplePropertyInfo> propertyInfos2 = this.mappedSmartPropertyTable.get(propertyName.toLowerCase());
            return propertyInfos2 != null ? propertyInfos2.get(0).getDescriptor() : null;
        }
        if (this.getPropertyResolutionStyle().equals((Object)Configuration.PropertyResolutionStyle.DISTINCT_CASE_INSENSITIVE) && (propertyInfos = this.mappedSmartPropertyTable.get(propertyName.toLowerCase())) != null) {
            if (propertyInfos.size() != 1) {
                throw new EPException("Unable to determine which property to use for \"" + propertyName + "\" because more than one property matched");
            }
            return propertyInfos.get(0).getDescriptor();
        }
        return null;
    }

    public final EventPropertyDescriptor getIndexedProperty(String propertyName) {
        List<SimplePropertyInfo> propertyInfos;
        if (this.getPropertyResolutionStyle().equals((Object)Configuration.PropertyResolutionStyle.CASE_SENSITIVE)) {
            return this.indexedPropertyDescriptors.get(propertyName);
        }
        if (this.getPropertyResolutionStyle().equals((Object)Configuration.PropertyResolutionStyle.CASE_INSENSITIVE)) {
            List<SimplePropertyInfo> propertyInfos2 = this.indexedSmartPropertyTable.get(propertyName.toLowerCase());
            return propertyInfos2 != null ? propertyInfos2.get(0).getDescriptor() : null;
        }
        if (this.getPropertyResolutionStyle().equals((Object)Configuration.PropertyResolutionStyle.DISTINCT_CASE_INSENSITIVE) && (propertyInfos = this.indexedSmartPropertyTable.get(propertyName.toLowerCase())) != null) {
            if (propertyInfos.size() != 1) {
                throw new EPException("Unable to determine which property to use for \"" + propertyName + "\" because more than one property matched");
            }
            return propertyInfos.get(0).getDescriptor();
        }
        return null;
    }

    @Override
    public String[] getPropertyNames() {
        return this.propertyNames;
    }

    @Override
    public EventType[] getSuperTypes() {
        return this.superTypes;
    }

    @Override
    public Iterator<EventType> getDeepSuperTypes() {
        return this.deepSuperTypes.iterator();
    }

    public String getAlias() {
        return this.alias;
    }

    public FastClass getFastClass() {
        return this.fastClass;
    }

    public String toString() {
        return "BeanEventType clazz=" + this.clazz.getName();
    }

    private void initialize() {
        PropertyListBuilder propertyListBuilder = PropertyListBuilderFactory.createBuilder(this.optionalLegacyDef);
        List<EventPropertyDescriptor> properties = propertyListBuilder.assessProperties(this.clazz);
        this.propertyNames = new String[properties.size()];
        this.simpleProperties = new HashMap<String, SimplePropertyInfo>();
        this.mappedPropertyDescriptors = new HashMap<String, EventPropertyDescriptor>();
        this.indexedPropertyDescriptors = new HashMap<String, EventPropertyDescriptor>();
        if (this.usesSmartResolutionStyle()) {
            this.simpleSmartPropertyTable = new HashMap<String, List<SimplePropertyInfo>>();
            this.mappedSmartPropertyTable = new HashMap<String, List<SimplePropertyInfo>>();
            this.indexedSmartPropertyTable = new HashMap<String, List<SimplePropertyInfo>>();
        }
        if (this.optionalLegacyDef == null || this.optionalLegacyDef.getCodeGeneration() != ConfigurationEventTypeLegacy.CodeGeneration.DISABLED) {
            this.fastClass = null;
            try {
                this.fastClass = FastClass.create(this.clazz);
            }
            catch (Throwable ex) {
                log.warn(".initialize Unable to obtain CGLib fast class and/or method implementation for class " + this.clazz.getName() + ", error msg is " + ex.getMessage());
                this.fastClass = null;
            }
        }
        int count = 0;
        for (EventPropertyDescriptor desc : properties) {
            SimplePropertyInfo propertyInfo;
            List<SimplePropertyInfo> propertyInfoList;
            String smartPropertyName;
            String propertyName = desc.getPropertyName();
            this.propertyNames[count++] = desc.getListedName();
            if (desc.getPropertyType().equals((Object)EventPropertyType.SIMPLE)) {
                Class<?> type;
                EventPropertyGetter getter;
                if (desc.getReadMethod() != null) {
                    getter = PropertyHelper.getGetter(desc.getReadMethod(), this.fastClass);
                    type = desc.getReadMethod().getReturnType();
                } else {
                    if (desc.getAccessorField() == null) continue;
                    getter = new ReflectionPropFieldGetter(desc.getAccessorField());
                    type = desc.getAccessorField().getType();
                }
                this.simpleProperties.put(propertyName, new SimplePropertyInfo(type, getter, desc));
                if (!this.usesSmartResolutionStyle()) continue;
                String smartPropertyName2 = propertyName.toLowerCase();
                List<SimplePropertyInfo> propertyInfoList2 = this.simpleSmartPropertyTable.get(smartPropertyName2);
                if (propertyInfoList2 == null) {
                    propertyInfoList2 = new ArrayList<SimplePropertyInfo>();
                    this.simpleSmartPropertyTable.put(smartPropertyName2, propertyInfoList2);
                }
                SimplePropertyInfo propertyInfo2 = new SimplePropertyInfo(type, getter, desc);
                propertyInfoList2.add(propertyInfo2);
                continue;
            }
            if (desc.getPropertyType().equals((Object)EventPropertyType.MAPPED)) {
                this.mappedPropertyDescriptors.put(propertyName, desc);
                if (!this.usesSmartResolutionStyle()) continue;
                smartPropertyName = propertyName.toLowerCase();
                propertyInfoList = this.mappedSmartPropertyTable.get(smartPropertyName);
                if (propertyInfoList == null) {
                    propertyInfoList = new ArrayList<SimplePropertyInfo>();
                    this.mappedSmartPropertyTable.put(smartPropertyName, propertyInfoList);
                }
                propertyInfo = new SimplePropertyInfo(desc.getReturnType(), null, desc);
                propertyInfoList.add(propertyInfo);
                continue;
            }
            if (!desc.getPropertyType().equals((Object)EventPropertyType.INDEXED)) continue;
            this.indexedPropertyDescriptors.put(propertyName, desc);
            if (!this.usesSmartResolutionStyle()) continue;
            smartPropertyName = propertyName.toLowerCase();
            propertyInfoList = this.indexedSmartPropertyTable.get(smartPropertyName);
            if (propertyInfoList == null) {
                propertyInfoList = new ArrayList<SimplePropertyInfo>();
                this.indexedSmartPropertyTable.put(smartPropertyName, propertyInfoList);
            }
            propertyInfo = new SimplePropertyInfo(desc.getReturnType(), null, desc);
            propertyInfoList.add(propertyInfo);
        }
        this.superTypes = BeanEventType.getSuperTypes(this.clazz, this.beanEventTypeFactory);
        HashSet<Class> supers = new HashSet<Class>();
        BeanEventType.getSuper(this.clazz, supers);
        BeanEventType.removeJavaLibInterfaces(supers);
        this.deepSuperTypes = new HashSet<EventType>();
        for (Class superClass : supers) {
            BeanEventType superType = this.beanEventTypeFactory.createBeanType(superClass.getName(), superClass);
            this.deepSuperTypes.add(superType);
        }
    }

    private static EventType[] getSuperTypes(Class clazz, BeanEventTypeFactory beanEventTypeFactory) {
        LinkedList superclasses = new LinkedList();
        Class superClass = clazz.getSuperclass();
        if (superClass != null) {
            superclasses.add(superClass);
        }
        Class<?>[] interfaces = clazz.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            superclasses.add(interfaces[i]);
        }
        LinkedList<BeanEventType> superTypes = new LinkedList<BeanEventType>();
        for (Class clazz2 : superclasses) {
            if (clazz2.getName().startsWith("java")) continue;
            BeanEventType superType = beanEventTypeFactory.createBeanType(clazz2.getName(), clazz2);
            superTypes.add(superType);
        }
        return superTypes.toArray(new EventType[0]);
    }

    protected static void getSuper(Class clazz, Set<Class> result) {
        BeanEventType.getSuperInterfaces(clazz, result);
        BeanEventType.getSuperClasses(clazz, result);
    }

    private static void getSuperInterfaces(Class clazz, Set<Class> result) {
        Class<?>[] interfaces = clazz.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            result.add(interfaces[i]);
            BeanEventType.getSuperInterfaces(interfaces[i], result);
        }
    }

    private static void getSuperClasses(Class clazz, Set<Class> result) {
        Class superClass = clazz.getSuperclass();
        if (superClass == null) {
            return;
        }
        result.add(superClass);
        BeanEventType.getSuper(superClass, result);
    }

    private static void removeJavaLibInterfaces(Set<Class> classes) {
        for (Class clazz : classes.toArray(new Class[0])) {
            if (!clazz.getName().startsWith("java")) continue;
            classes.remove(clazz);
        }
    }

    private boolean usesSmartResolutionStyle() {
        return this.propertyResolutionStyle.equals((Object)Configuration.PropertyResolutionStyle.CASE_INSENSITIVE) || this.propertyResolutionStyle.equals((Object)Configuration.PropertyResolutionStyle.DISTINCT_CASE_INSENSITIVE);
    }

    private SimplePropertyInfo getSimplePropertyInfo(String propertyName) {
        if (this.getPropertyResolutionStyle().equals((Object)Configuration.PropertyResolutionStyle.CASE_SENSITIVE)) {
            return this.simpleProperties.get(propertyName);
        }
        if (this.getPropertyResolutionStyle().equals((Object)Configuration.PropertyResolutionStyle.CASE_INSENSITIVE)) {
            SimplePropertyInfo propertyInfo = this.simpleProperties.get(propertyName);
            if (propertyInfo != null) {
                return propertyInfo;
            }
            List<SimplePropertyInfo> simplePropertyInfoList = this.simpleSmartPropertyTable.get(propertyName.toLowerCase());
            return simplePropertyInfoList != null ? simplePropertyInfoList.get(0) : null;
        }
        if (this.getPropertyResolutionStyle().equals((Object)Configuration.PropertyResolutionStyle.DISTINCT_CASE_INSENSITIVE)) {
            SimplePropertyInfo propertyInfo = this.simpleProperties.get(propertyName);
            if (propertyInfo != null) {
                return propertyInfo;
            }
            List<SimplePropertyInfo> simplePropertyInfoList = this.simpleSmartPropertyTable.get(propertyName.toLowerCase());
            if (simplePropertyInfoList != null) {
                if (simplePropertyInfoList.size() != 1) {
                    throw new EPException("Unable to determine which property to use for \"" + propertyName + "\" because more than one property matched");
                }
                return simplePropertyInfoList.get(0);
            }
        }
        return null;
    }

    public class SimplePropertyInfo {
        private Class clazz;
        private EventPropertyGetter getter;
        private EventPropertyDescriptor descriptor;

        public SimplePropertyInfo(Class clazz, EventPropertyGetter getter, EventPropertyDescriptor descriptor) {
            this.clazz = clazz;
            this.getter = getter;
            this.descriptor = descriptor;
        }

        public Class getClazz() {
            return this.clazz;
        }

        public EventPropertyGetter getGetter() {
            return this.getter;
        }

        public EventPropertyDescriptor getDescriptor() {
            return this.descriptor;
        }
    }
}

