/*
 * Decompiled with CFR 0.152.
 */
package net.esper.event;

import java.util.Iterator;
import java.util.Map;
import net.esper.event.EventBean;
import net.esper.event.EventPropertyGetter;
import net.esper.event.EventType;
import net.esper.event.PropertyAccessException;
import net.esper.event.TaggedCompositeEventType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeEventType
implements EventType,
TaggedCompositeEventType {
    protected final Map<String, EventType> taggedEventTypes;
    private String alias;

    public CompositeEventType(String alias, Map<String, EventType> taggedEventTypes) {
        this.taggedEventTypes = taggedEventTypes;
        this.alias = alias;
    }

    public String getAlias() {
        return this.alias;
    }

    @Override
    public Class getPropertyType(String propertyName) {
        EventType result = this.taggedEventTypes.get(propertyName);
        if (result != null) {
            return result.getUnderlyingType();
        }
        int index = propertyName.indexOf(46);
        if (index == -1) {
            return null;
        }
        String propertyMap = propertyName.substring(0, index);
        String propertyNested = propertyName.substring(index + 1, propertyName.length());
        result = this.taggedEventTypes.get(propertyMap);
        if (result == null) {
            return null;
        }
        return result.getPropertyType(propertyNested);
    }

    @Override
    public Class getUnderlyingType() {
        return Map.class;
    }

    @Override
    public EventPropertyGetter getGetter(String propertyName) {
        int index = propertyName.indexOf(46);
        if (index == -1) {
            EventType result = this.taggedEventTypes.get(propertyName);
            if (result == null) {
                return null;
            }
            final String tag = propertyName;
            return new EventPropertyGetter(){

                public Object get(EventBean obj) {
                    if (!(obj.getUnderlying() instanceof Map)) {
                        throw new PropertyAccessException("Mismatched property getter to event bean type, the underlying data object is not of type java.lang.Map");
                    }
                    Map map = (Map)obj.getUnderlying();
                    EventBean wrapper = (EventBean)map.get(tag);
                    if (wrapper != null) {
                        return wrapper.getUnderlying();
                    }
                    return null;
                }

                public boolean isExistsProperty(EventBean eventBean) {
                    return true;
                }
            };
        }
        final String propertyMap = propertyName.substring(0, index);
        String propertyNested = propertyName.substring(index + 1, propertyName.length());
        EventType result = this.taggedEventTypes.get(propertyMap);
        if (result == null) {
            return null;
        }
        final EventPropertyGetter getterNested = result.getGetter(propertyNested);
        if (getterNested == null) {
            return null;
        }
        return new EventPropertyGetter(){

            public Object get(EventBean obj) {
                if (!(obj.getUnderlying() instanceof Map)) {
                    throw new PropertyAccessException("Mismatched property getter to event bean type, the underlying data object is not of type java.lang.Map");
                }
                Map map = (Map)obj.getUnderlying();
                EventBean wrapper = (EventBean)map.get(propertyMap);
                if (wrapper != null) {
                    return getterNested.get(wrapper);
                }
                return null;
            }

            public boolean isExistsProperty(EventBean eventBean) {
                return true;
            }
        };
    }

    @Override
    public String[] getPropertyNames() {
        return this.taggedEventTypes.keySet().toArray(new String[0]);
    }

    @Override
    public boolean isProperty(String propertyName) {
        Class propertyType = this.getPropertyType(propertyName);
        return propertyType != null;
    }

    @Override
    public EventType[] getSuperTypes() {
        return null;
    }

    @Override
    public Iterator<EventType> getDeepSuperTypes() {
        return null;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CompositeEventType)) {
            return false;
        }
        CompositeEventType other = (CompositeEventType)obj;
        if (other.taggedEventTypes.size() != this.taggedEventTypes.size()) {
            return false;
        }
        for (Map.Entry<String, EventType> entry : this.taggedEventTypes.entrySet()) {
            EventType composed = entry.getValue();
            EventType otherComposed = other.taggedEventTypes.get(entry.getKey());
            if (otherComposed == null) {
                return false;
            }
            if (composed.equals(otherComposed)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.alias.hashCode();
    }

    @Override
    public Map<String, EventType> getTaggedEventTypes() {
        return this.taggedEventTypes;
    }
}

