/*
 * Decompiled with CFR 0.152.
 */
package net.esper.event;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.esper.client.Configuration;
import net.esper.client.ConfigurationEventTypeLegacy;
import net.esper.client.ConfigurationEventTypeXMLDOM;
import net.esper.client.EPException;
import net.esper.event.BeanEventAdapter;
import net.esper.event.BeanEventBean;
import net.esper.event.BeanEventType;
import net.esper.event.CompositeEventBean;
import net.esper.event.CompositeEventType;
import net.esper.event.EventAdapterException;
import net.esper.event.EventAdapterService;
import net.esper.event.EventBean;
import net.esper.event.EventType;
import net.esper.event.MapEventBean;
import net.esper.event.MapEventType;
import net.esper.event.WrapperEventBean;
import net.esper.event.WrapperEventType;
import net.esper.event.xml.BaseXMLEventType;
import net.esper.event.xml.SchemaXMLEventType;
import net.esper.event.xml.SimpleXMLEventType;
import net.esper.event.xml.XMLEventBean;
import net.esper.util.UuidGenerator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventAdapterServiceImpl
implements EventAdapterService {
    private static Log log = LogFactory.getLog(EventAdapterServiceImpl.class);
    private final ConcurrentHashMap<Class, BeanEventType> typesPerJavaBean;
    private final Map<String, EventType> aliasToTypeMap = new HashMap<String, EventType>();
    private BeanEventAdapter beanEventAdapter;
    private Map<String, EventType> xmldomRootElementNames = new HashMap<String, EventType>();
    private LinkedHashSet<String> javaPackageNames = new LinkedHashSet();

    public EventAdapterServiceImpl() {
        this.typesPerJavaBean = new ConcurrentHashMap();
        this.beanEventAdapter = new BeanEventAdapter(this.typesPerJavaBean);
    }

    @Override
    public void setClassLegacyConfigs(Map<String, ConfigurationEventTypeLegacy> classToLegacyConfigs) {
        this.beanEventAdapter.setClassToLegacyConfigs(classToLegacyConfigs);
    }

    @Override
    public void setDefaultPropertyResolutionStyle(Configuration.PropertyResolutionStyle defaultPropertyResolutionStyle) {
        this.beanEventAdapter.setDefaultPropertyResolutionStyle(defaultPropertyResolutionStyle);
    }

    @Override
    public EventType getExistsTypeByAlias(String eventTypeAlias) {
        if (eventTypeAlias == null) {
            throw new IllegalStateException("Null event type alias parameter");
        }
        return this.aliasToTypeMap.get(eventTypeAlias);
    }

    @Override
    public synchronized EventType addBeanType(String eventTypeAlias, Class clazz) throws EventAdapterException {
        EventType existingType;
        if (log.isDebugEnabled()) {
            log.debug(".addBeanType Adding " + eventTypeAlias + " for type " + clazz.getName());
        }
        if ((existingType = this.aliasToTypeMap.get(eventTypeAlias)) != null) {
            if (existingType.getUnderlyingType().equals(clazz)) {
                return existingType;
            }
            throw new EventAdapterException("Event type named '" + eventTypeAlias + "' has already been declared with differing column name or type information");
        }
        BeanEventType eventType = this.beanEventAdapter.createBeanType(eventTypeAlias, clazz);
        this.aliasToTypeMap.put(eventTypeAlias, eventType);
        return eventType;
    }

    @Override
    public EventBean adapterForBean(Object event) {
        EventType eventType = this.typesPerJavaBean.get(event.getClass());
        if (eventType == null) {
            eventType = this.beanEventAdapter.createBeanType(event.getClass().getName(), event.getClass());
        }
        return new BeanEventBean(event, eventType);
    }

    @Override
    public synchronized EventType addBeanType(String eventTypeAlias, String fullyQualClassName, boolean considerAutoAlias) throws EventAdapterException {
        Class<?> clazz;
        block11: {
            EventType existingType;
            if (log.isDebugEnabled()) {
                log.debug(".addBeanType Adding " + eventTypeAlias + " for type " + fullyQualClassName);
            }
            if ((existingType = this.aliasToTypeMap.get(eventTypeAlias)) != null) {
                if (existingType.getUnderlyingType().getName().equals(fullyQualClassName)) {
                    if (log.isDebugEnabled()) {
                        log.debug(".addBeanType Returning existing type for " + eventTypeAlias);
                    }
                    return existingType;
                }
                throw new EventAdapterException("Event type named '" + eventTypeAlias + "' has already been declared with differing column name or type information");
            }
            clazz = null;
            try {
                clazz = Class.forName(fullyQualClassName);
            }
            catch (ClassNotFoundException ex) {
                if (!considerAutoAlias) {
                    throw new EventAdapterException("Failed to load class " + fullyQualClassName, ex);
                }
                for (String javaPackageName : this.javaPackageNames) {
                    String generatedClassName = javaPackageName + "." + fullyQualClassName;
                    try {
                        Class<?> resolvedClass = Class.forName(generatedClassName);
                        if (clazz != null) {
                            throw new EventAdapterException("Failed to resolve alias '" + eventTypeAlias + "', the class was ambigously found both in " + "package '" + clazz.getPackage().getName() + "' and in " + "package '" + resolvedClass.getPackage().getName() + "'", ex);
                        }
                        clazz = resolvedClass;
                    }
                    catch (ClassNotFoundException ex1) {}
                }
                if (clazz != null) break block11;
                throw new EventAdapterException("Failed to load class " + fullyQualClassName, ex);
            }
        }
        BeanEventType eventType = this.beanEventAdapter.createBeanType(eventTypeAlias, clazz);
        this.aliasToTypeMap.put(eventTypeAlias, eventType);
        return eventType;
    }

    @Override
    public synchronized EventType addMapType(String eventTypeAlias, Map<String, Class> propertyTypes) throws EventAdapterException {
        MapEventType newEventType = new MapEventType(eventTypeAlias, propertyTypes, this);
        EventType existingType = this.aliasToTypeMap.get(eventTypeAlias);
        if (existingType != null) {
            if (!newEventType.equals(existingType)) {
                throw new EventAdapterException("Event type named '" + eventTypeAlias + "' has already been declared with differing column name or type information");
            }
            return existingType;
        }
        this.aliasToTypeMap.put(eventTypeAlias, newEventType);
        return newEventType;
    }

    @Override
    public EventBean adapterForMap(Map event, String eventTypeAlias) throws EventAdapterException {
        EventType existingType = this.aliasToTypeMap.get(eventTypeAlias);
        if (existingType == null) {
            throw new EventAdapterException("Event type alias '" + eventTypeAlias + "' has not been defined");
        }
        Map eventMap = event;
        return this.createMapFromValues(eventMap, existingType);
    }

    @Override
    public EventBean adapterForDOM(Node node) {
        EventType eventType;
        Node namedNode = null;
        if (node instanceof Document) {
            namedNode = ((Document)node).getDocumentElement();
        } else if (node instanceof Element) {
            namedNode = node;
        } else {
            throw new EPException("Unexpected DOM node of type '" + node.getClass() + "' encountered, please supply a Document or Element node");
        }
        String rootElementName = namedNode.getLocalName();
        if (rootElementName == null) {
            rootElementName = namedNode.getNodeName();
        }
        if ((eventType = this.xmldomRootElementNames.get(rootElementName)) == null) {
            throw new EventAdapterException("DOM event root element name '" + rootElementName + "' has not been configured");
        }
        return new XMLEventBean(node, eventType);
    }

    @Override
    public synchronized EventType addXMLDOMType(String eventTypeAlias, ConfigurationEventTypeXMLDOM configurationEventTypeXMLDOM) {
        if (configurationEventTypeXMLDOM.getRootElementName() == null) {
            throw new EventAdapterException("Required root element name has not been supplied");
        }
        EventType existingType = this.aliasToTypeMap.get(eventTypeAlias);
        if (existingType != null) {
            String message = "Event type named '" + eventTypeAlias + "' has already been declared with differing column name or type information";
            if (!(existingType instanceof BaseXMLEventType)) {
                throw new EventAdapterException(message);
            }
            ConfigurationEventTypeXMLDOM config = ((BaseXMLEventType)existingType).getConfigurationEventTypeXMLDOM();
            if (!config.equals(configurationEventTypeXMLDOM)) {
                throw new EventAdapterException(message);
            }
            return existingType;
        }
        BaseXMLEventType type = configurationEventTypeXMLDOM.getSchemaResource() == null ? new SimpleXMLEventType(configurationEventTypeXMLDOM) : new SchemaXMLEventType(configurationEventTypeXMLDOM);
        this.aliasToTypeMap.put(eventTypeAlias, type);
        this.xmldomRootElementNames.put(configurationEventTypeXMLDOM.getRootElementName(), type);
        return type;
    }

    @Override
    public final EventBean createMapFromValues(Map<String, Object> properties, EventType eventType) {
        return new MapEventBean(properties, eventType);
    }

    @Override
    public synchronized EventType addWrapperType(String eventTypeAlias, EventType underlyingEventType, Map<String, Class> propertyTypes) throws EventAdapterException {
        if (underlyingEventType instanceof WrapperEventType) {
            WrapperEventType underlyingWrapperType = (WrapperEventType)underlyingEventType;
            underlyingEventType = underlyingWrapperType.getUnderlyingEventType();
            HashMap<String, Class> propertiesSuperset = new HashMap<String, Class>();
            propertiesSuperset.putAll(underlyingWrapperType.getUnderlyingMapType().getTypes());
            propertiesSuperset.putAll(propertyTypes);
            propertyTypes = propertiesSuperset;
        }
        WrapperEventType newEventType = new WrapperEventType(eventTypeAlias, underlyingEventType, propertyTypes, this);
        EventType existingType = this.aliasToTypeMap.get(eventTypeAlias);
        if (existingType != null) {
            if (!newEventType.equals(existingType)) {
                if (EventAdapterServiceImpl.isCompatibleWrapper(existingType, underlyingEventType, propertyTypes)) {
                    return existingType;
                }
                throw new EventAdapterException("Event type named '" + eventTypeAlias + "' has already been declared with differing column name or type information");
            }
            return existingType;
        }
        this.aliasToTypeMap.put(eventTypeAlias, newEventType);
        return newEventType;
    }

    public static boolean isCompatibleWrapper(EventType existingType, EventType underlyingType, Map<String, Class> propertyTypes) {
        if (!(existingType instanceof WrapperEventType)) {
            return false;
        }
        WrapperEventType existingWrapper = (WrapperEventType)existingType;
        if (!MapEventType.isEqualsProperties(existingWrapper.getUnderlyingMapType().getTypes(), propertyTypes)) {
            return false;
        }
        EventType existingUnderlyingType = existingWrapper.getUnderlyingEventType();
        if (underlyingType.getSuperTypes() == null) {
            return false;
        }
        for (EventType superUnderlying : underlyingType.getSuperTypes()) {
            if (superUnderlying != existingUnderlyingType) continue;
            return true;
        }
        return false;
    }

    @Override
    public final EventType createAnonymousMapType(Map<String, Class> propertyTypes) throws EventAdapterException {
        String alias = UuidGenerator.generate(propertyTypes);
        return new MapEventType(alias, propertyTypes, this);
    }

    @Override
    public final EventType createAnonymousWrapperType(EventType underlyingEventType, Map<String, Class> propertyTypes) throws EventAdapterException {
        String alias = UuidGenerator.generate(propertyTypes);
        return new WrapperEventType(alias, underlyingEventType, propertyTypes, this);
    }

    @Override
    public final EventType createAddToEventType(EventType originalType, String[] fieldNames, Class[] fieldTypes) {
        HashMap<String, Class> types = new HashMap<String, Class>();
        for (String property : originalType.getPropertyNames()) {
            types.put(property, originalType.getPropertyType(property));
        }
        for (int i = 0; i < fieldNames.length; ++i) {
            types.put(fieldNames[i], fieldTypes[i]);
        }
        return this.createAnonymousMapType(types);
    }

    @Override
    public final EventType createAnonymousCompositeType(Map<String, EventType> taggedEventTypes) {
        String alias = UuidGenerator.generate(taggedEventTypes);
        return new CompositeEventType(alias, taggedEventTypes);
    }

    @Override
    public final EventBean createWrapper(EventBean event, Map<String, Object> properties, EventType eventType) {
        if (event instanceof WrapperEventBean) {
            WrapperEventBean wrapper = (WrapperEventBean)event;
            properties.putAll(wrapper.getDecoratingProperties());
            return new WrapperEventBean(wrapper.getUnderlyingEvent(), properties, eventType);
        }
        return new WrapperEventBean(event, properties, eventType);
    }

    @Override
    public final EventBean adapterForCompositeEvent(EventType eventType, Map<String, EventBean> taggedEvents) {
        return new CompositeEventBean(taggedEvents, eventType);
    }

    @Override
    public void addAutoAliasPackage(String javaPackageName) {
        this.javaPackageNames.add(javaPackageName);
    }
}

