/*
 * Decompiled with CFR 0.152.
 */
package net.esper.event;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import net.esper.collection.MultiKey;
import net.esper.collection.MultiKeyUntyped;
import net.esper.collection.UniformPair;
import net.esper.event.EventBean;
import net.esper.event.EventPropertyGetter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventBeanUtility {
    public static EventBean[] flatten(List<EventBean[]> eventVector) {
        if (eventVector.isEmpty()) {
            return null;
        }
        if (eventVector.size() == 1) {
            return eventVector.get(0);
        }
        int totalElements = 0;
        for (EventBean[] arr : eventVector) {
            if (arr == null) continue;
            totalElements += arr.length;
        }
        if (totalElements == 0) {
            return null;
        }
        EventBean[] result = new EventBean[totalElements];
        int destPos = 0;
        for (EventBean[] arr : eventVector) {
            if (arr == null) continue;
            System.arraycopy(arr, 0, result, destPos, arr.length);
            destPos += arr.length;
        }
        return result;
    }

    public static UniformPair<EventBean[]> flattenBatchStream(List<UniformPair<EventBean[]>> updateVector) {
        if (updateVector.isEmpty()) {
            return new UniformPair<Object>(null, null);
        }
        if (updateVector.size() == 1) {
            return new UniformPair<EventBean[]>(updateVector.get(0).getFirst(), updateVector.get(0).getSecond());
        }
        int totalNewEvents = 0;
        int totalOldEvents = 0;
        for (UniformPair<EventBean[]> pair : updateVector) {
            if (pair.getFirst() != null) {
                totalNewEvents += pair.getFirst().length;
            }
            if (pair.getSecond() == null) continue;
            totalOldEvents += pair.getSecond().length;
        }
        if (totalNewEvents == 0 && totalOldEvents == 0) {
            return new UniformPair<Object>(null, null);
        }
        EventBean[] newEvents = null;
        EventBean[] oldEvents = null;
        if (totalNewEvents != 0) {
            newEvents = new EventBean[totalNewEvents];
        }
        if (totalOldEvents != 0) {
            oldEvents = new EventBean[totalOldEvents];
        }
        int destPosNew = 0;
        int destPosOld = 0;
        for (UniformPair<EventBean[]> pair : updateVector) {
            EventBean[] newData = pair.getFirst();
            EventBean[] oldData = pair.getSecond();
            if (newData != null) {
                int newDataLen = newData.length;
                System.arraycopy(newData, 0, newEvents, destPosNew, newDataLen);
                destPosNew += newDataLen;
            }
            if (oldData == null) continue;
            int oldDataLen = oldData.length;
            System.arraycopy(oldData, 0, oldEvents, destPosOld, oldDataLen);
            destPosOld += oldDataLen;
        }
        return new UniformPair<EventBean[]>(newEvents, oldEvents);
    }

    protected static EventBean[] append(EventBean[] source, EventBean[] append) {
        EventBean[] result = new EventBean[source.length + append.length];
        System.arraycopy(source, 0, result, 0, source.length);
        System.arraycopy(append, 0, result, source.length, append.length);
        return result;
    }

    public static EventBean[] toArray(List<EventBean> eventList) {
        if (eventList == null || eventList.isEmpty()) {
            return null;
        }
        return eventList.toArray(new EventBean[0]);
    }

    public static Object[] getPropertyArray(EventBean event, EventPropertyGetter[] propertyGetters) {
        Object[] keyValues = new Object[propertyGetters.length];
        for (int i = 0; i < propertyGetters.length; ++i) {
            keyValues[i] = propertyGetters[i].get(event);
        }
        return keyValues;
    }

    public static MultiKeyUntyped getMultiKey(EventBean event, EventPropertyGetter[] propertyGetters) {
        Object[] keyValues = EventBeanUtility.getPropertyArray(event, propertyGetters);
        return new MultiKeyUntyped(keyValues);
    }

    public static String printEvent(EventBean event) {
        StringWriter writer = new StringWriter();
        PrintWriter buf = new PrintWriter(writer);
        EventBeanUtility.printEvent(buf, event);
        return writer.toString();
    }

    private static void printEvent(PrintWriter writer, EventBean event) {
        String[] properties = event.getEventType().getPropertyNames();
        for (int i = 0; i < properties.length; ++i) {
            writer.println("#" + i + "  " + properties[i] + " = " + event.get(properties[i]));
        }
    }

    public static UniformPair<Set<MultiKey<EventBean>>> flattenBatchJoin(List<UniformPair<Set<MultiKey<EventBean>>>> joinPostings) {
        if (joinPostings.isEmpty()) {
            return new UniformPair<Object>(null, null);
        }
        if (joinPostings.size() == 1) {
            return new UniformPair<Set<MultiKey<EventBean>>>(joinPostings.get(0).getFirst(), joinPostings.get(0).getSecond());
        }
        LinkedHashSet<MultiKey<EventBean>> newEvents = new LinkedHashSet<MultiKey<EventBean>>();
        LinkedHashSet<MultiKey<EventBean>> oldEvents = new LinkedHashSet<MultiKey<EventBean>>();
        for (UniformPair<Set<MultiKey<EventBean>>> pair : joinPostings) {
            Set<MultiKey<EventBean>> newData = pair.getFirst();
            Set<MultiKey<EventBean>> oldData = pair.getSecond();
            if (newData != null) {
                newEvents.addAll(newData);
            }
            if (oldData == null) continue;
            oldEvents.addAll(oldData);
        }
        return new UniformPair<Set<MultiKey<EventBean>>>(newEvents, oldEvents);
    }
}

