/*
 * Decompiled with CFR 0.152.
 */
package net.esper.event;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import net.esper.event.EventPropertyType;

public class EventPropertyDescriptor {
    private String propertyName;
    private String listedName;
    private Method readMethod;
    private Field accessorField;
    private EventPropertyType propertyType;

    public EventPropertyDescriptor(String propertyName, String listedName, Method readMethod, EventPropertyType propertyType) {
        this.propertyName = propertyName;
        this.listedName = listedName;
        this.readMethod = readMethod;
        this.propertyType = propertyType;
    }

    public EventPropertyDescriptor(String propertyName, String listedName, Field accessorField, EventPropertyType propertyType) {
        this.propertyName = propertyName;
        this.listedName = listedName;
        this.accessorField = accessorField;
        this.propertyType = propertyType;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public String getListedName() {
        return this.listedName;
    }

    public EventPropertyType getPropertyType() {
        return this.propertyType;
    }

    public Method getReadMethod() {
        return this.readMethod;
    }

    public Field getAccessorField() {
        return this.accessorField;
    }

    public Class getReturnType() {
        if (this.readMethod != null) {
            return this.readMethod.getReturnType();
        }
        return this.accessorField.getType();
    }

    public String toString() {
        return "propertyName=" + this.propertyName + " listedName=" + this.listedName + " readMethod=" + this.readMethod + " accessorField=" + this.accessorField + " propertyType=" + (Object)((Object)this.propertyType);
    }

    public boolean equals(Object other) {
        if (!(other instanceof EventPropertyDescriptor)) {
            return false;
        }
        EventPropertyDescriptor otherDesc = (EventPropertyDescriptor)other;
        if (!otherDesc.propertyName.equals(this.propertyName)) {
            return false;
        }
        if (!otherDesc.listedName.equals(this.listedName)) {
            return false;
        }
        if (otherDesc.readMethod == null && this.readMethod != null || otherDesc.readMethod != null && this.readMethod == null) {
            return false;
        }
        if (otherDesc.readMethod != null && this.readMethod != null && !otherDesc.readMethod.equals(this.readMethod)) {
            return false;
        }
        if (otherDesc.accessorField == null && this.accessorField != null || otherDesc.accessorField != null && this.accessorField == null) {
            return false;
        }
        if (otherDesc.accessorField != null && this.accessorField != null && !otherDesc.accessorField.equals(this.accessorField)) {
            return false;
        }
        return otherDesc.propertyType == this.propertyType;
    }

    public int hashCode() {
        return this.propertyName.hashCode();
    }
}

