/*
 * Decompiled with CFR 0.152.
 */
package net.esper.event;

import java.util.HashMap;
import java.util.Map;
import net.esper.event.EventBean;
import net.esper.event.EventPropertyGetter;
import net.esper.event.EventType;
import net.esper.event.PropertyAccessException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapEventBean
implements EventBean {
    private EventType eventType;
    private Map<String, Object> properties = new HashMap<String, Object>();

    public MapEventBean(Map<String, Object> properties, EventType eventType) {
        this.properties.putAll(properties);
        this.eventType = eventType;
    }

    public MapEventBean(EventType eventType, Map<String, EventBean> events) {
        for (Map.Entry<String, EventBean> entry : events.entrySet()) {
            this.properties.put(entry.getKey(), entry.getValue().getUnderlying());
        }
        this.eventType = eventType;
    }

    public MapEventBean(EventType eventType) {
        this.eventType = eventType;
    }

    @Override
    public EventType getEventType() {
        return this.eventType;
    }

    @Override
    public Object get(String property) throws IllegalArgumentException, PropertyAccessException {
        EventPropertyGetter getter = this.eventType.getGetter(property);
        if (getter == null) {
            throw new IllegalArgumentException("Property named '" + property + "' is not a valid property name for this type");
        }
        return this.eventType.getGetter(property).get(this);
    }

    @Override
    public Object getUnderlying() {
        return this.properties;
    }

    public String toString() {
        return "MapEventBean eventType=" + this.eventType;
    }
}

