/*
 * Decompiled with CFR 0.152.
 */
package net.esper.event;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.esper.event.EventAdapterService;
import net.esper.event.EventBean;
import net.esper.event.EventPropertyGetter;
import net.esper.event.EventType;
import net.esper.event.PropertyAccessException;
import net.esper.event.property.DynamicProperty;
import net.esper.event.property.MapPropertyGetter;
import net.esper.event.property.Property;
import net.esper.event.property.PropertyParser;
import net.esper.util.JavaClassHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapEventType
implements EventType {
    private final String typeName;
    private final String[] propertyNames;
    private final Map<String, Class> types;
    private Map<String, EventPropertyGetter> propertyGetters;
    private int hashCode;
    private EventAdapterService eventAdapterService;

    public MapEventType(String typeName, Map<String, Class> propertyTypes, EventAdapterService eventAdapterService) {
        this.typeName = typeName;
        this.eventAdapterService = eventAdapterService;
        this.types = new HashMap<String, Class>();
        this.types.putAll(propertyTypes);
        this.hashCode = typeName.hashCode();
        this.propertyNames = new String[this.types.size()];
        this.propertyGetters = new HashMap<String, EventPropertyGetter>();
        int index = 0;
        for (Map.Entry<String, Class> entry : this.types.entrySet()) {
            final String name = entry.getKey();
            this.hashCode ^= name.hashCode();
            this.propertyNames[index++] = name;
            EventPropertyGetter getter = new EventPropertyGetter(){

                public Object get(EventBean obj) {
                    if (!(obj.getUnderlying() instanceof Map)) {
                        throw new PropertyAccessException("Mismatched property getter to event bean type, the underlying data object is not of type java.lang.Map");
                    }
                    Map map = (Map)obj.getUnderlying();
                    return map.get(name);
                }

                public boolean isExistsProperty(EventBean eventBean) {
                    return true;
                }
            };
            this.propertyGetters.put(name, getter);
        }
    }

    @Override
    public final Class getPropertyType(String propertyName) {
        Class result = this.types.get(propertyName);
        if (result != null) {
            return result;
        }
        int index = propertyName.indexOf(46);
        if (index == -1) {
            if (propertyName.endsWith("?")) {
                return Object.class;
            }
            return null;
        }
        String propertyMap = propertyName.substring(0, index);
        String propertyNested = propertyName.substring(index + 1, propertyName.length());
        result = this.types.get(propertyMap);
        if (result == null) {
            return null;
        }
        if (result == Map.class) {
            Property prop = PropertyParser.parse(propertyNested, null);
            return prop.getPropertyTypeMap();
        }
        EventType nestedType = this.eventAdapterService.addBeanType(result.getName(), result);
        return nestedType.getPropertyType(propertyNested);
    }

    @Override
    public final Class getUnderlyingType() {
        return Map.class;
    }

    @Override
    public EventPropertyGetter getGetter(String propertyName) {
        EventPropertyGetter getter = this.propertyGetters.get(propertyName);
        if (getter != null) {
            return getter;
        }
        int index = propertyName.indexOf(46);
        if (index == -1) {
            Property prop = PropertyParser.parse(propertyName, null);
            if (prop instanceof DynamicProperty) {
                return prop.getGetterMap();
            }
            return null;
        }
        final String propertyMap = propertyName.substring(0, index);
        String propertyNested = propertyName.substring(index + 1, propertyName.length());
        Class result = this.types.get(propertyMap);
        if (result == null) {
            return null;
        }
        if (result == Map.class) {
            Property prop = PropertyParser.parse(propertyNested, null);
            EventPropertyGetter getterNestedMap = prop.getGetterMap();
            if (getterNestedMap == null) {
                return null;
            }
            return new MapPropertyGetter(propertyMap, getterNestedMap);
        }
        EventType nestedType = this.eventAdapterService.addBeanType(result.getName(), result);
        final EventPropertyGetter nestedGetter = nestedType.getGetter(propertyNested);
        if (nestedGetter == null) {
            return null;
        }
        getter = new EventPropertyGetter(){

            public Object get(EventBean obj) {
                Object underlying = obj.getUnderlying();
                if (!(underlying instanceof Map)) {
                    throw new PropertyAccessException("Mismatched property getter to event bean type, the underlying data object is not of type java.lang.Map");
                }
                Map map = (Map)underlying;
                Object value = map.get(propertyMap);
                if (value == null) {
                    return null;
                }
                EventBean event = MapEventType.this.eventAdapterService.adapterForBean(value);
                return nestedGetter.get(event);
            }

            public boolean isExistsProperty(EventBean eventBean) {
                return true;
            }
        };
        return getter;
    }

    public Object getValue(String propertyName, Map values) {
        if (this.types.get(propertyName) != null) {
            return values.get(propertyName);
        }
        int index = propertyName.indexOf(46);
        if (index == -1) {
            return null;
        }
        String propertyMap = propertyName.substring(0, index);
        String propertyNested = propertyName.substring(index + 1, propertyName.length());
        Class result = this.types.get(propertyMap);
        if (result == null) {
            return null;
        }
        EventType nestedType = this.eventAdapterService.addBeanType(result.getName(), result);
        EventPropertyGetter nestedGetter = nestedType.getGetter(propertyNested);
        if (nestedGetter == null) {
            return null;
        }
        Object value = values.get(propertyMap);
        if (value == null) {
            return null;
        }
        EventBean event = this.eventAdapterService.adapterForBean(value);
        return nestedGetter.get(event);
    }

    @Override
    public String[] getPropertyNames() {
        return this.propertyNames;
    }

    @Override
    public boolean isProperty(String propertyName) {
        Class propertyType = this.getPropertyType(propertyName);
        if (propertyType == null && this.types.containsKey(propertyName)) {
            return true;
        }
        return propertyType != null;
    }

    @Override
    public EventType[] getSuperTypes() {
        return null;
    }

    @Override
    public Iterator<EventType> getDeepSuperTypes() {
        return null;
    }

    public String toString() {
        return "MapEventType typeName=" + this.typeName + " propertyNames=" + Arrays.toString(this.propertyNames);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MapEventType)) {
            return false;
        }
        MapEventType other = (MapEventType)obj;
        if (!other.typeName.equals(this.typeName)) {
            return false;
        }
        return MapEventType.isEqualsProperties(other.types, this.types);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String getAlias() {
        return this.typeName;
    }

    public Map<String, Class> getTypes() {
        return this.types;
    }

    public static boolean isEqualsProperties(Map<String, Class> setOne, Map<String, Class> setTwo) {
        if (setOne.size() != setTwo.size()) {
            return false;
        }
        for (Map.Entry<String, Class> entry : setOne.entrySet()) {
            Class boxedThis;
            Class boxedOther;
            Class otherClass = setTwo.get(entry.getKey());
            Class thisClass = entry.getValue();
            if (otherClass == null && thisClass != null || otherClass != null && thisClass == null) {
                return false;
            }
            if (otherClass == null || (boxedOther = JavaClassHelper.getBoxedType(otherClass)).equals(boxedThis = JavaClassHelper.getBoxedType(thisClass))) continue;
            return false;
        }
        return true;
    }
}

