/*
 * Decompiled with CFR 0.152.
 */
package net.esper.event;

import java.util.Map;
import net.esper.collection.Pair;
import net.esper.event.DecoratingEventBean;
import net.esper.event.EventBean;
import net.esper.event.EventPropertyGetter;
import net.esper.event.EventType;
import net.esper.event.PropertyAccessException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WrapperEventBean
implements EventBean,
DecoratingEventBean {
    private final EventBean event;
    private final Map<String, Object> map;
    private final EventType eventType;

    public WrapperEventBean(EventBean event, Map<String, Object> properties, EventType eventType) {
        this.event = event;
        this.map = properties;
        this.eventType = eventType;
    }

    @Override
    public Object get(String property) throws PropertyAccessException {
        EventPropertyGetter getter = this.eventType.getGetter(property);
        if (getter == null) {
            throw new IllegalArgumentException("Property named '" + property + "' is not a valid property name for this type");
        }
        return this.eventType.getGetter(property).get(this);
    }

    @Override
    public EventType getEventType() {
        return this.eventType;
    }

    @Override
    public Object getUnderlying() {
        if (this.map.isEmpty()) {
            return this.event.getUnderlying();
        }
        return new Pair<Object, Map<String, Object>>(this.event.getUnderlying(), this.map);
    }

    public Map getUnderlyingMap() {
        return this.map;
    }

    @Override
    public Map<String, Object> getDecoratingProperties() {
        return this.map;
    }

    public EventBean getUnderlyingEvent() {
        return this.event;
    }

    public String toString() {
        return "WrapperEventBean [event=" + this.event + "] " + "[properties=" + this.map + "]";
    }
}

