/*
 * Decompiled with CFR 0.152.
 */
package net.esper.event;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import net.esper.client.EPException;
import net.esper.collection.Pair;
import net.esper.event.EventAdapterService;
import net.esper.event.EventBean;
import net.esper.event.EventPropertyGetter;
import net.esper.event.EventType;
import net.esper.event.MapEventType;
import net.esper.event.PropertyAccessException;
import net.esper.event.WrapperEventBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WrapperEventType
implements EventType {
    protected final EventType underlyingEventType;
    protected final MapEventType underlyingMapType;
    private final String[] propertyNames;
    private final int hashCode;
    private final boolean isNoMapProperties;
    private final String typeName;

    public WrapperEventType(String typeName, EventType eventType, Map<String, Class> properties, EventAdapterService eventAdapterService) {
        this.checkForRepeatedPropertyNames(eventType, properties);
        this.underlyingEventType = eventType;
        this.underlyingMapType = new MapEventType(typeName, properties, eventAdapterService);
        this.hashCode = this.underlyingMapType.hashCode() ^ this.underlyingEventType.hashCode();
        this.isNoMapProperties = properties.isEmpty();
        ArrayList<String> propertyNames = new ArrayList<String>();
        for (String eventProperty : this.underlyingEventType.getPropertyNames()) {
            propertyNames.add(eventProperty);
        }
        for (String mapProperty : this.underlyingMapType.getPropertyNames()) {
            propertyNames.add(mapProperty);
        }
        this.propertyNames = propertyNames.toArray(new String[0]);
        this.typeName = typeName;
    }

    @Override
    public Iterator<EventType> getDeepSuperTypes() {
        return null;
    }

    public String getAlias() {
        return this.typeName;
    }

    @Override
    public EventPropertyGetter getGetter(final String property) {
        if (this.underlyingEventType.isProperty(property)) {
            return new EventPropertyGetter(){

                public Object get(EventBean event) {
                    if (!(event instanceof WrapperEventBean)) {
                        throw new PropertyAccessException("Mismatched property getter to EventBean type");
                    }
                    WrapperEventBean wrapperEvent = (WrapperEventBean)event;
                    EventBean wrappedEvent = wrapperEvent.getUnderlyingEvent();
                    EventPropertyGetter underlyingGetter = WrapperEventType.this.underlyingEventType.getGetter(property);
                    return underlyingGetter.get(wrappedEvent);
                }

                public boolean isExistsProperty(EventBean eventBean) {
                    return true;
                }
            };
        }
        if (this.underlyingMapType.isProperty(property)) {
            return new EventPropertyGetter(){

                public Object get(EventBean event) {
                    if (!(event instanceof WrapperEventBean)) {
                        throw new PropertyAccessException("Mismatched property getter to EventBean type");
                    }
                    WrapperEventBean wrapperEvent = (WrapperEventBean)event;
                    Map map = wrapperEvent.getUnderlyingMap();
                    return WrapperEventType.this.underlyingMapType.getValue(property, map);
                }

                public boolean isExistsProperty(EventBean eventBean) {
                    return true;
                }
            };
        }
        return null;
    }

    @Override
    public String[] getPropertyNames() {
        return this.propertyNames;
    }

    @Override
    public Class getPropertyType(String property) {
        if (this.underlyingEventType.isProperty(property)) {
            return this.underlyingEventType.getPropertyType(property);
        }
        if (this.underlyingMapType.isProperty(property)) {
            return this.underlyingMapType.getPropertyType(property);
        }
        return null;
    }

    @Override
    public EventType[] getSuperTypes() {
        return null;
    }

    @Override
    public Class getUnderlyingType() {
        if (this.isNoMapProperties) {
            return this.underlyingEventType.getUnderlyingType();
        }
        return Pair.class;
    }

    public EventType getUnderlyingEventType() {
        return this.underlyingEventType;
    }

    public MapEventType getUnderlyingMapType() {
        return this.underlyingMapType;
    }

    @Override
    public boolean isProperty(String property) {
        return this.underlyingEventType.isProperty(property) || this.underlyingMapType.isProperty(property);
    }

    public String toString() {
        return "WrapperEventType underlyingEventType=" + this.underlyingEventType + " " + "underlyingMapType=" + this.underlyingMapType;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof WrapperEventType)) {
            return false;
        }
        WrapperEventType other = (WrapperEventType)obj;
        return other.underlyingEventType.equals(this.underlyingEventType) && other.underlyingMapType.equals(this.underlyingMapType);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private void checkForRepeatedPropertyNames(EventType eventType, Map<String, Class> properties) {
        for (String property : eventType.getPropertyNames()) {
            if (!properties.keySet().contains(property)) continue;
            throw new EPException("Property " + property + " occurs in both the underlying event and in the additional properties");
        }
    }
}

