/*
 * Decompiled with CFR 0.152.
 */
package net.esper.event.property;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import net.esper.event.EventBean;
import net.esper.event.EventPropertyGetter;
import net.esper.event.PropertyAccessException;
import net.sf.cglib.reflect.FastMethod;

public class ArrayFastPropertyGetter
implements EventPropertyGetter {
    private final FastMethod fastMethod;
    private final int index;

    public ArrayFastPropertyGetter(FastMethod fastMethod, int index) {
        this.index = index;
        this.fastMethod = fastMethod;
        if (index < 0) {
            throw new IllegalArgumentException("Invalid negative index value");
        }
    }

    public final Object get(EventBean obj) throws PropertyAccessException {
        Object underlying = obj.getUnderlying();
        try {
            Object value = this.fastMethod.invoke(underlying, null);
            if (Array.getLength(value) <= this.index) {
                return null;
            }
            return Array.get(value, this.index);
        }
        catch (ClassCastException e) {
            throw new PropertyAccessException("Mismatched getter instance to event bean type");
        }
        catch (InvocationTargetException e) {
            throw new PropertyAccessException(e);
        }
    }

    public String toString() {
        return "ArrayFastPropertyGetter  fastMethod=" + this.fastMethod.toString() + " index=" + this.index;
    }

    public boolean isExistsProperty(EventBean eventBean) {
        return true;
    }
}

