/*
 * Decompiled with CFR 0.152.
 */
package net.esper.event.property;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.esper.event.EventBean;
import net.esper.event.EventPropertyGetter;
import net.esper.event.PropertyAccessException;

public class ArrayMethodPropertyGetter
implements EventPropertyGetter {
    private final Method method;
    private final int index;

    public ArrayMethodPropertyGetter(Method method, int index) {
        this.index = index;
        this.method = method;
        if (index < 0) {
            throw new IllegalArgumentException("Invalid negative index value");
        }
    }

    public final Object get(EventBean obj) throws PropertyAccessException {
        Object underlying = obj.getUnderlying();
        try {
            Object value = this.method.invoke(underlying, null);
            if (Array.getLength(value) <= this.index) {
                return null;
            }
            return Array.get(value, this.index);
        }
        catch (ClassCastException e) {
            throw new PropertyAccessException("Mismatched getter instance to event bean type");
        }
        catch (InvocationTargetException e) {
            throw new PropertyAccessException(e);
        }
        catch (IllegalAccessException e) {
            throw new PropertyAccessException(e);
        }
        catch (IllegalArgumentException e) {
            throw new PropertyAccessException(e);
        }
    }

    public String toString() {
        return "ArrayMethodPropertyGetter  method=" + this.method.toString() + " index=" + this.index;
    }

    public boolean isExistsProperty(EventBean eventBean) {
        return true;
    }
}

